/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.core.bpel;

import java.util.HashMap;

import org.eclipse.stp.b2j.core.jengine.internal.core.Runner;

/**
 * 
 * @author amiguel
 * 
 * Part of the generic runtime engine API, used to help implement BPEL partner links.
 */
public class BPELPartnerLink {
	public WSEndpointReference myRole;
	public WSEndpointReference partnerRole;

//	public void t() throws Exception {
//		WSEndpointReference.fromXML(WSEndpointReference.toXML(partnerRole));
//	}
	
	public static void setPartnerLink(String name,BPELPartnerLink link) {
		Runner r = (Runner)Thread.currentThread();
		HashMap map = r.getEngineLocalStorageMap("BPELPartnerLinks");
		map.put(name,link);
	}
	
	public static BPELPartnerLink getPartnerLink(String name) {
		Runner r = (Runner)Thread.currentThread();
		HashMap map = r.getEngineLocalStorageMap("BPELPartnerLinks");
		return (BPELPartnerLink)map.get(name);
	}
}