/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal;

import java.util.ArrayList;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.BPELProperty;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.BPELPropertyAlias;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xpath.XPATHTreeTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDRootElement;
import org.eclipse.stp.b2j.core.jengine.internal.utils.CharStack;
import org.eclipse.stp.b2j.core.jengine.internal.utils.TranslatorUtils;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLTypeTranslator;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.XSDTypeTranslator;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.XSDTypeTranslatorException;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;

/**
 * 
 * @author amiguel
 *
 * The XML translator for XSD types
 */
public class XMLCodec implements XSDTypeTranslator, WSDLTypeTranslator {

XSDMap xsdmap;
WSDLMap wsdlmap;

Util compiler_util;

ClassLoader dependancy_loader;

private static int NSPACE = 1;

StringBuffer methods = new StringBuffer();

//ArrayList topLevelMappings = new ArrayList();

ArrayList alltypes = new ArrayList();

int XPATHID = 1;

private String getNextXPath() {
	return "xpath_property_expr"+XPATHID++;
}

	public void init(Util compiler_util, XSDMap xsdmap, WSDLMap wsdlmap, ClassLoader dependancy_loader) {
		this.xsdmap = xsdmap;
		this.wsdlmap = wsdlmap;
		this.dependancy_loader = dependancy_loader;
		this.compiler_util = compiler_util;
	}

	public void readWSDL(Element definitions) {
		//this codec doesn't need any extra annotation in the WSDL
	}
	
	public void translateComplex(NamespaceTranslator nt, String name, String[] atypes, String[] anames, String[] types, String[] names, String[] elem_names, Element complex) throws NamespaceException, XSDTypeTranslatorException {
		methods.setLength(0);

		String originalNamespace = nt.getNamespace(name,true);
		String originalName = NamespaceTranslator.getName(name);
		
		String classname = NamespaceTranslator.getJavaClassName(name);

		alltypes.add(nt.qualify(name,true));
		
		String qtype_complex = nt.qualify(name,true);
		
		//
		// toString method
		//

		methods.append("\n");
		methods.append("  public String toString() {\n");
		methods.append("    try {\n");
		methods.append("      return toXML(this);\n");
		methods.append("    } catch (Exception e) {\n");
		methods.append("      return getStackTrace(e);\n");
		methods.append("    }\n");
		methods.append("  }\n");

		methods.append("  public void appendXpathStringValue(StringBuffer sb) {\n");
		methods.append("    try {\n");
		methods.append("      toXML(this,sb,false,false);\n");
		methods.append("    } catch (Exception e) {\n");
		methods.append("      sb.append(getStackTrace(e));\n");
		methods.append("    }\n");
		methods.append("  }\n");
		methods.append("  public String toXpathStringValue() {\n");
		methods.append("    try {\n");
		methods.append("      StringBuffer sb = new StringBuffer();\n");
		methods.append("      appendXpathStringValue(sb);\n");
		methods.append("      return sb.toString();\n");
		methods.append("    } catch (Exception e) {\n");
		methods.append("      return getStackTrace(e);\n");
		methods.append("    }\n");
		methods.append("  }\n");
		methods.append("  public Double toXpathNumber() {\n");
		methods.append("    return null;\n");
		methods.append("  }\n");

		//
		// TO
		// 		
		methods.append("\n");
		methods.append("  public static String toXML(Object jobj) throws Exception {\n");
		methods.append("    //"+name+"\n");
		methods.append("    "+classname+" obj = ("+classname+")jobj;\n");
		methods.append("    StringBuffer sb = new StringBuffer();\n");
		methods.append("    toXML(obj,sb,true,false);\n");
		methods.append("    return sb.toString();\n");
		methods.append("  }\n");

		methods.append("\n");
		methods.append("  public static String toXMLNoRootTags(Object jobj, boolean withType) throws Exception {\n");
		methods.append("    //"+name+"\n");
		methods.append("    "+classname+" obj = ("+classname+")jobj;\n");
		methods.append("    StringBuffer sb = new StringBuffer();\n");
		//append all the elements
		for (int i = 0; i < types.length; i++) {
			methods.append("      for (int i = 0; i < obj."+NamespaceTranslator.getElement(names[i])+".length; i++) {\n");
			methods.append("        if (obj != null) {\n");
			methods.append("          obj."+NamespaceTranslator.getElement(names[i])+"[i]."+NamespaceTranslator.getElementTagName()+" = \""+elem_names[i]+"\";\n");
			methods.append("          "+types[i]+".toXML(obj."+NamespaceTranslator.getElement(names[i])+"[i],sb,true,withType);\n");
			methods.append("        }\n");
			methods.append("      }\n");
		}
		methods.append("    return sb.toString();\n");
		methods.append("  }\n");
		

		methods.append("  public static void toXML(Object jobj, StringBuffer sb, boolean withTags, boolean withType) throws Exception {\n");
		methods.append("    //"+name+"\n");
		methods.append("    "+classname+" obj = ("+classname+")jobj;\n");

		String ns = nt.getNamespace(name,true);
		name = NamespaceTranslator.getName(name);

//		methods.append("    StringBuffer sb = new StringBuffer();\n");
		
//		methods.append("    if (base) sb.append(\"<?xml version=\\\"1.0\\\"?>\");\n");
		
		String nsname = name;
		
		if (ns.length() > 0) {
			nsname = "ns"+NSPACE+":"+name;
		}

		methods.append("    String tmp_tag = obj."+NamespaceTranslator.getElementTagName()+";\n");
		methods.append("    if (tmp_tag == null) {\n");
		methods.append("      tmp_tag = \""+originalName+"\";\n");
		methods.append("    }\n");
		
		methods.append("    if (obj == null) {\n");

		methods.append("      sb.append(\"<\");\n");
		methods.append("      sb.append(tmp_tag);\n");
		methods.append("      sb.append(\" xmlns:ns"+NSPACE+"=\\\""+ns+"\\\" \");\n");
		methods.append("      sb.append(\" xlmns:xsi=\\\""+NamespaceTranslator.NAMESPACE_XSI+"\\\" \");\n");
        methods.append("      sb.append(\" xsi:nil=\\\"true\\\" />\");\n");
		
		methods.append("    } else {\n");
		
		methods.append("      if (withTags) {\n");

		if (ns.length() > 0) {
			// complex type name + namespace
			methods.append("        sb.append(\"<\");\n");
			methods.append("        sb.append(tmp_tag);\n");
			methods.append("        sb.append(\" xmlns=\\\""+ns+"\\\" \");\n");
//			methods.append("        sb.append(\" xmlns:ns"+NSPACE+"=\\\""+ns+"\\\"\");\n");
		} else {
			//just complex type name (no namespace)
			methods.append("        sb.append(\"<\");\n");
			methods.append("        sb.append(tmp_tag);\n");
			methods.append("        sb.append(\" xmlns=\\\""+ns+"\\\" \");\n");
		}

		// XSI TYPE
		methods.append("        if (withType) {\n");
		methods.append("          sb.append(\" xmlns:xsi=\\\""+TranslatorUtils.toJavaStringStrict(NamespaceTranslator.NAMESPACE_XSI)+"\\\" \");\n");
		methods.append("          sb.append(\" xmlns:typens=\\\""+TranslatorUtils.toJavaStringStrict(originalNamespace)+"\\\" \");\n");
		methods.append("          sb.append(\" xsi:type=\\\"typens:"+originalName+"\\\" \");\n");
		methods.append("        }\n");
		
		//append all the attributes
		for (int i = 0; i < atypes.length; i++) {
			methods.append("        if (obj."+NamespaceTranslator.getAttribute(anames[i])+" != null) {\n");
			methods.append("          sb.append(\" "+anames[i]+"=\\\"\");\n");
			methods.append("          "+atypes[i]+".toXML(obj."+NamespaceTranslator.getAttribute(anames[i])+",sb,false,false);\n");
			methods.append("          sb.append(\"\\\" \");\n");
			methods.append("        }\n");
		}
		methods.append("        sb.append(\" >\");\n");

		methods.append("      }//end if withTags\n");
		
		//append all the elements
		for (int i = 0; i < types.length; i++) {
			methods.append("      for (int i = 0; i < obj."+NamespaceTranslator.getElement(names[i])+".length; i++) {\n");
			methods.append("        obj."+NamespaceTranslator.getElement(names[i])+"[i]."+NamespaceTranslator.getElementTagName()+" = \""+elem_names[i]+"\";\n");
			methods.append("        "+types[i]+".toXML(obj."+NamespaceTranslator.getElement(names[i])+"[i],sb,withTags,withType);\n");
			methods.append("      }\n");
		}
		
		methods.append("      if (withTags) {\n");
		methods.append("        sb.append(\"</\");\n");
		methods.append("        sb.append(tmp_tag);\n");
		methods.append("        sb.append(\">\");\n");
		methods.append("      }//end if withTags\n");

		methods.append("      \n");

		methods.append("    }\n");

		methods.append("  }\n");
	
		NSPACE++;
		
	
		//
		// XMLAccessible methods
		//

		methods.append("\n");
		methods.append("  public Object ifromXML(String tmp) throws Exception {\n");
		methods.append("    return fromXML(tmp);\n");
		methods.append("  }\n");

		methods.append("\n");
		methods.append("  public XNodeSet getBpelProperty(String propertyName) throws Exception {\n");

		boolean must_close_if = false;
		
		ArrayList xpath_property_expressions = new ArrayList();
		
		BPELPropertyAlias[] aliases = wsdlmap.getPropertyAliases();
		for (int i = 0; i < aliases.length; i++) {
//			String qxsdType;
//			try {
//				qxsdType = aliases[i].getQualifiedUnderlyingXsdType(wsdlmap,xsdmap);
//			} catch (Exception e) {
//				throw new XSDCodecTranslatorException(""+e);
//			}
			String baseType = aliases[i].getQualifiedXsdType();
			String query_prefix = "";
			if (baseType == null) {
				baseType = aliases[i].getQualifiedXsdElementType();
			}
			if (baseType == null) {
				baseType = aliases[i].getQualifiedWsdlMessageType();
				query_prefix = "/"+aliases[i].getWsdlMessagePart();
			}

			if (baseType.equals(qtype_complex)) {
				//this property alias is for this complex type
				
				BPELProperty property = wsdlmap.getProperty(aliases[i].getQualifiedPropertyName());
				
				if (must_close_if == true) {
					methods.append("    } else");
				}
				
				methods.append("    if (propertyName.equals(\""+property.getQName()+"\")) {\n");

				methods.append("      XNodeSet nsInitial = XPU.getSingleNodeSet( \"unknown\", this, null, 0);\n");
				
				//get XPATH to return a XNodeSet corresponding to the query
				String query = aliases[i].getQuery();
				
				//in the case of WSDL messages, we must first get the relevant part
				query = query_prefix + query;
				
				//TODO Need to sort out an XPATH function that returns a nodeset after compiling a variable
				//in from a function argument - see the xpath translator to see what it requires to represent a variable
				//methods.append("    return "+xpath_method+"();\n");
				try {
					XPATHTreeTranslator resolver = new XPATHTreeTranslator();
					String xpath_method = getNextXPath();
					String expr = resolver.resolveVariableQueryToNodeSet(xpath_method,query,compiler_util,nt,wsdlmap,null);
					xpath_property_expressions.add(expr);
					
//					methods.append("      System.out.println(\"PROPERTY == \"+"+xpath_method+"(nsInitial));\n");
					methods.append("      return "+xpath_method+"(nsInitial);\n");
		
				} catch (Exception e) {
					throw new XSDTypeTranslatorException("Failed to generate XPATH function for property "+property.getQName()+" query "+e);
				}

				must_close_if = true;
			}
		}
		
		if (must_close_if) {
			methods.append("    }\n");
		}

		methods.append("    throw new Exception(\"Property \"+propertyName+\" not found for type \"+getClass().getName());\n");
		methods.append("  }\n");
		
		//Append all the XPATH expressions we used above
		for (int i = 0; i < xpath_property_expressions.size(); i++) {
			methods.append(xpath_property_expressions.get(i).toString());
		}
		
		
		//
		// FROM
		//

		methods.append("  public static Object fromXML(String tmp) throws Exception {\n");
		methods.append("    NamespaceTranslator nt = new NamespaceTranslator(\""+compiler_util.getProgramPrefix()+"\");\n");
		methods.append("  	Object o = fromXML(new CharStack(tmp),nt,true);\n");
		methods.append("  	return o;\n");
		methods.append("  }\n");

		methods.append("  public static Object fromXMLNoRootTags(String strtmp) throws Exception {\n");
		methods.append("    NamespaceTranslator nt = new NamespaceTranslator(\""+compiler_util.getProgramPrefix()+"\");\n");
		methods.append("    CharStack tmp = new CharStack(strtmp);\n");
		methods.append("  	"+classname+" obj = new "+classname+"();\n");
		
		//parse child elements only
		generateParseChildren(methods,names,elem_names,types,classname);
		
		methods.append("  	return obj;\n");
		methods.append("  }\n");
		
		
		methods.append("  public static Object fromXML(CharStack tmp, NamespaceTranslator nt, boolean withTags) throws Exception {\n");
		methods.append("    //"+name+"\n");
		
		methods.append("System.out.println(\"READING "+name+" FROM \"+tmp+\"\");\n");
		
		//withTags is always ignored but it must be there to override anyType.fromXML
		
		//create the object
		methods.append("  	"+classname+" obj = new "+classname+"();\n");
		
		//mark beginning so we can push back if we need to
//		methods.append("  	tmp.mark();\n");
		
		//get the element name
		methods.append("    obj."+NamespaceTranslator.getElementTagName()+" = tmp.popXmlElementStart();\n");
		//check name is ok
//We dont need to care about the name - the name could be anything		
//could be some random name under some complex type
//		methods.append("    if (!name.equals(\""+name+"\")) {\n");
//		methods.append("      tmp.resetToMark();\n");
//		methods.append("      return null;\n");
//		methods.append("    }\n");

		
		//parse the attributes
		methods.append("    String attname = tmp.popXmlAttributeName();\n");
		methods.append("    while (attname.length() > 0) {\n");
		methods.append("      String attvalue = tmp.popXmlAttributeValue();\n");
		methods.append("      //attempt to parse namespace attribute\n");
		methods.append("      if (!nt.addNamespace(attname,attvalue)) {\n");
		methods.append("        //normal attribute - set value\n");
		for (int i = 0; i < anames.length; i++) {

			if (i == 0) {
				methods.append("        if (");
			} else {
				methods.append("        } else if (");
			}

			//name checking
			methods.append("attname.equals(\""+anames[i]+"\")");

			methods.append(") {\n");

			//sub-parsing
			String aname = NamespaceTranslator.getAttribute(anames[i]);
			methods.append("          //parse the object without looking for element tags;\n");
			methods.append("          obj."+aname+" = ("+atypes[i]+") "+atypes[i]+".fromXML(new CharStack(attvalue),nt,false);\n");
			
			if (i == anames.length-1) {
				methods.append("        } else {\n");
				methods.append("          throw new Exception(\"error parsing "+classname+", found unexpected attribute '\"+attname+\"' \");\n");
				methods.append("        }\n");
			}
		}
		methods.append("      }\n");
		methods.append("      //next attribute\n");
		methods.append("      attname = tmp.popXmlAttributeName();\n");
		methods.append("    }\n");

		//pop the end of the start tag
		methods.append("    tmp.popXmlElementEnd();\n");
		
		//parse child elements
		generateParseChildren(methods,names,elem_names,types,classname);
		
		//parse the end tag
		methods.append("    //parse the remaining end tag\n");
		methods.append("    tmp.popXmlElementEnd();\n");
		methods.append("    return obj;\n");
		methods.append("  }\n");

		//TODO need to remove namespaces here
	}
	
	private void generateParseChildren(StringBuffer methods, String[] names, String[] elem_names, String[] types, String classname) {
		//parse the child elements
		methods.append("    //peek the child tag name\n");
		methods.append("    tmp.mark();\n");
		methods.append("    String childnamefull = tmp.popXmlElementStart();\n");
		methods.append("    String childname = NamespaceTranslator.getName(childnamefull);\n");
		methods.append("    tmp.resetToMark();\n");
		methods.append("    while (childname.length() > 0 && childname.charAt(0) != '/') {\n");
		for (int i = 0; i < names.length; i++) {
			if (i == 0) {
				methods.append("      if (");
			} else {
				methods.append("      } else if (");
			} 
			
			//name checking
			methods.append("childname.equals(\""+elem_names[i]+"\")");

			methods.append(") {\n");
			
			//sub-parsing
			String ename = NamespaceTranslator.getElement(names[i]);
			methods.append("        "+types[i]+" etmp[] = new "+types[i]+"[obj."+ename+".length+1];\n");
			methods.append("        System.arraycopy(obj."+ename+",0,etmp,0,obj."+ename+".length);\n");
			methods.append("        etmp[etmp.length-1] = ("+types[i]+") "+types[i]+".fromXML(tmp,nt,true);\n");
			methods.append("        etmp[etmp.length-1]."+NamespaceTranslator.getElementTagName()+" = \""+elem_names[i]+"\";\n");
			methods.append("        obj."+ename+" = etmp;\n");
			
			if (i == names.length-1) {
				methods.append("      } else {\n");
				methods.append("        throw new Exception(\"error parsing "+classname+", found unexpected element '\"+childname+\"' ('\"+childnamefull+\"') \");\n");
				methods.append("      }\n");
			}
		}
		methods.append("      tmp.mark();\n");
		methods.append("      childname = tmp.popXmlElementStart();\n");
		methods.append("      tmp.resetToMark();\n");
		methods.append("    }//end while\n");
	}

	public void translateSimple(NamespaceTranslator nt, String name, String base, Element simple) throws XSDTypeTranslatorException, NamespaceException {
		methods.setLength(0);

		alltypes.add(nt.qualify(name,true));
		
		String listType = Util.getSimpleTypeListType(nt,simple);
		
		//just treat this as its base type
		translateBase(nt,base,name,listType);
	}

	public void translateBase(NamespaceTranslator nt, String name) throws XSDTypeTranslatorException, NamespaceException {
		translateBase(nt,name,name,XSDTypeTranslator.XSD_TYPE_ANYTYPE);
	}
	
	public void translateBase(NamespaceTranslator nt, String name, String realname, String listType) throws XSDTypeTranslatorException, NamespaceException {
		methods.setLength(0);

		String originalNamespace = nt.getNamespace(name,false);
		String originalName = NamespaceTranslator.getName(name);
		
		String realname_only = NamespaceTranslator.getName(realname);
		
		name = nt.qualify(name,false);

		alltypes.add(name);
		
		String qlistType = nt.qualify(listType,false);
		
		String classname = nt.qualify(realname,true);

		//
		// toString method
		//
		methods.append("\n");
		methods.append("  public String toString() {\n");
		methods.append("    try {\n");
		methods.append("      return toXML(this);\n");
		methods.append("    } catch (Exception e) {\n");
		methods.append("      return getStackTrace(e);\n");
		methods.append("    }\n");
		methods.append("  }\n");

		if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_ANYTYPE,false))) {
			
			//
			// XSD:ANYTYPE SPECIAL CASE
			//
			
			methods.append("\n");
			methods.append("public static String getStackTrace(Throwable t) {\n");
			methods.append("    try {\n");
			methods.append("  	  java.io.ByteArrayOutputStream bout = new java.io.ByteArrayOutputStream();\n");
			methods.append("	  t.printStackTrace(new java.io.PrintStream(bout));\n");
			methods.append("	  return new String(bout.toByteArray());\n");
			methods.append("    } catch (Exception e) { return t.toString(); }\n");
			methods.append("}\n");
			methods.append("\n");
			
			//Default to returning null for XPATH number value
			methods.append("  public Double toXpathNumber() {\n");
			methods.append("    return null;\n");
			methods.append("  }\n");
			
			//NOTE no XPATH stringValue for anyType - everything inherits from it anyway
			methods.append("  public abstract void appendXpathStringValue(StringBuffer sb);\n");
			methods.append("  public abstract String toXpathStringValue();\n");

			methods.append("  private static java.util.HashMap xmlcodec_nameToType = new java.util.HashMap();\n");
			methods.append("  static {\n");
			methods.append("    Class[] fromXmlArgs = new Class[]{CharStack.class,NamespaceTranslator.class,boolean.class};\n");
			methods.append("    ClassLoader cl = "+nt.qualify(XSDTypeTranslator.XSD_TYPE_ANYTYPE,false)+".class.getClassLoader();\n");
			methods.append("    try {\n");
			
			for (int i = 0; i < xsdmap.getRootElementCount(); i++) {
				XSDRootElement root = xsdmap.getRootElement(i);
				methods.append("      xmlcodec_nameToType.put(\""+root.getNCName()+"\",cl.loadClass(\""+root.getQualifiedType()+"\").getDeclaredMethod(\"fromXML\",fromXmlArgs));\n");
			}
			methods.append("    } catch (Exception e) {\n");
			methods.append("      Logger.error(\"Failed to generate top level element mappings for XSD codec\",e);\n");
			methods.append("    }\n");
			methods.append("  }\n");

			methods.append("  public static java.util.HashMap xmlcodec_typeToName = new java.util.HashMap();\n");
			methods.append("  static {\n");
			methods.append("    ClassLoader cl = "+nt.qualify(XSDTypeTranslator.XSD_TYPE_ANYTYPE,false)+".class.getClassLoader();\n");
			methods.append("    try {\n");
			for (int i = 0; i < xsdmap.getRootElementCount(); i++) {
				XSDRootElement root = xsdmap.getRootElement(i);
				methods.append("      xmlcodec_typeToName.put(cl.loadClass(\""+root.getQualifiedType()+"\"),\""+root.getNCName()+"\");\n");
			}
			methods.append("    } catch (Exception e) {\n");
			methods.append("      Logger.error(\"Failed to generate top level element mappings for XSD codec\",e);\n");
			methods.append("    }\n");
			methods.append("  }\n");

			methods.append("  static java.util.HashMap xmlcodec_mapped = new java.util.HashMap();\n");
			methods.append("  static java.util.HashMap xmlcodec_mapped2 = new java.util.HashMap();\n");
			methods.append("  static {\n");
			methods.append("    Class[] toXmlArgs = new Class[]{Object.class};\n");
			methods.append("    Class[] toXmlArgs2 = new Class[]{Object.class,StringBuffer.class,boolean.class,boolean.class};\n");
			methods.append("    ClassLoader cl = "+nt.qualify(XSDTypeTranslator.XSD_TYPE_ANYTYPE,false)+".class.getClassLoader();\n");
			methods.append("    try {\n");
			for (int i = 0; i < alltypes.size(); i++) {
				String typ = (String)alltypes.get(i);
				methods.append("      xmlcodec_mapped.put(cl.loadClass(\""+typ+"\"),cl.loadClass(\""+typ+"\").getDeclaredMethod(\"toXML\",toXmlArgs));\n");
				methods.append("      xmlcodec_mapped2.put(cl.loadClass(\""+typ+"\"),cl.loadClass(\""+typ+"\").getDeclaredMethod(\"toXML\",toXmlArgs2));\n");
			}
			methods.append("    } catch (Exception e) {\n");
			methods.append("      Logger.error(\"Failed to generate class to toXML method mappings for XSD codec\",e);\n");
			methods.append("    }\n");
			methods.append("  }\n");
			methods.append("  \n");
			methods.append("  public static String toXML(Object tmp) throws Exception {\n");
			methods.append("    java.lang.reflect.Method method = (java.lang.reflect.Method)xmlcodec_mapped.get(tmp.getClass());\n");
			methods.append("    return (String)method.invoke(null,new Object[]{tmp});\n");
			methods.append("  }\n");

			methods.append("  public static void toXML(Object tmp, StringBuffer sb, boolean withTags, boolean withType) throws Exception {\n");
			methods.append("    java.lang.reflect.Method method = (java.lang.reflect.Method)xmlcodec_mapped2.get(tmp.getClass());\n");
			methods.append("    method.invoke(null,new Object[]{tmp,sb,new Boolean(withTags),new Boolean(withType)});\n");
			methods.append("  }\n");
		

			methods.append("  public static Object fromXML(String tmp) throws Exception {\n");
			methods.append("      return fromXML(new CharStack(tmp), new NamespaceTranslator(\""+compiler_util.getProgramPrefix()+"\"),true);\n");
			methods.append("  }\n");

			// Special extra FROM method for when we're parsing complex objects
			methods.append("\n");
			methods.append("  public static Object fromXML(CharStack cs, NamespaceTranslator nt, boolean withTags) throws Exception {\n");
			methods.append("    if (!withTags) return "+NamespaceTranslator.getJavaClassName(XSDTypeTranslator.XSD_TYPE_STRING)+".fromXML(cs,nt,false);\n");
			methods.append("    try {\n");
			methods.append("      cs.mark();\n");
			methods.append("      String elem_name = cs.popXmlElementStart();\n");
			methods.append("      cs.resetToMark();\n");
			methods.append("      java.lang.reflect.Method method = (java.lang.reflect.Method)"+nt.qualify(XSDTypeTranslator.XSD_TYPE_ANYTYPE,false)+".xmlcodec_nameToType.get(elem_name);\n");
			methods.append("      Object ret = method.invoke(null,new Object[]{cs,nt,new Boolean(withTags)});\n");
//			methods.append("Logger.direct(\"XSD ANY TYPE FROM XML - RETURNING \"+ret.getClass()+\" \"+ret+\" (\"+tmp+\")\");\n");
			methods.append("      return ret;\n");
			methods.append("    } catch (Exception e) {\n");
//			methods.append("Logger.error(\"XSD ANY TYPE FROM XML - RETURNING STRING (\"+tmp+\")\",e);\n");
//			methods.append("Logger.direct(\"XSD ANY TYPE FROM XML - RETURNING STRING (\"+tmp+\")\");\n");
			methods.append("      //we dont know what this is, pass it around as a string - tags and all\n");
			methods.append("      return "+NamespaceTranslator.getJavaClassName(XSDTypeTranslator.XSD_TYPE_STRING)+".fromXML(cs,nt,false);\n");
			methods.append("    }\n");
			methods.append("  }\n");
			
		} else {
			//
			// BASE SIMPLE TYPES
			//
	
			//
			// CONSTRUCTOR
			//
//			methods.append("  public "+nt.getJavaClassName(realname)+"(String xml) throws Exception {\n");
//			methods.append("    fromXML(xml);\n");
//			methods.append("  }\n");
			
			//
			// TO method
			//
			
			
			if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DECIMAL,false))
					|| name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_FLOAT,false))
					|| name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DOUBLE,false))) {
				
				methods.append("  public Double toXpathNumber() {\n");
				methods.append("    return INTERNAL_VALUE;\n");
				methods.append("  }\n");
				
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_INTEGER,false))
					|| name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_POSITIVEINTEGER,false))
					|| name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NEGATIVEINTEGER,false))
					|| name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NONPOSITIVEINTEGER,false))
					|| name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_INT,false))
					|| name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_UNSIGNEDINT,false))
					|| name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_LONG,false))
					|| name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_UNSIGNEDLONG,false))
					|| name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_SHORT,false))
					|| name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_UNSIGNEDSHORT,false))
					) {
				
				methods.append("  public Double toXpathNumber() {\n");
				methods.append("    return new Double(INTERNAL_VALUE.doubleValue());\n");
				methods.append("  }\n");
			}
			
			methods.append("  public void appendXpathStringValue(StringBuffer sb) {\n");
			methods.append("    try {\n");
			methods.append("      toXML(this,sb,false,false);\n");
			methods.append("    } catch (Exception e) {\n");
			methods.append("      sb.append(getStackTrace(e));\n");
			methods.append("    }\n");
			methods.append("  }\n");
			methods.append("  public String toXpathStringValue() {\n");
			methods.append("    try {\n");
			methods.append("      StringBuffer sb = new StringBuffer();\n");
			methods.append("      appendXpathStringValue(sb);\n");
			methods.append("      return sb.toString();\n");
			methods.append("    } catch (Exception e) {\n");
			methods.append("      return getStackTrace(e);\n");
			methods.append("    }\n");
			methods.append("  }\n");

			methods.append("\n");
			methods.append("  public static String toXML(Object jobj) throws Exception {\n");
			methods.append("    //"+name+"\n");
			methods.append("    "+classname+" obj = ("+classname+")jobj;\n");
			methods.append("    StringBuffer sb = new StringBuffer();\n");
			methods.append("    toXML(obj,sb,false,false);\n");
			methods.append("    return sb.toString();\n");
			methods.append("  }\n");
			
			methods.append("  public static void toXML(Object jobj, StringBuffer sb, boolean withTags, boolean withType) throws Exception {\n");
			methods.append("    //"+name+"\n");
			methods.append("    "+classname+" tmp = ("+classname+")jobj;\n");

			methods.append("    String tmp_tag = tmp."+NamespaceTranslator.getElementTagName()+";\n");
			methods.append("    if (tmp_tag == null) {\n");
			methods.append("      tmp_tag = \""+realname_only+"\";\n");
			methods.append("    }\n");
			
//			methods.append("    if (withTags && tmp."+NamespaceTranslator.getTagName()+" != null) {;\n");
			methods.append("    if (withTags) {;\n");
			methods.append("        sb.append(\"<\");\n");
			methods.append("        sb.append(tmp_tag);\n");
			
			// XSI TYPE
			methods.append("        if (withType) {\n");
			methods.append("          sb.append(\" xmlns:xsi=\\\""+TranslatorUtils.toJavaStringStrict(NamespaceTranslator.NAMESPACE_XSI)+"\\\" \");\n");
			methods.append("          sb.append(\" xmlns:typens=\\\""+TranslatorUtils.toJavaStringStrict(originalNamespace)+"\\\" \");\n");
			methods.append("          sb.append(\" xsi:type=\\\"typens:"+originalName+"\\\" \");\n");
			methods.append("        }\n");
			
			// XSI NIL? (null)
			methods.append("        if (tmp.INTERNAL_VALUE == null) {\n");
			methods.append("             sb.append(\" xsi:nil=\\\"true\\\" \");\n");
			methods.append("        }\n");
			
			methods.append("        sb.append(\">\");\n");
//			methods.append("      sb.append(\"<"+classname+">\");\n");
			methods.append("    };\n");
	
			methods.append("    if (tmp.INTERNAL_VALUE != null) {\n");
			
			if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_STRING,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NORMALIZEDSTRING,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_TOKEN,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_BYTE,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_UNSIGNEDBYTE,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_BASE64BINARY,false))) {
				//TODO change native types of base64binary and hexbinary to byte[]?
				//why bother? its just an internal rep - probably easier to convert to/from string
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_HEXBINARY,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_INTEGER,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE.longValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_POSITIVEINTEGER,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE.longValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NEGATIVEINTEGER,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE.longValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NONPOSITIVEINTEGER,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE.longValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NONNEGATIVEINTEGER,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE.longValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_INT,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE.longValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_UNSIGNEDINT,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE.longValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_LONG,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE.longValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_UNSIGNEDLONG,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE.longValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_SHORT,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE.longValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_UNSIGNEDSHORT,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE.longValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DECIMAL,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE.doubleValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_FLOAT,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE.doubleValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DOUBLE,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE.doubleValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_BOOLEAN,false))) {
				methods.append("    sb.append(tmp.INTERNAL_VALUE.booleanValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_TIME,false))) {
				methods.append("    sb.append(XSDUtil.toTime(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DATETIME,false))) {
				methods.append("    sb.append(XSDUtil.toDateTime(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DURATION,false))) {
				methods.append("    sb.append(XSDUtil.toDuration(tmp.INTERNAL_VALUE.longValue()));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DATE,false))) {
				methods.append("    sb.append(XSDUtil.toDate(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_GMONTH,false))) {
				methods.append("    sb.append(XSDUtil.toGMonth(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_GYEAR,false))) {
				methods.append("    sb.append(XSDUtil.toGYear(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_GYEARMONTH,false))) {
				methods.append("    sb.append(XSDUtil.toGYearMonth(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_GDAY,false))) {
				methods.append("    sb.append(XSDUtil.toGDay(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_GMONTHDAY,false))) {
				methods.append("    sb.append(XSDUtil.toGMonthDay(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NAME,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_QNAME,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NCNAME,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_ANYURI,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_LANGUAGE,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_ID,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_IDREF,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_IDREFS,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_ENTITY,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_ENTITIES,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NOTATION,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NMTOKEN,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NMTOKENS,false))) {
				methods.append("    sb.append(XSDUtil.toXMLString(tmp.INTERNAL_VALUE));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_LIST,false))) {
//				methods.append("    result = \"\";\n");
				methods.append("    for (int k = 0; k < tmp.INTERNAL_VALUE.size(); k++) {\n");
				methods.append("      sb.append(XSDUtil.toXMLString("+qlistType+".toXML(tmp.INTERNAL_VALUE.get(k))));\n");
				methods.append("      sb.append(' ');\n");
				methods.append("    }\n");
			}
			
			//Escape any characters necessary
//			methods.append("    result = XSDUtil.toXMLString(result);\n");
			
			//Append the result
//			methods.append("    if (tmp.INTERNAL_VALUE != null) {\n");
//			methods.append("        sb.append(result);\n");
			methods.append("    }\n");

//			methods.append("    if (withTags && tmp."+NamespaceTranslator.getTagName()+" != null) {;\n");
			methods.append("    if (withTags) {;\n");
			methods.append("        sb.append(\"</\");\n");
			methods.append("        sb.append(tmp_tag);\n");
			methods.append("        sb.append(\">\");\n");
//			methods.append("      sb.append(\"</"+classname+">\");\n");
			methods.append("    };\n");

			methods.append("  }\n");
	
			
			//
			// XMLAccessible methods
			// these methods allow us to use an instance of an object to parse another instance of it
			// that means we don't always have to use the static class methods so we dont always have
			// to know the class.
			// Also, it makes anyType.fromXml faster because we can create one instance and just use 
			// that instance's methods rather than using reflection to invoke the static methods all
			// the time
			//

			methods.append("\n");
			methods.append("  public Object ifromXML(String tmp) throws Exception {\n");
			methods.append("    return fromXML(tmp);\n");
			methods.append("  }\n");

			methods.append("  public XNodeSet getBpelProperty(String propertyName) throws Exception {\n");
			methods.append("    throw new Exception(\"Property \"+propertyName+\" not found for type \"+getClass().getName());\n");
			methods.append("  }\n");
			
			//
			// FROM method
			//
			
			// Special extra FROM method for when we're parsing complex objects
			methods.append("\n");
			methods.append("  public static Object fromXML(String tmp) throws Exception {\n");
			methods.append("    //"+name+"\n");
			methods.append("    return fromXML(new CharStack(tmp),new NamespaceTranslator(\""+compiler_util.getProgramPrefix()+"\"),false);\n");
			methods.append("  }\n");
			
			methods.append("\n");
			methods.append("  public static Object fromXML(CharStack cs, NamespaceTranslator nt) throws Exception {\n");
			methods.append("    //"+name+"\n");
			methods.append("    return fromXML(cs,nt,true);\n");
			methods.append("  }\n");
			methods.append("  public static Object fromXML(CharStack cs, NamespaceTranslator nt, boolean withTags) throws Exception {\n");
			methods.append("    //"+name+"\n");
			methods.append("    "+classname+" obj = new "+classname+"();\n");

			methods.append("    if (withTags) {\n");
			methods.append("      obj."+NamespaceTranslator.getElementTagName()+" = cs.popXmlElementStart();\n");
			methods.append("      cs.popXmlAttributes();\n");
			methods.append("   	  cs.popXmlElementEnd();\n");
			methods.append("    }\n");
//			methods.append("    String tmp = cs.popXmlText(true);\n");
			methods.append("    String tmp = cs.popXmlSubTree(true);\n");
			methods.append("    if (withTags) {\n");
			methods.append("      cs.popXmlElementStart();\n");
			methods.append("      cs.popXmlElementEnd();\n");
			methods.append("    }\n");

			//Convert escaped characters before attempting to parse
			methods.append("    tmp = XSDUtil.fromXMLString(tmp);\n");
			
			if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_STRING,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NORMALIZEDSTRING,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_TOKEN,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_BYTE,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Integer(new Double(XSDUtil.removeXmlComments(tmp)).intValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_UNSIGNEDBYTE,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Integer(new Double(XSDUtil.removeXmlComments(tmp)).intValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_BASE64BINARY,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_HEXBINARY,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_INTEGER,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Integer(new Double(XSDUtil.removeXmlComments(tmp)).intValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_POSITIVEINTEGER,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Integer(new Double(XSDUtil.removeXmlComments(tmp)).intValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NEGATIVEINTEGER,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Integer(new Double(XSDUtil.removeXmlComments(tmp)).intValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NONPOSITIVEINTEGER,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Integer(new Double(XSDUtil.removeXmlComments(tmp)).intValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NONNEGATIVEINTEGER,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Integer(new Double(XSDUtil.removeXmlComments(tmp)).intValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_INT,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Integer(new Double(XSDUtil.removeXmlComments(tmp)).intValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_UNSIGNEDINT,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Long(new Double(XSDUtil.removeXmlComments(tmp)).longValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_LONG,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Long(new Double(XSDUtil.removeXmlComments(tmp)).longValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_UNSIGNEDLONG,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Long(new Double(XSDUtil.removeXmlComments(tmp)).longValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_SHORT,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Integer(new Double(XSDUtil.removeXmlComments(tmp)).intValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_UNSIGNEDSHORT,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Integer(new Double(XSDUtil.removeXmlComments(tmp)).intValue());\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DECIMAL,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Double(XSDUtil.removeXmlComments(tmp));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_FLOAT,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Double(XSDUtil.removeXmlComments(tmp));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DOUBLE,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Double(XSDUtil.removeXmlComments(tmp));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_BOOLEAN,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Boolean(XSDUtil.removeXmlComments(tmp).equals(\"true\") || XSDUtil.removeXmlComments(tmp).equals(\"1\"));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_TIME,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.parseTime(XSDUtil.removeXmlComments(tmp));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DATETIME,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.parseDateTime(XSDUtil.removeXmlComments(tmp));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DURATION,false))) {
				methods.append("    obj.INTERNAL_VALUE = new Long(XSDUtil.parseDuration(XSDUtil.removeXmlComments(tmp)));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DATE,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.parseDate(XSDUtil.removeXmlComments(tmp));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_GMONTH,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.parseGMonth(XSDUtil.removeXmlComments(tmp));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_GYEAR,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.parseGYear(XSDUtil.removeXmlComments(tmp));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_GYEARMONTH,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.parseGYearMonth(XSDUtil.removeXmlComments(tmp));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_GDAY,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.parseGDay(XSDUtil.removeXmlComments(tmp));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_GMONTHDAY,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.parseGMonthDay(XSDUtil.removeXmlComments(tmp));\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NAME,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_QNAME,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NCNAME,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_ANYURI,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_LANGUAGE,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_ID,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_IDREF,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_IDREFS,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_ENTITY,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_ENTITIES,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NOTATION,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NMTOKEN,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");
			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_NMTOKENS,false))) {
				methods.append("    obj.INTERNAL_VALUE = XSDUtil.removeXmlComments(tmp);\n");

			} else if (name.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_LIST,false))) {
				methods.append("    java.util.ArrayList tmpl = new java.util.ArrayList();\n");
				methods.append("    java.util.StringTokenizer stok = new java.util.StringTokenizer(XSDUtil.removeXmlComments(tmp));\n");
				methods.append("    while (stok.hasMoreTokens()) {\n");
				methods.append("      tmpl.add( "+qlistType+".fromXML( stok.nextToken() ) );\n");
				methods.append("    }\n");
				methods.append("    obj.INTERNAL_VALUE = tmpl;\n");
			}
			
			methods.append("    return obj;\n");
			methods.append("  }\n");

		}

	}
	
	/**
	 * Returns a java class body with any method implementations for this particular complex type
	 * @return
	 */
	public String getMethods() {
		if (methods.length() == 0) return "";
		return methods.toString();
	}
	
	/**
	 * Returns an array of interfaces that this complex type will be said to implement
	 * @return
	 */
	public String[] getImplementations() {
		return new String[] {
			XMLAccessible.class.getName(),
//			XMLXSDType.class.getName(),
		};
	}

	public String[] getImports() {
		return new String[] {
			NamespaceTranslator.class.getName(),
			CharStack.class.getName(),
		};
	}
	
	class TopLevelMapping {
		String name;
		String type;
	}
}