/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

/**
 * 
 * @author amiguel
 * 
 * Utility methods and constants for the HTTP implementation
 *
 */
public class HTTPUtils {
	
	public static final String REQUEST_GET = "GET";
	public static final String REQUEST_HEAD = "HEAD";
	public static final String REQUEST_POST = "POST";
	public static final String REQUEST_PUT = "PUT";
	public static final String REQUEST_TRACE = "TRACE";
	public static final String REQUEST_OPTIONS = "OPTIONS";
	public static final String REQUEST_DELETE = "DELETE";
	public static final String REQUEST_CONNECT = "CONNECT";

	public static final String VERSION_1_0 = "HTTP/1.0";
	public static final String VERSION_1_1 = "HTTP/1.1";

	public static final String HEADER_CONTENT_LENGTH = "content-length";
	public static final String HEADER_CONTENT_TYPE = "content-type";
	public static final String HEADER_CONNECTION = "connection";
	public static final String HEADER_TRANSFER_ENCODING = "transfer-encoding";
	public static final String HEADER_HOST = "host";
	public static final String HEADER_SET_COOKIE = "set-cookie";
	public static final String HEADER_COOKIE = "cookie";
	public static final String HEADER_LOCATION = "location";
	
	private static final byte[] HEADER_NEWLINE = new byte[] {'\r','\n'};
	private static final byte[] HEADER_SEP = new byte[] {':',' '};

//	public static void writeHttpHeader(OutputStream out, HTTPHeader header) throws IOException {
//		writeInitialHeader(out,header.request_type,header.resource,header.http_version);
//	}

	public static int getDefaultPort(URL address) {
		if (address.getProtocol().equals("https")) {
			return 443;
		} else {
			return 80;
		}
	}
	
	public static void writeContent(OutputStream out, byte[] bytes) throws IOException {
		out.write(bytes);
	}
	/*
	public static void readHttpHeader(InputStream in, HTTPHeader header) throws IOException {
		int ch = -1;
		
		CharStack stack = new CharStack(new String(StreamUtils.readLine(in)));
		stack.popWhitespace();
		header.setRequestType(stack.popText(true));
		stack.popWhitespace();
		header.setResource(stack.popText(true));
		stack.popWhitespace();
		header.setHttpVersion(stack.popText(true));
	}*/
	
	private static byte[] getBytes(String s) throws IOException {
		//return s.getBytes("UTF-8");
		//return s.getBytes("US-ASCII");
		int len = s.length();
		byte[] dat = new byte[len];
		for (int i = 0; i < len; i++) {
			dat[i] = (byte)s.charAt(i);
		}
		return dat;
	}
	
	public static void writeInitialHeader(OutputStream out, String request, String resource, String version) throws IOException {
		out.write(getBytes(request));
		out.write(' ');
		out.write(getBytes(resource));
		out.write(' ');
		out.write(getBytes(version));
		out.write(HEADER_NEWLINE);
	}
	
	public static void writeHeader(OutputStream out, String header_name, String header_value) throws IOException {
		out.write(getBytes(header_name));
		out.write(HEADER_SEP);
		out.write(getBytes(header_value));
		out.write(HEADER_NEWLINE);
	}
	
	public static void writeHeadersEnd(OutputStream out) throws IOException {
		out.write(HEADER_NEWLINE);
	}
	
	public static String getHtml(String title, String body) {
		StringBuffer err = new StringBuffer();
		err.append("<html>\n");

		err.append("<head>\n");
		err.append("<title>").append(title).append("</title>\n");
		err.append("<style><!-- body {font-family: arial,sans-serif} p {font-family: courier; font-size: small} --></style>\n");
		err.append("</head>\n");

		err.append("<body>\n");
		err.append("<table width=\"100%\">\n");
		err.append("<tr>\n");
		err.append("<td bgcolor=\"#0080C0\">\n");
		err.append("<font color=\"#FFFFFF\">&nbsp; &nbsp;<B>Eclipse TPTP BPEL engine</B></font>\n");
		err.append("</td>\n");
		err.append("</tr>\n");
		err.append("</table>\n");
		err.append("<body>\n");
		err.append("<h1>").append(title).append("</h1>\n");
		err.append(body);
		err.append("</body>\n");

		err.append("</html>\n");
		return err.toString();
	}
	
	public static String getHtmlError(String errormsg, String errdetail) {
		StringBuffer err = new StringBuffer();
		err.append("<html>\n");

		err.append("<head>\n");
		err.append("<title>").append(errormsg).append("</title>\n");
		err.append("<style><!-- body {font-family: arial,sans-serif} p {font-family: courier; font-size: small} --></style>\n");
		err.append("</head>\n");

		err.append("<body>\n");
		err.append("<table width=\"100%\">\n");
		err.append("<tr>\n");
		err.append("<td bgcolor=\"#0080C0\">\n");
		err.append("<font color=\"#FFFFFF\">&nbsp; &nbsp;<B>Eclipse TPTP BPEL engine</B></font>\n");
		err.append("</td>\n");
		err.append("</tr>\n");
		err.append("</table>\n");
		err.append("<body>\n");
		err.append("<h1>").append(errormsg).append("</h1>\n");
		if (errdetail.length() > 0) {
			err.append("<br>\n");
			err.append("<br>\n");
			err.append("<h3>\n");
			err.append("Detail:\n");
			err.append("</h3>\n");

			err.append("<p>\n");
			err.append("<table>\n");
			err.append("<tr>\n");
			err.append("<td bgcolor=\"#F0F0F0\">\n");
			err.append("&nbsp;<br>\n");
			err.append(errdetail);
			err.append("\n<br>\n");
			err.append("</td>\n");
			err.append("</tr>\n");
			err.append("</table>\n");
		}
		err.append("</body>\n");

		err.append("</html>\n");
		return err.toString();
	}

}