/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.message;


import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author amiguel
 * 
 * A class to do Message based Transactions.
 * The basis of this class is that the client can do transactions ( 1
 * message to = 1 message from) against a server, dealing only with Message
 * objects.
 *
 * The transaction client would typically be instantiated on one end of a socket
 * using the input and output streams of the socket.
 */
public class BasicSTTransactionClient implements STTransactionClient {

MessageReader min;
MessageWriter mout;

	/** 
	 * Construct a new TransactionClient
	 * @param bin the InputStream to read messages from
	 * @param bout the OutputStream to write messages to
	 */ 
	public BasicSTTransactionClient(InputStream bin, OutputStream bout, ThreadGroup tg, String name) {
		min = new MessageReader(bin,tg,name);
		mout = new MessageWriter(bout);
	}//end method

	/** 
	 * Construct a new TransactionClient
	 * @param bin the InputStream to read messages from
	 * @param bout the OutputStream to write messages to
	 */ 
	public BasicSTTransactionClient(InputStream bin, OutputStream bout) {
		min = new MessageReader(bin);
		mout = new MessageWriter(bout);
	}//end method

	/**
	 * Perform a transaction based a message.
	 * @param m the message to send to the TransactionServer
	 */
	public Message doTransaction(Message m) throws IOException {
		mout.write(m);
		m = min.read();
		return m;
	}//end method

}//end class
