/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

/**
 * 
 * @author amiguel
 *
 * This class is used to efficiently use multiple strings as a key into a map
 */
public class MultiString {
	String[] strings;
	
	public MultiString(String[] strings) {
		this.strings = strings;
	}
	
	public int hashCode() {
		int n = 0;
		for (int i = 0; i < strings.length; i++) {
//System.out.println(strings[i].hashCode());			
			n = n*31 + strings[i].hashCode();
		}
//		System.out.println("-- "+n);
		return n;
	}
	
	public boolean equals(Object o) {
	
		if (o instanceof MultiString) {
			MultiString m = (MultiString)o;
			if (strings.length != m.strings.length) {
				return false;
			}
			for (int i = 0; i < strings.length; i++) {
				if (!strings[i].equals(m.strings[i])) {
					return false;
				}
			}
			return true;
		}
	
		return super.equals(o);
	}
	
	public String toString() {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < strings.length; i++) {
			sb.append("String "+i+": "+strings[i]+"\n");
		}
		return sb.toString();
	}
}