/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

public class SyncCounter {
	
	Object LOCK = new Object();
	int value;
	
	public void add(int i) {
		synchronized(LOCK) {
			value+=i;
		}
	}
	
	public void subtract(int i) {
		synchronized(LOCK) {
			value-=i;
		}
	}
	
	public int getValue() {
		int val;
		synchronized(LOCK) {
			val = value;
		}
		return val;
	}
	
}