/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.misc.internal;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MultiOutputStream extends OutputStream {
	OutputStream[] outs;
	
	public MultiOutputStream(OutputStream[] outs) {
		this.outs = outs;
	}

	public void close() throws IOException {
		for (int i = 0; i < outs.length; i++) {
			outs[i].close();
		}
	}
	public void flush() throws IOException {
		for (int i = 0; i < outs.length; i++) {
			outs[i].flush();
		}
	}
	public void write(byte[] b) throws IOException {
		for (int i = 0; i < outs.length; i++) {
			outs[i].write(b);
		}
	}
	public void write(byte[] b, int off, int len) throws IOException {
		for (int i = 0; i < outs.length; i++) {
			outs[i].write(b,off,len);
		}
	}
	public void write(int b) throws IOException {
		for (int i = 0; i < outs.length; i++) {
			outs[i].write(b);
		}
	}
}