/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.misc.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import org.eclipse.stp.b2j.core.xml.internal.w3c.Document;
import org.eclipse.stp.b2j.core.xml.internal.w3c.DocumentBuilder;
import org.eclipse.stp.b2j.core.xml.internal.w3c.DocumentWriter;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Node;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NodeList;
/*
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
*/
/**
 * 
 * @author amiguel
 *
 * A utility class used to access and manipulate XML documents
 */
public class XMLUtil {

	public static String nodeToString(Node n) throws Exception {
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		nodeToString(n,bout);
		return new String(bout.toByteArray());
	}
	
	public static String nodeChildrenToString(Node n) throws Exception {
		StringBuffer sb = new StringBuffer();
		NodeList children = n.getChildNodes();
		for (int i = 0; i < children.getLength(); i++) {
			sb.append(nodeToString(children.item(i)));
		}
		return sb.toString();
	}
	
	public static void nodeToString(Node n, OutputStream out) throws Exception {
		String s = new DocumentWriter("").writeNode(n,false);
		out.write(s.getBytes("UTF8"));

/*		Transformer tf = TransformerFactory.newInstance().newTransformer();
		tf.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION,"yes");

		DOMSource ds = new DOMSource(n);
		StreamResult res = new StreamResult(out);
		tf.transform(ds,res);*/
	}
		
	public static String documentToString(Node n) throws Exception {
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		documentToString(n,bout);
		return new String(bout.toByteArray());
	}

	public static void documentToString(Node n, OutputStream out) throws Exception {
		String s = new DocumentWriter("").writeDoc(n,false);
		out.write(s.getBytes("UTF8"));

/*		Transformer tf = TransformerFactory.newInstance().newTransformer();
		
		DOMSource ds = new DOMSource(n);
		StreamResult res = new StreamResult(out);
		tf.transform(ds,res);*/
	}

	public static void documentToCleanString(Node n, OutputStream out) throws Exception {
		String s = new DocumentWriter("").writeDoc(n,false);
		out.write(s.getBytes("UTF8"));

/*		Transformer tf = TransformerFactory.newInstance().newTransformer();

		DOMSource ds = new DOMSource(n);
		StreamResult res = new StreamResult(out);
		tf.transform(ds,res);*/
	}
	
	public static Document documentFromString(String doc) throws Exception {
		return getDocumentBuilder().parse(new ByteArrayInputStream(doc.getBytes()));
	}
    
	public static Document documentFromString(InputStream in) throws Exception {
		return getDocumentBuilder().parse(in);
	}
	
    public static Document blankDocument(String type) throws Exception {
    	Document doc = getDocumentBuilder().newDocument();
    	Element element = doc.createElement(type);
		doc.appendChild(element);
		
		return doc;
    }
    
	/**
	 * Utility method for generating a document builder which can be used to parse StatCon files.
	 * @return the DocumentBuilder which can be used to parse a StatCon file
	 * @throws Exception
	 */
	public static DocumentBuilder getDocumentBuilder() throws Exception {
		return new DocumentBuilder();
/*		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setValidating(false);
		
		DocumentBuilder builder = factory.newDocumentBuilder();
		return builder;*/
	}
	
	///////////////////////////////
	// FUNCTIONS BELOW HERE ARE FLAKY
	
/*
    public static Document blankDocumentNoDTD(String type) throws Exception {
    	return blankDocument(type);
    }

	public static Document fetchDocumentFromString(String name, boolean b) throws Exception {
		return getDocumentBuilder().parse(new ByteArrayInputStream(name.getBytes()));
	}
	public static String convertDocumentToStringNoDTD(Document doc)
	{
		return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"+toRawXML(doc.getDocumentElement());
	}


	public static void getXmlHead(StringBuffer sb, Element e) {
		sb.append("<");
		sb.append(e.getTagName());
		sb.append(" ");
		NamedNodeMap attrs = e.getAttributes();
		for (int i = 0; i < attrs.getLength(); i++) {
			Node node = attrs.item(i);
			sb.append(node.getNodeName());
			sb.append("=\"");
			sb.append(toRawXML(node.getNodeValue()));
			sb.append("\" ");	
		}
		sb.append(">\n");
	}
	
	public static void getXmlTail(StringBuffer sb, Element e) {
		sb.append("</");
		sb.append(e.getTagName());
		sb.append(">\n");
	}

	public static String toRawXML(Node n) {
		StringBuffer sb = new StringBuffer();
		toRawXML(sb, n);
		return sb.toString();	
	}
	
	public static String toRawXML(String val) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < val.length(); i++) {
			char c = val.charAt(i);
			if (c == '>') {
				sb.append("&gt;");
			} else if (c == '<') {
				sb.append("&lt;");
			} else if (c == '"') {
				sb.append("&quot;");
			} else if (c == '\'') {
				sb.append("&apos;");
			} else if (c == '&') {
				sb.append("&amp;");
			} else {
				sb.append(c);	
			}
		}
		return sb.toString();			
	}
	
	private static void toRawXML(StringBuffer sb, Node n) {
		if (n.getNodeType() == Node.ELEMENT_NODE) {
			toXML(sb,(Element)n);
		} else if (n.getNodeType() == Node.TEXT_NODE) {
			String val = n.getNodeValue();
			sb.append(toRawXML(val));
		}
	}
 
	public static String toXML(Element e) {
		StringBuffer sb = new StringBuffer();
		toXML(sb,e);
		return sb.toString();
	}
	
	private static void toXML(StringBuffer sb, Element e) {
		sb.append("<");
		sb.append(e.getTagName());

		NamedNodeMap attrs = e.getAttributes();
		for (int i = 0; i < attrs.getLength(); i++) {
			Node node = attrs.item(i);
			sb.append(" " + node.getNodeName());
			sb.append("=\"");
			sb.append(toRawXML(node.getNodeValue()));
			sb.append("\"");	
		}
		sb.append(">\n");

		ArrayList list = getAllElements(e.getChildNodes(),null);
		for (int i = 0; i < list.size(); i++) {
			Element x = (Element)list.get(i);
			toXML(sb,x);	
		}

		sb.append("</");
		sb.append(e.getTagName());
		sb.append(">\n");
	}

 
	public static Element getFirstElement(NodeList list, String name) {
		for (int i = 0; i < list.getLength(); i++) {
			Object o = list.item(i);
			if (o instanceof Element) {
				Element e = (Element)o;
				
				if (name != null) {
					if (e.getTagName().equals(name)) {
						return e;
					}
				} else {
					return e;
				}
			}
		}
		
		return null;		
	}

	public static ArrayList getAllElements(NodeList list, String name) {
		ArrayList elements = new ArrayList();
		
		for (int i = 0; i < list.getLength(); i++) {
			Object o = list.item(i);
			if (o instanceof Element) {
				Element e = (Element)o;
				
				if (name != null) {
					if (e.getTagName().equals(name)) {
						elements.add(o);
					}
				} else {
					elements.add(o);
				}
			}
		}
		
		return elements;		
	}

	public static void getElementAttributeMap(NodeList list, String name, String attribute, HashMap map) {
		for (int i = 0; i < list.getLength(); i++) {
			Object o = list.item(i);
			if (o instanceof Element) {
				Element e = (Element)o;
				
				if (name != null) {
					if (e.getTagName().equals(name)) {
						String attr = e.getAttribute(attribute);
						if (attr != null) {
							map.put(attr,e);	
						}
					}
				} else {
					String attr = e.getAttribute(attribute);
					if (attr != null) {
						map.put(attr,e);	
					}
				}
			}
		}
	}
	
	public static HashMap getElementAttributeMap(NodeList list, String name, String attribute) {
		HashMap map = new HashMap();
		getElementAttributeMap(list,name,attribute,map);
		return map;
	}
 
	public static double parseDouble(String doub, double def) {
		try {
			return Double.parseDouble(doub);
		} catch (Exception e) {
			return def;
		}	
	}
 
	public static boolean parseBoolean(String bool, boolean def) {
		if (bool.equals("true")) return true;
		if (bool.equals("false")) return false;
		return def;
	}
	
 
	public static int parseLineStyle(String style, int def) {

		if (style.equals("SOLID")) {
			return SWT.LINE_SOLID;
		} else if (style.equals("DOT")) {
			return SWT.LINE_DOT;
		} else if (style.equals("DASH")) {
			return SWT.LINE_DASH;
		} else if (style.equals("DASHDOT")) {
			return SWT.LINE_DASHDOT;
		} else if (style.equals("DASHDOTDOT")) {
			return SWT.LINE_DASHDOTDOT;
		} else {
			return def;	
		}	
	}

 
	public static RGB parseColor(String col, RGB def) {
		try {
			if (!col.startsWith("#")) throw new Exception();
			if (col.length() != 7) throw new Exception();

			String sr = col.substring(1,3);
			String sg = col.substring(3,5);
			String sb = col.substring(5,7);

			int r = Integer.parseInt(sr,16);
			int g = Integer.parseInt(sg,16);
			int b = Integer.parseInt(sb,16);

			return new RGB(r,g,b);
			
		} catch (Exception e) {
			return def;
		}		
	}

 
	public static String colorToString(Color c) {
		RGB rgb = c.getRGB();

		String s = "#";
		
		if (rgb.red < 0x10) s = s+"0";
		s = s + Integer.toString(rgb.red,16);
		if (rgb.green < 0x10) s = s+"0";
		s = s + Integer.toString(rgb.green,16);
		if (rgb.blue < 0x10) s = s+"0";
		s = s + Integer.toString(rgb.blue,16);
		
		return s;
	}

 
	public static String lineStyleToString(int style) {
		
		if (style == SWT.LINE_SOLID) {
			return "SOLID";	
		} else if (style == SWT.LINE_DOT) {
			return "DOT";	
		} else if (style == SWT.LINE_DASH) {
			return "DASH";	
		} else if (style == SWT.LINE_DASHDOT) {
			return "DASHDOT";	
		} else if (style == SWT.LINE_DASHDOTDOT) {
			return "DASHDOTDOT";	
		}
		
		return "SOLID";
	}
*/	

}