/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi.jcompiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;

import org.eclipse.stp.b2j.core.jengine.internal.utils.ClassPathHacker;
import org.eclipse.stp.b2j.core.jengine.internal.utils.JARFinder;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;
import org.eclipse.stp.b2j.core.publicapi.DependencyInfo;

public class IndependantJaninoJavaCompiler implements JavaCompiler {

	CompilerUnit mainsrc;
	CompilerUnit[] allsrc = new CompilerUnit[1];
	
	byte[] theclass;
	byte[][] classes;
	
	public void setMainSourceFile(CompilerUnit src) {
		mainsrc = src;
		allsrc[0] = mainsrc;
	}

	public void addExtraSources(CompilerUnit[] sources) {
		CompilerUnit[] tmp = new CompilerUnit[allsrc.length + sources.length];
		System.arraycopy(allsrc,0,tmp,0,allsrc.length);
		System.arraycopy(sources,0,tmp,allsrc.length,sources.length);
		allsrc = tmp;
	}

	public void compile() throws Exception {
		try {
			ClassPathHacker.addFile("./janino.jar"); 
			
			File destDirectory = File.createTempFile("IndependantJaninoJavaCompilation","");
			destDirectory.delete();
			if (!destDirectory.mkdirs()) {
				throw new Exception("Failed to make temporary directory "+destDirectory);
			}
			
			Class C_DebuggingInformation = Class.forName("org.codehaus.janino.DebuggingInformation");
			Class C_StringPattern = Class.forName("org.codehaus.janino.util.StringPattern");
			Class C_Compiler = Class.forName("org.codehaus.janino.Compiler");
			Class C_ArrayStringPattern = java.lang.reflect.Array.newInstance(C_StringPattern,0).getClass();
			
			Constructor con = C_Compiler.getConstructor(
					new Class[]{
							File[].class,
							File[].class,
							File[].class,
							File[].class,
							File.class,
							String.class,
							boolean.class,
							C_DebuggingInformation,
							C_ArrayStringPattern,
							boolean.class
					}
					);
			
			if (con == null) {
				throw new Exception("Failed to get constructor");
			}
			
			Object O_Compiler = con.newInstance(
					new Object[]{
							null,
							getClassPath(),
							null,
							null,
							destDirectory,
							null,
							new Boolean(false),
							C_DebuggingInformation.getField("ALL").get(null),
							null,
							new Boolean(false)
					}
					);
			
			Method M_compile = C_Compiler.getMethod("compile",new Class[]{ File[].class });
			
			File[] sourceFiles = writeSourceFiles(destDirectory.getCanonicalPath());
			
//			loadDependencies();
			
			Object ret = M_compile.invoke(O_Compiler,new Object[]{ sourceFiles });
			if (!((Boolean)ret).booleanValue()) {
				throw new Exception("Compilation failed");
			}
			
			ArrayList cpaths = new ArrayList();
			JARFinder.searchDir(cpaths,destDirectory,".class",1000);

			String cfname = getClassFileName(allsrc[0].getClassName());
			theclass = null;

			classes = new byte[cpaths.size()-1][];
			for (int i = 0; i < cpaths.size(); i++) {
				String path = (String)cpaths.get(i);
				FileInputStream fin = new FileInputStream(path);
				System.out.println(cfname+" ? "+path);
				if (path.endsWith(cfname)) {
					theclass = StreamUtils.readAll(fin);
				} else {
					if (theclass == null) {
						classes[i] = StreamUtils.readAll(fin);
					} else {
						classes[i-1] = StreamUtils.readAll(fin);
					}
				}
				fin.close();
			}

			deleteDirs(destDirectory);
			
		} catch (InvocationTargetException e) {
			throw (Exception)e.getTargetException();
		}
	}

	private File[] getClassPath() {
		ArrayList files = new ArrayList();
		
		files.add(new File(B2jPlatform.getPlatformFolder()+"/b2j.jar"));
		
		DependencyInfo[] infos = B2jPlatform.getAllDependencyInfo();
		for (int i = 0; i < infos.length; i++) {
			Properties[] props = infos[i].getResources();
			for (int k = 0; k < props.length; k++) {
				files.add(new File(infos[i].getRelativePath(props[k].getProperty("JAR"))));
			}
		}
		
		File[] tmp = new File[files.size()];
		files.toArray(tmp);
		return tmp;
	}
	
/*	private void loadDependencies() throws IOException {
		DependencyInfo[] infos = B2jPlatform.getAllDependencyInfo();
		for (int i = 0; i < infos.length; i++) {
			Properties[] props = infos[i].getResources();
			for (int k = 0; k < props.length; k++) {
				ClassPathHacker.addFile("./dependencies/"+props[k].getProperty("JAR"));
			}
		}
	}*/
	
	private File[] writeSourceFiles(String dir) throws IOException {
		if (!dir.endsWith(File.separator)) dir = dir+File.separator;

		System.out.println("Writing java source code to tmp directory "+dir);

		int CONFIGS_LEN = 0;

		String[] srcnames = new String[CONFIGS_LEN + allsrc.length];

		FileOutputStream allout = null;
		try {
		
//TODO hard coded debug path
			allout = new FileOutputStream("C:\\temp\\ALLSRC.java");
			
			new File("C:\\temp\\ALLSRC").mkdirs();
		} catch (Exception e) {
			System.out.println("Could not open generated source debugging file: "+e);
			allout = null;
		}
		
		for (int i = 0; i < allsrc.length; i++) {
			String pkgname = allsrc[i].getPackageName();
			String cname = allsrc[i].getClassName();
			String srcname = getSrcName(pkgname,cname);
			
			File tmpfile = new File(dir+srcname);
			//make any necessary directories for this source file.
			tmpfile.mkdirs();
			tmpfile.delete();

			srcnames[CONFIGS_LEN + i] = dir+srcname;

			FileOutputStream fout = new FileOutputStream(dir+srcname);
			fout.write(allsrc[i].toString().getBytes());
			fout.flush();
			
			try {
				if (allout != null) {
					allout.write(allsrc[i].toString().getBytes());
				}
			} catch (Exception e) {
				System.out.println("Failed to write to generated source debugging file: "+e);
				allout = null;
			}
			
			try {
				String fname = pkgname;
				fname = fname.substring(fname.indexOf('.')+1);
				fname = fname.replace('.','_');
				fname = fname + cname;
				FileOutputStream tmpfout = new FileOutputStream("C:\\temp\\ALLSRC\\"+fname+".java");
				tmpfout.write(allsrc[i].toString().getBytes());
				tmpfout.close();
			} catch (Exception e) {
				
			}
			
			fout.close();
			
			System.out.println("Wrote java source for "+srcname);
		}
		
		if (allout != null) {
			allout.flush();
			allout.close();
		}
		
		File[] tmp = new File[srcnames.length];
		for (int i = 0; i < tmp.length; i++) {
			System.out.println(srcnames[i]);
			tmp[i] = new File(srcnames[i]);
		}
		return tmp;
	}
	
	public byte[] getMainSourceClass() {
		return theclass;
	}

	public byte[][] getExtraSourceClasses() {
		return classes;
	}

	private String getSrcName(String pkgname, String cname) {
		pkgname = pkgname.replace('.','/');
//		cname = cname.replace('.','/');
		return pkgname + '/' + cname + ".java";
//		return cname.substring(cname.lastIndexOf('.')+1) + ".java";
	}
	
	private void deleteDirs(File f) {
		if (f.isDirectory()) {
			File[] files = f.listFiles();
			for (int i = 0; i < files.length; i++) {
				deleteDirs(files[i]);
			}
//			System.out.println("DELETING "+f);
			f.delete();
		} else {
//			System.out.println("DELETING "+f);
			f.delete();
		}
	}

	private String getClassFileName(String cname) {
		return cname.substring(cname.lastIndexOf('.')+1) + ".class";
	}	
	
}