/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.xml.internal.w3c;

public class Comment extends Node {

String text;

	public Comment(Node parent, String text) {
		super(parent,-1);
		this.text = text;
	}

//	////////////////////////////////////
//	 Node interface
//	////////////////////////////////////

  public String getNodeName() {
	  return "#text";	
  }

  public String getNodeValue() {
	  return text;	
  }

  public void setNodeValue(String value) {
	  text = value;	
  }

  public short getNodeType() {
	  return Node.COMMENT_NODE;	
  }

  public boolean hasAttributes() {
	  return false;	
  }

  public NamedNodeMap getAttributes() {
	  return null;	
  }

  Node cloneNode(Node parent) {
	  return new Comment(parent,text);
  }
	
}