/*
 * Copyright (c) 2007, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.draw2d.Connection;

import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;

import org.eclipse.stp.bpmn.diagram.edit.policies.AssociationItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.policies.BpmnDragDropEditPolicy;
import org.eclipse.stp.bpmn.policies.OpenFileEditPolicy;

/**
 * @generated
 */
public class AssociationEditPart extends ConnectionNodeEditPart {

    /**
     * @generated
     */
    public static final int VISUAL_ID = 3003;

    /**
     * @generated
     */
    public AssociationEditPart(View view) {
        super(view);
    }

    /**
     * @generated
     */
    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE,
                new AssociationItemSemanticEditPolicy());
    }

    /**
     * @generated NOT
     */
    protected void createDefaultEditPolicies() {
        createDefaultEditPoliciesGen();
     // adding default drag and drop edit policy
        installEditPolicy(EditPolicyRoles.DRAG_DROP_ROLE, 
                new BpmnDragDropEditPolicy(this));
        // adding an open edit policy
        installEditPolicy(EditPolicyRoles.OPEN_ROLE,
        		new OpenFileEditPolicy());
    }
    /**
     * Creates figure for this edit part.
     * 
     * Body of this method does not depend on settings in generation model
     * so you may safely remove <i>generated</i> tag and modify it.
     * 
     * @generated
     */
    protected Connection createConnectionFigure() {
        return new ConnectionAssociationFigure();
    }

    /**
     * @generated
     */
    public class ConnectionAssociationFigure extends
            org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx {

        /**
         * @generated
         */
        public ConnectionAssociationFigure() {

            this.setLineStyle(org.eclipse.draw2d.Graphics.LINE_DOT);
            //TODO: add the event notifyer so that the decoration paints itself when the 
            //direction type of the semantic element is changed.
//            setSourceDecoration(createSourceDecoration());
//            setTargetDecoration(createTargetDecoration());
        }

        /**
         * @generated
         */
        private org.eclipse.stp.bpmn.figures.AssociationPolylineSourceDecoration createSourceDecoration() {
            org.eclipse.stp.bpmn.figures.AssociationPolylineSourceDecoration df =
                new org.eclipse.stp.bpmn.figures.AssociationPolylineSourceDecoration();

            return df;
        }

        /**
         * @generated
         */
        private org.eclipse.stp.bpmn.figures.AssociationPolylineTargetDecoration createTargetDecoration() {
            org.eclipse.stp.bpmn.figures.AssociationPolylineTargetDecoration df =
                new org.eclipse.stp.bpmn.figures.AssociationPolylineTargetDecoration();

            return df;
        }

    }

}
