/*
 * Copyright (c) 2007, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 */
package org.eclipse.stp.bpmn.diagram.edit.policies;

import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.stp.bpmn.SubProcess;

import org.eclipse.stp.bpmn.diagram.edit.parts.Activity2EditPart;

import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;

/**
 * @generated
 */
public class SubProcessSubProcessBorderCompartmentCanonicalEditPolicy extends
        CanonicalEditPolicy {

    /**
     * @generated
     */
    protected List getSemanticChildrenList() {
        List result = new LinkedList();
        EObject modelObject = ((View) getHost().getModel()).getElement();
        if (!(modelObject instanceof SubProcess)) {
        	// the subprocess is currently in an invalid state. Most probably 
        	// being torn into pieces during an ungroup.
        	return result;
        }
        View viewObject = (View) getHost().getModel();
        EObject nextValue;
        int nodeVID;
        for (Iterator values = ((SubProcess) modelObject).getEventHandlers()
                .iterator(); values.hasNext();) {
            nextValue = (EObject) values.next();
            nodeVID = BpmnVisualIDRegistry.getNodeVisualID(viewObject,
                    nextValue);
            if (Activity2EditPart.VISUAL_ID == nodeVID) {
                result.add(nextValue);
            }
        }
        return result;
    }

    /**
     * @generated
     */
    protected boolean shouldDeleteView(View view) {
        return view.isSetElement() && view.getElement() != null
                && view.getElement().eIsProxy();
    }

    /**
     * @generated
     */
    protected String getDefaultFactoryHint() {
        return null;
    }

}
