/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.create.operations;

import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;

public interface IComponentTypeCreationDataModelProperties extends
      IAbstractScribblerDataModelProperties {
   /**
    * [REQUIRED] Name of the ComponentType. This will dictate the componentType
    * resource name.
    * 
    * Type = {@link String}
    */
   public static final String NAME       = "IComponentTypeCreationDataModelProperties.NAME";      //$NON-NLS-1$

   /**
    * [REQUIRED] Property indicating the Container into which the componentType
    * file will be generated. This container must be a valid IContainer.
    * 
    * Type = {@link org.eclipse.core.resources.IContainer}
    */
   public static final String CONTAINER  = "IComponentTypeCreationDataModelProperties.CONTAINER"; //$NON-NLS-1$

   /**
    * [OPTIONAL] Property indicating the list of configurable Properties to be
    * defined within this component type.
    * 
    * Type = {@link java.util.List} defaulted to empty list
    */
   public static final String PROPERTIES = "IComponentTypeCreationDataModelProperties.PROPERTIES"; //$NON-NLS-1$

   /**
    * [OPTIONAL] Property indicating the List of configurable references.
    * 
    * Type = {@link java.util.List} defaulted to empty list
    */
   public static final String REFERENCES = "IComponentTypeCreationDataModelProperties.REFERENCES"; //$NON-NLS-1$

   /**
    * [OPTIONAL] Property indicating the list of services
    * 
    * Type = {@link java.util.List} defaulted to empty list
    */
   public static final String SERVICES   = "IComponentTypeCreationDataModelProperties.SERVICES";  //$NON-NLS-1$

}
