/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.delete.operations;

import java.util.List;
import java.util.Set;

import javax.wsdl.Import;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerDataModelProvider;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class DeletePropertyDataModelProvider extends
      AbstractScribblerDataModelProvider implements
      IDeletePropertyDataModelProperties {

   public Set getPropertyNames() {
      Set propertyNames = super.getPropertyNames();
      propertyNames.add(COMPONENT_TYPE);
      propertyNames.add(PROPERTY_NAMES);
      return propertyNames;
   }

   public IStatus validate(String propertyName) {
      if (propertyName.equals(PROPERTY_NAMES)) {
         return validatePropertyNames();
      } else if (propertyName.equals(COMPONENT_TYPE)) {
         return validatePart();
      }

      return super.validate(propertyName);
   }

   private IStatus validatePart() {
      Object object = getProperty(COMPONENT_TYPE);

      if (!(object instanceof ComponentType || object instanceof Import || object instanceof EntryPoint))
         return STPCorePlugin.createErrorStatus(
               Messages.invalidObjectPassed_errorText, null);

      return OK_STATUS;
   }

   public IDataModelOperation getDefaultOperation() {
      return new DeletePropertyOperation(model);
   }

   private IStatus validatePropertyNames() {
      ComponentType componentType = (ComponentType) model
            .getProperty(COMPONENT_TYPE);
      List properties = componentType.getProperties();

      String[] propertyNames = (String[]) model.getProperty(PROPERTY_NAMES);
      Assert.isTrue(properties.size() >= propertyNames.length);
      for (int i = 0; i < propertyNames.length; i++) {
         Property property = null;

         for (int propertyIndex = 0; propertyIndex < properties.size(); propertyIndex++) {
            property = (Property) properties.get(propertyIndex);
            if (property.getName().equals(propertyNames[i]))
               break;

            property = null;
         }

         if (property == null)
            return STPCorePlugin.createErrorStatus(NLS.bind(
                  Messages.propertyName_not_inComponentType, propertyNames[i]),
                  null);
      }

      return Status.OK_STATUS;
   }

}
