/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.delete.operations;

import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerOperation;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/**
 * @since 1.0
 * 
 */
public class DeletePropertyOperation extends AbstractScribblerOperation {
   /**
    * @param model
    */
   public DeletePropertyOperation(IDataModel model) {
      super(model);
   }

   protected IStatus doExecute(IProgressMonitor monitor) {
      IStatus status = OK_STATUS;
      ComponentType cType = (ComponentType) model
            .getProperty(IDeletePropertyDataModelProperties.COMPONENT_TYPE);
      List properties = cType.getProperties();
      if (properties.isEmpty())
         return OK_STATUS;

      String[] propertyNames = (String[]) model
            .getProperty(IDeletePropertyDataModelProperties.PROPERTY_NAMES);
      Assert.isTrue(properties.size() >= propertyNames.length);

      for (int i = 0; i < propertyNames.length; i++) {
         Property property = null;

         for (int propertyIndex = 0; propertyIndex < properties.size(); propertyIndex++) {
            property = (Property) properties.get(propertyIndex);
            if (property.getName().equals(propertyNames[i]))
               break;

            property = null;
         }

         if (property != null) {
            cType.getProperties().remove(property);
         }
      }

      return status;
   }

   protected IStatus doRedo(IProgressMonitor monitor) {
      // TODO Auto-generated method stub
      return null;
   }

   protected IStatus doUndo(IProgressMonitor monitor) {
      // TODO Auto-generated method stub
      return null;
   }
}
