/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.delete.operations;

import java.util.List;
import java.util.Set;

import javax.wsdl.Import;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerDataModelProvider;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class DeleteServiceDataModelProvider extends
      AbstractScribblerDataModelProvider implements
      IDeleteServiceDataModelProperties {

   public Set getPropertyNames() {
      Set propertyNames = super.getPropertyNames();
      propertyNames.add(COMPONENT_TYPE);
      propertyNames.add(SERVICE_NAMES);
      return propertyNames;
   }

   public IStatus validate(String propertyName) {
      if (propertyName.equals(SERVICE_NAMES)) {
         return validateServiceNames();
      } else if (propertyName.equals(COMPONENT_TYPE)) {
         return validatePart();
      }

      return super.validate(propertyName);
   }

   private IStatus validatePart() {
      Object object = getProperty(COMPONENT_TYPE);

      if (!(object instanceof ComponentType || object instanceof Import || object instanceof EntryPoint))
         return STPCorePlugin.createErrorStatus(
               Messages.invalidObjectPassed_errorText, null);

      return OK_STATUS;
   }

   public IDataModelOperation getDefaultOperation() {
      return new DeleteServiceOperation(model);
   }

   private IStatus validateServiceNames() {
      ComponentType componentType = (ComponentType) model
            .getProperty(COMPONENT_TYPE);
      List services = componentType.getServices();

      String[] serviceNames = (String[]) model.getProperty(SERVICE_NAMES);
      Assert.isTrue(services.size() >= serviceNames.length);
      for (int i = 0; i < serviceNames.length; i++) {
         Service service = null;

         for (int serviceIndex = 0; serviceIndex < services.size(); serviceIndex++) {
            service = (Service) services.get(serviceIndex);
            if (service.getName().equals(serviceNames[i]))
               break;

            service = null;
         }

         if (service == null)
            return STPCorePlugin.createErrorStatus(NLS.bind(
                  Messages.serviceName_not_inComponentType, serviceNames[i]),
                  null);
      }

      return Status.OK_STATUS;
   }
}
