/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.EclipseResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;

public class SubsystemScribblerDomain extends SOACoreScribblerDomain implements
      IScribblerDomain {

   private static final String         SUBSYSTEM_EXT = "subsystem"; //$NON-NLS-1$ 

   private final IFile                 subsystem;

   private final IResourceDescriptor[] descriptors;

   public SubsystemScribblerDomain(IFile aSubsystem) {
      super(aSubsystem.getProject());
      Assert.isTrue(SUBSYSTEM_EXT.equals(aSubsystem.getFileExtension()));
      subsystem = aSubsystem;
      descriptors = new IResourceDescriptor[] { new EclipseResourceDescriptor(
            subsystem) };
   }

   public IResourceDescriptor[] getResourceDescriptors() {
      return descriptors;
   }

   public IResourceDescriptor getSubsystemDescriptor() {
      return descriptors[0];
   }
}
