/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Reference Value</b></em>'.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.ReferenceValue#getTargetURI <em>Target URI</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ReferenceValue#getName <em>Name</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ReferenceValue#getAnyAttribute <em>Any Attribute</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ReferenceValue#getReferenceValueSet <em>Reference Value Set</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getReferenceValue()
 * @model extendedMetaData="name='ReferenceValue' kind='elementOnly'"
 * @extends SCAObject
 * @generated
 */
public interface ReferenceValue extends SCAObject {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * Returns the value of the '<em><b>Target URI</b></em>' attribute. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Target URI</em>' attribute isn't clear,
    * there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Target URI</em>' attribute.
    * @see #setTargetURI(String)
    * @see org.eclipse.stp.core.sca.SCAPackage#getReferenceValue_TargetURI()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.AnyURI"
    *        required="true" extendedMetaData="kind='element' name='target'"
    * @generated
    */
   String getTargetURI();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.ReferenceValue#getTargetURI <em>Target URI</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Target URI</em>' attribute.
    * @see #getTargetURI()
    * @generated
    */
   void setTargetURI(String value);

   /**
    * Returns the value of the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Name</em>' attribute isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Name</em>' attribute.
    * @see #setName(String)
    * @see org.eclipse.stp.core.sca.SCAPackage#getReferenceValue_Name()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.NCName"
    *        required="true" extendedMetaData="kind='attribute' name='name'"
    * @generated
    */
   String getName();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.ReferenceValue#getName <em>Name</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Name</em>' attribute.
    * @see #getName()
    * @generated
    */
   void setName(String value);

   /**
    * Returns the value of the '<em><b>Any Attribute</b></em>' attribute
    * list. The list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any Attribute</em>' attribute list isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any Attribute</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getReferenceValue_AnyAttribute()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='attributeWildcard'
    *        wildcards='##any' name=':2' processing='lax'"
    * @generated
    */
   FeatureMap getAnyAttribute();

   /**
    * Returns the value of the '<em><b>Reference Value Set</b></em>'
    * container reference. It is bidirectional and its opposite is '{@link org.eclipse.stp.core.sca.ReferenceValuesSet#getReferenceValues <em>Reference Values</em>}'.
    * <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Reference Value Set</em>' container
    * reference isn't clear, there really should be more of a description
    * here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Reference Value Set</em>' container
    *         reference.
    * @see #setReferenceValueSet(ReferenceValuesSet)
    * @see org.eclipse.stp.core.sca.SCAPackage#getReferenceValue_ReferenceValueSet()
    * @see org.eclipse.stp.core.sca.ReferenceValuesSet#getReferenceValues
    * @model opposite="referenceValues"
    * @generated
    */
   ReferenceValuesSet getReferenceValueSet();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.ReferenceValue#getReferenceValueSet <em>Reference Value Set</em>}'
    * container reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Reference Value Set</em>'
    *           container reference.
    * @see #getReferenceValueSet()
    * @generated
    */
   void setReferenceValueSet(ReferenceValuesSet value);

   /* ************* Model customizations ********************* */

   /**
    * The following method could require the resolution of the ComponentType of
    * the containing Component.
    * 
    * @return The resolved Reference from the ComponentType
    */
   Reference getReference();

   /**
    * 
    * @param reference
    *           Set the resolved reference (which implicitly changes the name
    *           attribute)
    */
   void setReference(Reference reference);

   /**
    * The WireTarget can be one of either {@link Service} or
    * {@link ExternalService}.
    * 
    * @return The resolved WireTarget for the current targetURI
    */
   WireTarget getTarget();

   /**
    * Set the target URI using the given wireTarget. The WireTarget will compute
    * the correct target URI.
    * 
    * @param wireTarget
    *           The new target for this ReferenceValue.
    */
   void setTarget(WireTarget wireTarget);

   /**
    * Return the {@link Component} which owns this ReferenceValue.
    * 
    * @return Component
    */
   Component getOwningComponent();

   /**
    * Return true if this ReferenceValue targets the passed {@link WireTarget};
    * 
    * @param wireTarget
    * @return boolean
    */
   boolean targets(WireTarget wireTarget);

} // ReferenceValue
