/**
 * <copyright> </copyright>
 * 
 * $Id: ExternalServiceImpl.java,v 1.2 2006/04/05 14:26:12 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.sca.AbstractReference;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.IConstants;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.OverrideOptions;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.WireSource;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>External Service</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.ExternalServiceImpl#getBindingGroup <em>Binding Group</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ExternalServiceImpl#getBindings <em>Bindings</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ExternalServiceImpl#getInterfaceGroup <em>Interface Group</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ExternalServiceImpl#getInterface <em>Interface</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ExternalServiceImpl#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ExternalServiceImpl#getName <em>Name</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ExternalServiceImpl#getOverridable <em>Overridable</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ExternalServiceImpl#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ExternalServiceImpl extends SCAInternalObjectImpl implements
      ExternalService {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String             copyright            = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getBindingGroup() <em>Binding Group</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getBindingGroup()
    * @generated
    * @ordered
    */
   protected FeatureMap                   bindingGroup         = null;

   /**
    * The cached value of the '{@link #getInterfaceGroup() <em>Interface Group</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getInterfaceGroup()
    * @generated
    * @ordered
    */
   protected FeatureMap                   interfaceGroup       = null;

   /**
    * The cached value of the '{@link #getAny() <em>Any</em>}' attribute list.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAny()
    * @generated
    * @ordered
    */
   protected FeatureMap                   any                  = null;

   /**
    * The default value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected static final String          NAME_EDEFAULT        = null;

   /**
    * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected String                       name                 = NAME_EDEFAULT;

   /**
    * The default value of the '{@link #getOverridable() <em>Overridable</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getOverridable()
    * @generated
    * @ordered
    */
   protected static final OverrideOptions OVERRIDABLE_EDEFAULT = OverrideOptions.MAY_LITERAL;

   /**
    * The cached value of the '{@link #getOverridable() <em>Overridable</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getOverridable()
    * @generated
    * @ordered
    */
   protected OverrideOptions              overridable          = OVERRIDABLE_EDEFAULT;

   /**
    * This is true if the Overridable attribute has been set. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   protected boolean                      overridableESet      = false;

   /**
    * The cached value of the '{@link #getAnyAttribute() <em>Any Attribute</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAnyAttribute()
    * @generated
    * @ordered
    */
   protected FeatureMap                   anyAttribute         = null;

   /*
    * <doc-ku> a slight of hand with the featuremap makes for some delectable
    * code </doc-ku>
    */
   private List                           bindings;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ExternalServiceImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getExternalService();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Interface getInterface() {
      return (Interface) getInterfaceGroup().get(
            SCAPackage.eINSTANCE.getExternalService_Interface(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetInterface(Interface newInterface,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getInterfaceGroup()).basicAdd(
            SCAPackage.eINSTANCE.getExternalService_Interface(), newInterface,
            msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public void setInterface(Interface newInterface) {
      if (newInterface != null) {
         EStructuralFeature feature = FeatureAdapter.getFeature(newInterface);
         Assert.isNotNull(feature);
         getInterfaceGroup().set(feature, newInterface);
      } else {
         setInterfaceGen(null);
      }
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setInterfaceGen(Interface newInterface) {
      ((FeatureMap.Internal) getInterfaceGroup()).set(SCAPackage.eINSTANCE
            .getExternalService_Interface(), newInterface);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getBindingGroup() {
      if (bindingGroup == null) {
         bindingGroup = new BasicFeatureMap(this,
               SCAPackage.EXTERNAL_SERVICE__BINDING_GROUP);
      }
      return bindingGroup;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public List getBindings() {
      if (bindings == null)
         bindings = new FeatureAwareList(SCAPackage.eINSTANCE
               .getExternalService_Bindings(),
               (FeatureMap.Internal) getBindingGroup());
      return bindings;

   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getBindingsGen() {
      return ((FeatureMap) getBindingGroup()).list(SCAPackage.eINSTANCE
            .getExternalService_Bindings());
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getInterfaceGroup() {
      if (interfaceGroup == null) {
         interfaceGroup = new BasicFeatureMap(this,
               SCAPackage.EXTERNAL_SERVICE__INTERFACE_GROUP);
      }
      return interfaceGroup;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAny() {
      if (any == null) {
         any = new BasicFeatureMap(this, SCAPackage.EXTERNAL_SERVICE__ANY);
      }
      return any;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getName() {
      return name;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setName(String newName) {
      String oldName = name;
      name = newName;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.EXTERNAL_SERVICE__NAME, oldName, name));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public OverrideOptions getOverridable() {
      return overridable;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setOverridable(OverrideOptions newOverridable) {
      OverrideOptions oldOverridable = overridable;
      overridable = newOverridable == null ? OVERRIDABLE_EDEFAULT
            : newOverridable;
      boolean oldOverridableESet = overridableESet;
      overridableESet = true;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.EXTERNAL_SERVICE__OVERRIDABLE, oldOverridable,
               overridable, !oldOverridableESet));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void unsetOverridable() {
      OverrideOptions oldOverridable = overridable;
      boolean oldOverridableESet = overridableESet;
      overridable = OVERRIDABLE_EDEFAULT;
      overridableESet = false;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.UNSET,
               SCAPackage.EXTERNAL_SERVICE__OVERRIDABLE, oldOverridable,
               OVERRIDABLE_EDEFAULT, oldOverridableESet));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean isSetOverridable() {
      return overridableESet;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAnyAttribute() {
      if (anyAttribute == null) {
         anyAttribute = new BasicFeatureMap(this,
               SCAPackage.EXTERNAL_SERVICE__ANY_ATTRIBUTE);
      }
      return anyAttribute;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.EXTERNAL_SERVICE__BINDING_GROUP:
               return ((InternalEList) getBindingGroup()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.EXTERNAL_SERVICE__BINDINGS:
               return ((InternalEList) getBindings()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.EXTERNAL_SERVICE__INTERFACE_GROUP:
               return ((InternalEList) getInterfaceGroup()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.EXTERNAL_SERVICE__INTERFACE:
               return basicSetInterface(null, msgs);
            case SCAPackage.EXTERNAL_SERVICE__ANY:
               return ((InternalEList) getAny()).basicRemove(otherEnd, msgs);
            case SCAPackage.EXTERNAL_SERVICE__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.EXTERNAL_SERVICE__BINDING_GROUP:
            return getBindingGroup();
         case SCAPackage.EXTERNAL_SERVICE__BINDINGS:
            return getBindings();
         case SCAPackage.EXTERNAL_SERVICE__INTERFACE_GROUP:
            return getInterfaceGroup();
         case SCAPackage.EXTERNAL_SERVICE__INTERFACE:
            return getInterface();
         case SCAPackage.EXTERNAL_SERVICE__ANY:
            return getAny();
         case SCAPackage.EXTERNAL_SERVICE__NAME:
            return getName();
         case SCAPackage.EXTERNAL_SERVICE__OVERRIDABLE:
            return getOverridable();
         case SCAPackage.EXTERNAL_SERVICE__ANY_ATTRIBUTE:
            return getAnyAttribute();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.EXTERNAL_SERVICE__BINDING_GROUP:
            getBindingGroup().clear();
            getBindingGroup().addAll((Collection) newValue);
            return;
         case SCAPackage.EXTERNAL_SERVICE__BINDINGS:
            getBindings().clear();
            getBindings().addAll((Collection) newValue);
            return;
         case SCAPackage.EXTERNAL_SERVICE__INTERFACE_GROUP:
            getInterfaceGroup().clear();
            getInterfaceGroup().addAll((Collection) newValue);
            return;
         case SCAPackage.EXTERNAL_SERVICE__INTERFACE:
            setInterface((Interface) newValue);
            return;
         case SCAPackage.EXTERNAL_SERVICE__ANY:
            getAny().clear();
            getAny().addAll((Collection) newValue);
            return;
         case SCAPackage.EXTERNAL_SERVICE__NAME:
            setName((String) newValue);
            return;
         case SCAPackage.EXTERNAL_SERVICE__OVERRIDABLE:
            setOverridable((OverrideOptions) newValue);
            return;
         case SCAPackage.EXTERNAL_SERVICE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.EXTERNAL_SERVICE__BINDING_GROUP:
            getBindingGroup().clear();
            return;
         case SCAPackage.EXTERNAL_SERVICE__BINDINGS:
            getBindings().clear();
            return;
         case SCAPackage.EXTERNAL_SERVICE__INTERFACE_GROUP:
            getInterfaceGroup().clear();
            return;
         case SCAPackage.EXTERNAL_SERVICE__INTERFACE:
            setInterface((Interface) null);
            return;
         case SCAPackage.EXTERNAL_SERVICE__ANY:
            getAny().clear();
            return;
         case SCAPackage.EXTERNAL_SERVICE__NAME:
            setName(NAME_EDEFAULT);
            return;
         case SCAPackage.EXTERNAL_SERVICE__OVERRIDABLE:
            unsetOverridable();
            return;
         case SCAPackage.EXTERNAL_SERVICE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.EXTERNAL_SERVICE__BINDING_GROUP:
            return bindingGroup != null && !bindingGroup.isEmpty();
         case SCAPackage.EXTERNAL_SERVICE__BINDINGS:
            return !getBindings().isEmpty();
         case SCAPackage.EXTERNAL_SERVICE__INTERFACE_GROUP:
            return interfaceGroup != null && !interfaceGroup.isEmpty();
         case SCAPackage.EXTERNAL_SERVICE__INTERFACE:
            return getInterface() != null;
         case SCAPackage.EXTERNAL_SERVICE__ANY:
            return any != null && !any.isEmpty();
         case SCAPackage.EXTERNAL_SERVICE__NAME:
            return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
                  .equals(name);
         case SCAPackage.EXTERNAL_SERVICE__OVERRIDABLE:
            return isSetOverridable();
         case SCAPackage.EXTERNAL_SERVICE__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public String toString() {
      return name;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.eclipse.stp.core.sca.impl.SOAInternalObject#getFlags()
    */
   public int getFlags() {
      return IConstants.F_POSSIBLE_WIRE_TARGET | IConstants.F_BOUNDARY_ELEMENT;
   }

   public String getTargetURI() {
      // TODO Auto-generated method stub
      return null;
   }

   public boolean matches(WireSource wireSource) {
      Assert.isNotNull(wireSource);
      if (getInterface() != null)
         return getInterface().equals(wireSource.getInterface());
      return false;
   }

   public boolean isResolved() {
      return true;
   }

   public boolean isComponentOwned() {
      return false;
   }

   public boolean matches(AbstractReference reference) {
      Assert.isNotNull(reference);
      if (getInterface() != null)
         return getInterface().equals(reference.getInterface());
      return false;
   }

} // ExternalServiceImpl
