/**
 * <copyright> </copyright>
 * 
 * $Id: ModuleServiceImpl.java,v 1.1 2006/03/31 21:58:48 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.IConstants;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.ModuleService;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Module Service</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.ModuleServiceImpl#getEntryPoint <em>Entry Point</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ModuleServiceImpl extends ServiceImpl implements ModuleService {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright  = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getEntryPoint() <em>Entry Point</em>}'
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getEntryPoint()
    * @generated
    * @ordered
    */
   protected EntryPoint       entryPoint = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ModuleServiceImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getModuleService();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EntryPoint getEntryPoint() {
      if (entryPoint != null && ((EObject) entryPoint).eIsProxy()) {
         EntryPoint oldEntryPoint = entryPoint;
         entryPoint = (EntryPoint) eResolveProxy((InternalEObject) entryPoint);
         if (entryPoint != oldEntryPoint) {
            if (eNotificationRequired())
               eNotify(new ENotificationImpl(this, Notification.RESOLVE,
                     SCAPackage.MODULE_SERVICE__ENTRY_POINT, oldEntryPoint,
                     entryPoint));
         }
      }
      return entryPoint;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EntryPoint basicGetEntryPoint() {
      return entryPoint;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setEntryPoint(EntryPoint newEntryPoint) {
      EntryPoint oldEntryPoint = entryPoint;
      entryPoint = newEntryPoint;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.MODULE_SERVICE__ENTRY_POINT, oldEntryPoint,
               entryPoint));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.MODULE_SERVICE__INTERFACE_GROUP:
               return ((InternalEList) getInterfaceGroup()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.MODULE_SERVICE__INTERFACE:
               return basicSetInterface(null, msgs);
            case SCAPackage.MODULE_SERVICE__ANY:
               return ((InternalEList) getAny()).basicRemove(otherEnd, msgs);
            case SCAPackage.MODULE_SERVICE__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_SERVICE__INTERFACE_GROUP:
            return getInterfaceGroup();
         case SCAPackage.MODULE_SERVICE__INTERFACE:
            return getInterface();
         case SCAPackage.MODULE_SERVICE__ANY:
            return getAny();
         case SCAPackage.MODULE_SERVICE__NAME:
            return getName();
         case SCAPackage.MODULE_SERVICE__ANY_ATTRIBUTE:
            return getAnyAttribute();
         case SCAPackage.MODULE_SERVICE__ENTRY_POINT:
            if (resolve)
               return getEntryPoint();
            return basicGetEntryPoint();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_SERVICE__INTERFACE_GROUP:
            getInterfaceGroup().clear();
            getInterfaceGroup().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE_SERVICE__INTERFACE:
            setInterface((Interface) newValue);
            return;
         case SCAPackage.MODULE_SERVICE__ANY:
            getAny().clear();
            getAny().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE_SERVICE__NAME:
            setName((String) newValue);
            return;
         case SCAPackage.MODULE_SERVICE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE_SERVICE__ENTRY_POINT:
            setEntryPoint((EntryPoint) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_SERVICE__INTERFACE_GROUP:
            getInterfaceGroup().clear();
            return;
         case SCAPackage.MODULE_SERVICE__INTERFACE:
            setInterface((Interface) null);
            return;
         case SCAPackage.MODULE_SERVICE__ANY:
            getAny().clear();
            return;
         case SCAPackage.MODULE_SERVICE__NAME:
            setName(NAME_EDEFAULT);
            return;
         case SCAPackage.MODULE_SERVICE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
         case SCAPackage.MODULE_SERVICE__ENTRY_POINT:
            setEntryPoint((EntryPoint) null);
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_SERVICE__INTERFACE_GROUP:
            return interfaceGroup != null && !interfaceGroup.isEmpty();
         case SCAPackage.MODULE_SERVICE__INTERFACE:
            return getInterface() != null;
         case SCAPackage.MODULE_SERVICE__ANY:
            return any != null && !any.isEmpty();
         case SCAPackage.MODULE_SERVICE__NAME:
            return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
                  .equals(name);
         case SCAPackage.MODULE_SERVICE__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
         case SCAPackage.MODULE_SERVICE__ENTRY_POINT:
            return entryPoint != null;
      }
      return eDynamicIsSet(eFeature);
   }

   /* ******** Begin custom API ******** */

   public void setInterface(Interface newInterface) {
      if (entryPoint != null)
         entryPoint.setInterface(newInterface);
      else
         super.setInterface(newInterface);
   }

   public Interface getInterface() {
      if (entryPoint != null)
         return entryPoint.getInterface();
      return super.getInterface();
   }

   public void setName(String newName) {
      if (entryPoint != null)
         entryPoint.setName(newName);
      super.setName(newName);
   }

   public String getName() {
      if (entryPoint != null)
         return entryPoint.getName();
      return super.getName();
   }

   public int getFlags() {
      return super.getFlags() | IConstants.F_BINDABLE_ELEMENT;
   }

} // ModuleServiceImpl
