/**
 * <copyright> </copyright>
 * 
 * $Id: SCACoreRootImpl.java,v 1.2 2006/04/05 14:26:12 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;
import java.util.Map;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.sca.AbstractImplementation;
import org.eclipse.stp.core.sca.Binding;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.ImplementationComponent;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaImplementation;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Module;
import org.eclipse.stp.core.sca.ModuleComponent;
import org.eclipse.stp.core.sca.ModuleFragment;
import org.eclipse.stp.core.sca.SCABinding;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.SLSBBinding;
import org.eclipse.stp.core.sca.Subsystem;
import org.eclipse.stp.core.sca.UnknownImplementation;
import org.eclipse.stp.core.sca.WSDLPortType;
import org.eclipse.stp.core.sca.WebServiceBinding;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Core Root</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getMixed <em>Mixed</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getXMLNSPrefixMap <em>XMLNS Prefix Map</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getXSISchemaLocation <em>XSI Schema Location</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getAbstractComponent <em>Abstract Component</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getBinding <em>Binding</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getBindingSca <em>Binding Sca</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getComponent <em>Component</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getComponentType <em>Component Type</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getComposite <em>Composite</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getImplementation <em>Implementation</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getImplementationAbstract <em>Implementation Abstract</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getImplementationUnknown <em>Implementation Unknown</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getInterface <em>Interface</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getModule <em>Module</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getModuleComponent <em>Module Component</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getModuleFragment <em>Module Fragment</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getSource <em>Source</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getSourceEpr <em>Source Epr</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getSourceUri <em>Source Uri</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getSubsystem <em>Subsystem</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getTarget <em>Target</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getTargetEpr <em>Target Epr</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getTargetUri <em>Target Uri</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getInterfaceWsdl <em>Interface Wsdl</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getInterfaceJava <em>Interface Java</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getBindingWs <em>Binding Ws</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getImplementationJava <em>Implementation Java</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.SCACoreRootImpl#getBindingEjb <em>Binding Ejb</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class SCACoreRootImpl extends SCAInternalObjectImpl implements
      SCACoreRoot {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String    copyright           = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getMixed() <em>Mixed</em>}' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getMixed()
    * @generated
    * @ordered
    */
   protected FeatureMap          mixed               = null;

   /**
    * The cached value of the '{@link #getXMLNSPrefixMap() <em>XMLNS Prefix Map</em>}'
    * map. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getXMLNSPrefixMap()
    * @generated
    * @ordered
    */
   protected EMap                xMLNSPrefixMap      = null;

   /**
    * The cached value of the '{@link #getXSISchemaLocation() <em>XSI Schema Location</em>}'
    * map. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getXSISchemaLocation()
    * @generated
    * @ordered
    */
   protected EMap                xSISchemaLocation   = null;

   /**
    * The default value of the '{@link #getSourceUri() <em>Source Uri</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getSourceUri()
    * @generated
    * @ordered
    */
   protected static final String SOURCE_URI_EDEFAULT = null;

   /**
    * The default value of the '{@link #getTargetUri() <em>Target Uri</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getTargetUri()
    * @generated
    * @ordered
    */
   protected static final String TARGET_URI_EDEFAULT = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected SCACoreRootImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getSCACoreRoot();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getMixed() {
      if (mixed == null) {
         mixed = new BasicFeatureMap(this, SCAPackage.SCA_CORE_ROOT__MIXED);
      }
      return mixed;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Map getXMLNSPrefixMap() {
      if (xMLNSPrefixMap == null) {
         xMLNSPrefixMap = new EcoreEMap(EcorePackage.eINSTANCE
               .getEStringToStringMapEntry(),
               EStringToStringMapEntryImpl.class, this,
               SCAPackage.SCA_CORE_ROOT__XMLNS_PREFIX_MAP);
      }
      return xMLNSPrefixMap.map();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Map getXSISchemaLocation() {
      if (xSISchemaLocation == null) {
         xSISchemaLocation = new EcoreEMap(EcorePackage.eINSTANCE
               .getEStringToStringMapEntry(),
               EStringToStringMapEntryImpl.class, this,
               SCAPackage.SCA_CORE_ROOT__XSI_SCHEMA_LOCATION);
      }
      return xSISchemaLocation.map();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Component getAbstractComponent() {
      return (Component) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_AbstractComponent(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetAbstractComponent(
         Component newAbstractComponent, NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_AbstractComponent(), newAbstractComponent, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setAbstractComponent(Component newAbstractComponent) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_AbstractComponent(), newAbstractComponent);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Binding getBinding() {
      return (Binding) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_Binding(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetBinding(Binding newBinding,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_Binding(), newBinding, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setBinding(Binding newBinding) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_Binding(), newBinding);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public SCABinding getBindingSca() {
      return (SCABinding) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_BindingSca(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetBindingSca(SCABinding newBindingSca,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_BindingSca(), newBindingSca, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setBindingSca(SCABinding newBindingSca) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_BindingSca(), newBindingSca);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ImplementationComponent getComponent() {
      return (ImplementationComponent) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_Component(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetComponent(
         ImplementationComponent newComponent, NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_Component(), newComponent, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setComponent(ImplementationComponent newComponent) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_Component(), newComponent);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ComponentType getComponentType() {
      return (ComponentType) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_ComponentType(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetComponentType(
         ComponentType newComponentType, NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_ComponentType(), newComponentType, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setComponentType(ComponentType newComponentType) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_ComponentType(), newComponentType);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public Composite getComposite() {
      if (getCompositeGen() == null)
         return getModule();
      return getCompositeGen();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Composite getCompositeGen() {
      return (Composite) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_Composite(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetComposite(Composite newComposite,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_Composite(), newComposite, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public void setComposite(Composite newComposite) {
      if (newComposite instanceof Subsystem)
         setSubsystem((Subsystem) newComposite);
      else if (newComposite instanceof Module)
         setModule((Module) newComposite);
      else
         setCompositeGen(newComposite);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setCompositeGen(Composite newComposite) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_Composite(), newComposite);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Implementation getImplementation() {
      return (Implementation) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_Implementation(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetImplementation(
         Implementation newImplementation, NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_Implementation(), newImplementation, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setImplementation(Implementation newImplementation) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_Implementation(), newImplementation);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public AbstractImplementation getImplementationAbstract() {
      return (AbstractImplementation) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_ImplementationAbstract(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetImplementationAbstract(
         AbstractImplementation newImplementationAbstract,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_ImplementationAbstract(),
            newImplementationAbstract, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setImplementationAbstract(
         AbstractImplementation newImplementationAbstract) {
      ((FeatureMap.Internal) getMixed())
            .set(SCAPackage.eINSTANCE.getSCACoreRoot_ImplementationAbstract(),
                  newImplementationAbstract);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public UnknownImplementation getImplementationUnknown() {
      return (UnknownImplementation) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_ImplementationUnknown(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetImplementationUnknown(
         UnknownImplementation newImplementationUnknown, NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_ImplementationUnknown(), newImplementationUnknown,
            msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setImplementationUnknown(
         UnknownImplementation newImplementationUnknown) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_ImplementationUnknown(), newImplementationUnknown);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Interface getInterface() {
      return (Interface) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_Interface(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetInterface(Interface newInterface,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_Interface(), newInterface, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setInterface(Interface newInterface) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_Interface(), newInterface);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Module getModule() {
      return (Module) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_Module(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetModule(Module newModule,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_Module(), newModule, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setModule(Module newModule) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_Module(), newModule);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ModuleComponent getModuleComponent() {
      return (ModuleComponent) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_ModuleComponent(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetModuleComponent(
         ModuleComponent newModuleComponent, NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_ModuleComponent(), newModuleComponent, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setModuleComponent(ModuleComponent newModuleComponent) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_ModuleComponent(), newModuleComponent);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ModuleFragment getModuleFragment() {
      return (ModuleFragment) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_ModuleFragment(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetModuleFragment(
         ModuleFragment newModuleFragment, NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_ModuleFragment(), newModuleFragment, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setModuleFragment(ModuleFragment newModuleFragment) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_ModuleFragment(), newModuleFragment);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object getSource() {
      return (Object) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetSource(EObject newSource,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_Source(), newSource, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setSource(Object newSource) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_Source(), newSource);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object getSourceEpr() {
      return (Object) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetSourceEpr(EObject newSourceEpr,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_SourceEpr(), newSourceEpr, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setSourceEpr(Object newSourceEpr) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_SourceEpr(), newSourceEpr);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getSourceUri() {
      return (String) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceUri(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setSourceUri(String newSourceUri) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_SourceUri(), newSourceUri);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Subsystem getSubsystem() {
      return (Subsystem) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_Subsystem(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetSubsystem(Subsystem newSubsystem,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_Subsystem(), newSubsystem, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setSubsystem(Subsystem newSubsystem) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_Subsystem(), newSubsystem);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object getTarget() {
      return (Object) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetTarget(EObject newTarget,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_Target(), newTarget, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setTarget(Object newTarget) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_Target(), newTarget);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object getTargetEpr() {
      return (Object) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetTargetEpr(EObject newTargetEpr,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_TargetEpr(), newTargetEpr, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setTargetEpr(Object newTargetEpr) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_TargetEpr(), newTargetEpr);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getTargetUri() {
      return (String) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetUri(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setTargetUri(String newTargetUri) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_TargetUri(), newTargetUri);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public WSDLPortType getInterfaceWsdl() {
      return (WSDLPortType) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_InterfaceWsdl(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetInterfaceWsdl(
         WSDLPortType newInterfaceWsdl, NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_InterfaceWsdl(), newInterfaceWsdl, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setInterfaceWsdl(WSDLPortType newInterfaceWsdl) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_InterfaceWsdl(), newInterfaceWsdl);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public JavaInterface getInterfaceJava() {
      return (JavaInterface) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_InterfaceJava(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetInterfaceJava(
         JavaInterface newInterfaceJava, NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_InterfaceJava(), newInterfaceJava, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setInterfaceJava(JavaInterface newInterfaceJava) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_InterfaceJava(), newInterfaceJava);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public WebServiceBinding getBindingWs() {
      return (WebServiceBinding) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_BindingWs(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetBindingWs(WebServiceBinding newBindingWs,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_BindingWs(), newBindingWs, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setBindingWs(WebServiceBinding newBindingWs) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_BindingWs(), newBindingWs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public JavaImplementation getImplementationJava() {
      return (JavaImplementation) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_ImplementationJava(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetImplementationJava(
         JavaImplementation newImplementationJava, NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_ImplementationJava(), newImplementationJava, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setImplementationJava(JavaImplementation newImplementationJava) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_ImplementationJava(), newImplementationJava);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public SLSBBinding getBindingEjb() {
      return (SLSBBinding) getMixed().get(
            SCAPackage.eINSTANCE.getSCACoreRoot_BindingEjb(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetBindingEjb(SLSBBinding newBindingEjb,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getMixed()).basicAdd(SCAPackage.eINSTANCE
            .getSCACoreRoot_BindingEjb(), newBindingEjb, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setBindingEjb(SLSBBinding newBindingEjb) {
      ((FeatureMap.Internal) getMixed()).set(SCAPackage.eINSTANCE
            .getSCACoreRoot_BindingEjb(), newBindingEjb);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.SCA_CORE_ROOT__MIXED:
               return ((InternalEList) getMixed()).basicRemove(otherEnd, msgs);
            case SCAPackage.SCA_CORE_ROOT__XMLNS_PREFIX_MAP:
               return ((InternalEList) ((EMap.InternalMapView) getXMLNSPrefixMap())
                     .eMap()).basicRemove(otherEnd, msgs);
            case SCAPackage.SCA_CORE_ROOT__XSI_SCHEMA_LOCATION:
               return ((InternalEList) ((EMap.InternalMapView) getXSISchemaLocation())
                     .eMap()).basicRemove(otherEnd, msgs);
            case SCAPackage.SCA_CORE_ROOT__ABSTRACT_COMPONENT:
               return basicSetAbstractComponent(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__BINDING:
               return basicSetBinding(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__BINDING_SCA:
               return basicSetBindingSca(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__COMPONENT:
               return basicSetComponent(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__COMPONENT_TYPE:
               return basicSetComponentType(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__COMPOSITE:
               return basicSetComposite(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION:
               return basicSetImplementation(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION_ABSTRACT:
               return basicSetImplementationAbstract(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION_UNKNOWN:
               return basicSetImplementationUnknown(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__INTERFACE:
               return basicSetInterface(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__MODULE:
               return basicSetModule(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__MODULE_COMPONENT:
               return basicSetModuleComponent(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__MODULE_FRAGMENT:
               return basicSetModuleFragment(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__SOURCE:
               return basicSetSource(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__SOURCE_EPR:
               return basicSetSourceEpr(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__SUBSYSTEM:
               return basicSetSubsystem(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__TARGET:
               return basicSetTarget(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__TARGET_EPR:
               return basicSetTargetEpr(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__INTERFACE_WSDL:
               return basicSetInterfaceWsdl(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__INTERFACE_JAVA:
               return basicSetInterfaceJava(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__BINDING_WS:
               return basicSetBindingWs(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION_JAVA:
               return basicSetImplementationJava(null, msgs);
            case SCAPackage.SCA_CORE_ROOT__BINDING_EJB:
               return basicSetBindingEjb(null, msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SCA_CORE_ROOT__MIXED:
            return getMixed();
         case SCAPackage.SCA_CORE_ROOT__XMLNS_PREFIX_MAP:
            return ((EMap.InternalMapView) getXMLNSPrefixMap()).eMap();
         case SCAPackage.SCA_CORE_ROOT__XSI_SCHEMA_LOCATION:
            return ((EMap.InternalMapView) getXSISchemaLocation()).eMap();
         case SCAPackage.SCA_CORE_ROOT__ABSTRACT_COMPONENT:
            return getAbstractComponent();
         case SCAPackage.SCA_CORE_ROOT__BINDING:
            return getBinding();
         case SCAPackage.SCA_CORE_ROOT__BINDING_SCA:
            return getBindingSca();
         case SCAPackage.SCA_CORE_ROOT__COMPONENT:
            return getComponent();
         case SCAPackage.SCA_CORE_ROOT__COMPONENT_TYPE:
            return getComponentType();
         case SCAPackage.SCA_CORE_ROOT__COMPOSITE:
            return getComposite();
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION:
            return getImplementation();
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION_ABSTRACT:
            return getImplementationAbstract();
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION_UNKNOWN:
            return getImplementationUnknown();
         case SCAPackage.SCA_CORE_ROOT__INTERFACE:
            return getInterface();
         case SCAPackage.SCA_CORE_ROOT__MODULE:
            return getModule();
         case SCAPackage.SCA_CORE_ROOT__MODULE_COMPONENT:
            return getModuleComponent();
         case SCAPackage.SCA_CORE_ROOT__MODULE_FRAGMENT:
            return getModuleFragment();
         case SCAPackage.SCA_CORE_ROOT__SOURCE:
            return getSource();
         case SCAPackage.SCA_CORE_ROOT__SOURCE_EPR:
            return getSourceEpr();
         case SCAPackage.SCA_CORE_ROOT__SOURCE_URI:
            return getSourceUri();
         case SCAPackage.SCA_CORE_ROOT__SUBSYSTEM:
            return getSubsystem();
         case SCAPackage.SCA_CORE_ROOT__TARGET:
            return getTarget();
         case SCAPackage.SCA_CORE_ROOT__TARGET_EPR:
            return getTargetEpr();
         case SCAPackage.SCA_CORE_ROOT__TARGET_URI:
            return getTargetUri();
         case SCAPackage.SCA_CORE_ROOT__INTERFACE_WSDL:
            return getInterfaceWsdl();
         case SCAPackage.SCA_CORE_ROOT__INTERFACE_JAVA:
            return getInterfaceJava();
         case SCAPackage.SCA_CORE_ROOT__BINDING_WS:
            return getBindingWs();
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION_JAVA:
            return getImplementationJava();
         case SCAPackage.SCA_CORE_ROOT__BINDING_EJB:
            return getBindingEjb();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SCA_CORE_ROOT__MIXED:
            getMixed().clear();
            getMixed().addAll((Collection) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__XMLNS_PREFIX_MAP:
            getXMLNSPrefixMap().clear();
            ((EMap.InternalMapView) getXMLNSPrefixMap()).eMap().addAll(
                  (Collection) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__XSI_SCHEMA_LOCATION:
            getXSISchemaLocation().clear();
            ((EMap.InternalMapView) getXSISchemaLocation()).eMap().addAll(
                  (Collection) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__ABSTRACT_COMPONENT:
            setAbstractComponent((Component) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__BINDING:
            setBinding((Binding) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__BINDING_SCA:
            setBindingSca((SCABinding) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__COMPONENT:
            setComponent((ImplementationComponent) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__COMPONENT_TYPE:
            setComponentType((ComponentType) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__COMPOSITE:
            setComposite((Composite) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION:
            setImplementation((Implementation) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION_ABSTRACT:
            setImplementationAbstract((AbstractImplementation) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION_UNKNOWN:
            setImplementationUnknown((UnknownImplementation) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__INTERFACE:
            setInterface((Interface) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__MODULE:
            setModule((Module) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__MODULE_COMPONENT:
            setModuleComponent((ModuleComponent) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__MODULE_FRAGMENT:
            setModuleFragment((ModuleFragment) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__SOURCE:
            setSource((Object) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__SOURCE_EPR:
            setSourceEpr((Object) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__SOURCE_URI:
            setSourceUri((String) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__SUBSYSTEM:
            setSubsystem((Subsystem) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__TARGET:
            setTarget((Object) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__TARGET_EPR:
            setTargetEpr((Object) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__TARGET_URI:
            setTargetUri((String) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__INTERFACE_WSDL:
            setInterfaceWsdl((WSDLPortType) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__INTERFACE_JAVA:
            setInterfaceJava((JavaInterface) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__BINDING_WS:
            setBindingWs((WebServiceBinding) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION_JAVA:
            setImplementationJava((JavaImplementation) newValue);
            return;
         case SCAPackage.SCA_CORE_ROOT__BINDING_EJB:
            setBindingEjb((SLSBBinding) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SCA_CORE_ROOT__MIXED:
            getMixed().clear();
            return;
         case SCAPackage.SCA_CORE_ROOT__XMLNS_PREFIX_MAP:
            getXMLNSPrefixMap().clear();
            return;
         case SCAPackage.SCA_CORE_ROOT__XSI_SCHEMA_LOCATION:
            getXSISchemaLocation().clear();
            return;
         case SCAPackage.SCA_CORE_ROOT__ABSTRACT_COMPONENT:
            setAbstractComponent((Component) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__BINDING:
            setBinding((Binding) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__BINDING_SCA:
            setBindingSca((SCABinding) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__COMPONENT:
            setComponent((ImplementationComponent) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__COMPONENT_TYPE:
            setComponentType((ComponentType) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__COMPOSITE:
            setComposite((Composite) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION:
            setImplementation((Implementation) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION_ABSTRACT:
            setImplementationAbstract((AbstractImplementation) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION_UNKNOWN:
            setImplementationUnknown((UnknownImplementation) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__INTERFACE:
            setInterface((Interface) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__MODULE:
            setModule((Module) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__MODULE_COMPONENT:
            setModuleComponent((ModuleComponent) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__MODULE_FRAGMENT:
            setModuleFragment((ModuleFragment) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__SOURCE:
            setSource((Object) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__SOURCE_EPR:
            setSourceEpr((Object) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__SOURCE_URI:
            setSourceUri(SOURCE_URI_EDEFAULT);
            return;
         case SCAPackage.SCA_CORE_ROOT__SUBSYSTEM:
            setSubsystem((Subsystem) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__TARGET:
            setTarget((Object) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__TARGET_EPR:
            setTargetEpr((Object) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__TARGET_URI:
            setTargetUri(TARGET_URI_EDEFAULT);
            return;
         case SCAPackage.SCA_CORE_ROOT__INTERFACE_WSDL:
            setInterfaceWsdl((WSDLPortType) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__INTERFACE_JAVA:
            setInterfaceJava((JavaInterface) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__BINDING_WS:
            setBindingWs((WebServiceBinding) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION_JAVA:
            setImplementationJava((JavaImplementation) null);
            return;
         case SCAPackage.SCA_CORE_ROOT__BINDING_EJB:
            setBindingEjb((SLSBBinding) null);
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SCA_CORE_ROOT__MIXED:
            return mixed != null && !mixed.isEmpty();
         case SCAPackage.SCA_CORE_ROOT__XMLNS_PREFIX_MAP:
            return xMLNSPrefixMap != null && !xMLNSPrefixMap.isEmpty();
         case SCAPackage.SCA_CORE_ROOT__XSI_SCHEMA_LOCATION:
            return xSISchemaLocation != null && !xSISchemaLocation.isEmpty();
         case SCAPackage.SCA_CORE_ROOT__ABSTRACT_COMPONENT:
            return getAbstractComponent() != null;
         case SCAPackage.SCA_CORE_ROOT__BINDING:
            return getBinding() != null;
         case SCAPackage.SCA_CORE_ROOT__BINDING_SCA:
            return getBindingSca() != null;
         case SCAPackage.SCA_CORE_ROOT__COMPONENT:
            return getComponent() != null;
         case SCAPackage.SCA_CORE_ROOT__COMPONENT_TYPE:
            return getComponentType() != null;
         case SCAPackage.SCA_CORE_ROOT__COMPOSITE:
            return getComposite() != null;
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION:
            return getImplementation() != null;
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION_ABSTRACT:
            return getImplementationAbstract() != null;
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION_UNKNOWN:
            return getImplementationUnknown() != null;
         case SCAPackage.SCA_CORE_ROOT__INTERFACE:
            return getInterface() != null;
         case SCAPackage.SCA_CORE_ROOT__MODULE:
            return getModule() != null;
         case SCAPackage.SCA_CORE_ROOT__MODULE_COMPONENT:
            return getModuleComponent() != null;
         case SCAPackage.SCA_CORE_ROOT__MODULE_FRAGMENT:
            return getModuleFragment() != null;
         case SCAPackage.SCA_CORE_ROOT__SOURCE:
            return getSource() != null;
         case SCAPackage.SCA_CORE_ROOT__SOURCE_EPR:
            return getSourceEpr() != null;
         case SCAPackage.SCA_CORE_ROOT__SOURCE_URI:
            return SOURCE_URI_EDEFAULT == null ? getSourceUri() != null
                  : !SOURCE_URI_EDEFAULT.equals(getSourceUri());
         case SCAPackage.SCA_CORE_ROOT__SUBSYSTEM:
            return getSubsystem() != null;
         case SCAPackage.SCA_CORE_ROOT__TARGET:
            return getTarget() != null;
         case SCAPackage.SCA_CORE_ROOT__TARGET_EPR:
            return getTargetEpr() != null;
         case SCAPackage.SCA_CORE_ROOT__TARGET_URI:
            return TARGET_URI_EDEFAULT == null ? getTargetUri() != null
                  : !TARGET_URI_EDEFAULT.equals(getTargetUri());
         case SCAPackage.SCA_CORE_ROOT__INTERFACE_WSDL:
            return getInterfaceWsdl() != null;
         case SCAPackage.SCA_CORE_ROOT__INTERFACE_JAVA:
            return getInterfaceJava() != null;
         case SCAPackage.SCA_CORE_ROOT__BINDING_WS:
            return getBindingWs() != null;
         case SCAPackage.SCA_CORE_ROOT__IMPLEMENTATION_JAVA:
            return getImplementationJava() != null;
         case SCAPackage.SCA_CORE_ROOT__BINDING_EJB:
            return getBindingEjb() != null;
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (mixed: "); //$NON-NLS-1$
      result.append(mixed);
      result.append(')');
      return result.toString();
   }

} // SCACoreRootImpl
