/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.cxf.generators;

import java.io.File;

import org.apache.cxf.tools.common.ToolConstants;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.java2wsdl.processor.JavaToProcessor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.runtimeintegrator.IGeneratorTool;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.jaxws.preferences.PreferencesAccessor;
import org.eclipse.stp.sc.jaxws.preferences.SCPreferenceConstants;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IJavaToWsdlGenerator;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;



/*
 * TODO: remove IJavaToWsdlGenerator later once the refactor has finished.
 */
public class CeltixJavaToWsdlGenerator implements IJavaToWsdlGenerator,
    IGeneratorTool {
    
    private static final LoggingProxy LOG = LoggingProxy.getlogger(CeltixJavaToWsdlGenerator.class);
    
    public void setInitializationData(IConfigurationElement config,
        String propertyName, Object data) throws CoreException {
    }

    public void run(IPath path, IProject project) throws CoreException {
        LOG.info("Regenerate WSDL for " + path.toString());

        try {

        	IContainer wsdlLocation = JaxWsWorkspaceManager.getWSDLGenFolder(path, project);
            
            LOG.info("WSDL location is: " + wsdlLocation);
            
            JavaToProcessor processor = new JavaToProcessor();
            ToolContext env = new ToolContext();
            
            String javaName = ResourceUtils.getFileNameWithoutExt(path);
            String wsdlUrl = wsdlLocation.getLocation().toOSString()
                                + File.separator 
                                + javaName
                                + ".wsdl";
            
            String soap12 = project.getPersistentProperty(
            		ScJaxWsPropertyConstants.PROPERTY_KEY_SOAP_OPTION);
            LOG.debug("soap12 from project: " + soap12);
            if (soap12 == null) {
            	if (PreferencesAccessor.getSoap12Option()) {
            		soap12 = "anyValue";
            		LOG.debug("soap12 is needed.");
                    env.put(ToolConstants.CFG_SOAP12, soap12);
            	}
            } else if (soap12.equals(SCPreferenceConstants.KEY_SOAP12)) {
                env.put(ToolConstants.CFG_SOAP12, soap12);
                LOG.debug("soap12 is needed by project");
            }
            env.put(ToolConstants.CFG_OUTPUTFILE, wsdlUrl);
            env.put(ToolConstants.CFG_SOURCEDIR, 
            		JaxWsWorkspaceManager.getSrcFolder(project).getLocation().toOSString());
            env.put(ToolConstants.CFG_COMPILE, 
            		JaxWsWorkspaceManager.getClassesFolder(project).getLocation().toOSString());

            //setup classpath 
            String classPath = JDTUtils.getProjectClasspathAsString(project);
            LOG.debug("classpaths passed to j2w:" + classPath);

            IFile javaFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            String clsName = JDTUtils.getJavaClassNameFromFile(javaFile);
            LOG.debug("target cls name:" + clsName);

            if (clsName == null) {
                throw new Exception("failed to get java class name");
            }

            env.put(ToolConstants.CFG_CLASSNAME, clsName);

            env.put(ToolConstants.CFG_CLASSPATH, classPath);
            processor.setEnvironment(env);            
            processor.process();
            LOG.debug("merge the geneared wsdl and schema file");
//            WsdlUtils.expendImportSchemas(wsdlUrl, wsdlUrl);
            project.refreshLocal(IProject.DEPTH_INFINITE, null);
        } catch (Throwable e) {
            LOG.error("Celtix Java To Wsdl Generation failure", e);
        }
    }
}
