/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.cxf.generators;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import javax.wsdl.Definition;
import javax.xml.namespace.QName;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IType;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.runtimeintegrator.IGeneratorTool;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.cxf.launchers.JavaLaunchConfig;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWsdlToJavaGenerator;
import org.eclipse.stp.sc.jaxws.wsdl.WsdlUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolConstants;
//import org.apache.cxf.tools.wsdlto.WSDLToJavaContainer;.processor.WSDLToJavaProcessor;
import org.apache.cxf.tools.wsdlto.core.DataBindingProfile;
import org.apache.cxf.tools.wsdlto.core.FrontEndProfile;
import org.apache.cxf.tools.wsdlto.core.PluginLoader;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.JAXWSContainer;
import org.apache.cxf.tools.util.URIParserUtil;



public class CeltixWsdlToJavaGenerator implements IWsdlToJavaGenerator, IGeneratorTool {
    
    private static final LoggingProxy LOG = LoggingProxy.getlogger(CeltixWsdlToJavaGenerator.class);
    
    private Hashtable toolParams = new Hashtable();

    public void setInitializationData(IConfigurationElement config,
                                      String propertyName,
                                      Object data) throws CoreException {
        if (data instanceof Hashtable) {
        	toolParams = (Hashtable)data;
        }
    }
    
    public void run(IPath path, IProject project) throws CoreException {
        String url;
        try {
            url = path.toFile().toURL().toExternalForm();
            run(url, project);
        } catch (MalformedURLException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
    }

    /*
     * generate java from wsdl file within workspace
     * @see org.eclipse.stp.sc.jaxws.runtimeprovider.IWsdlToJavaGenerator#run(org.eclipse.core.runtime.IPath, org.eclipse.core.resources.IProject)
     */
//    public void run(IPath path, IProject project) throws CoreException {
//        ToolContext env = new ToolContext();
//        IFile file = project.getWorkspace().getRoot().getFile(path);
//        env.put(ToolConstants.CFG_WSDLURL,
//            file.getRawLocation().toOSString());
//        
//        run(env, project);
//    }
    
      public void run(String url, IProject project) throws CoreException {
        try {
        	JAXWSContainer processor = new JAXWSContainer(null);
            ToolContext env = new ToolContext();
            env.put(FrontEndProfile.class, PluginLoader.getInstance().getFrontEndProfile("jaxws"));
            env.put(DataBindingProfile.class, PluginLoader.getInstance().getDataBindingProfile("jaxb"));
            env.put(ToolConstants.CFG_VERBOSE, ToolConstants.CFG_VERBOSE);
            env.put(ToolConstants.CFG_WSDLURL, url);

            //output dir
            String outDir = (String)toolParams.get(IWsdlToJavaGenerator.GEN_OUTPUTDIR);
            LOG.debug("Wsdl to Java output dir: " + outDir);
            File file = new File(outDir);
            if (!file.exists()) {
            	file.mkdirs();
            }
            env.put(ToolConstants.CFG_OUTPUTDIR, outDir);
            
            Map specificParams = (Map)toolParams.get(IWsdlToJavaGenerator.TOOL_SPECIFIC_OPS);
            
            String genOps = (String)specificParams.get(ToolConstants.CFG_IMPL);
            //if impl
            if (genOps != null) {
                LOG.debug("The impl option has been set");
                env.put(ToolConstants.CFG_GEN_IMPL, "");
                env.put(ToolConstants.CFG_GEN_SERVICE, ToolConstants.CFG_GEN_SERVICE);
                env.put(ToolConstants.CFG_GEN_TYPES, "");
            }
            genOps = (String)specificParams.get(ToolConstants.CFG_SERVER);
            //if server
            if (genOps != null) {
                LOG.debug("The server option has been set");
                env.put(ToolConstants.CFG_GEN_TYPES, "");
                env.put(ToolConstants.CFG_GEN_SERVICE, ToolConstants.CFG_GEN_SERVICE);
                env.put(ToolConstants.CFG_GEN_IMPL, "");
                env.put(ToolConstants.CFG_GEN_SERVER, "");
            }
            genOps = (String)specificParams.get(ToolConstants.CFG_CLIENT);
            //if client
            if (genOps != null) {
                LOG.debug("The client option has been set");
                env.put(ToolConstants.CFG_CLIENT, "");
                env.put(ToolConstants.CFG_GEN_TYPES, "");
                env.put(ToolConstants.CFG_GEN_SERVICE, ToolConstants.CFG_GEN_SERVICE);
            }

            //binding files
            ArrayList bindingParams = (ArrayList)specificParams.get(CeltixWsdlToJavaParameterPage.KEY_BINDING_FILE_LIST);
            if (bindingParams != null) {
                for (Object bf : bindingParams) {
                    LOG.debug("BINDing files: " + bf);
                }
            }
            
            //exsh
            String soapOps = (String)specificParams.get(ToolConstants.CFG_EXTRA_SOAPHEADER);
            if (soapOps != null) {
                LOG.debug("Extra soap header option selected");
                env.put(ToolConstants.CFG_EXTRA_SOAPHEADER, "");
            }
            //dns
            soapOps = (String)specificParams.get(ToolConstants.CFG_DEFAULT_NS);
            if (soapOps != null) {
                LOG.debug("default namespace option selected");
                env.put(ToolConstants.CFG_DEFAULT_NS, "");
            }
            
            //dex
            soapOps = (String)specificParams.get(ToolConstants.CFG_DEFAULT_EX);
            if (soapOps != null) {
                LOG.debug("default  default excludes option selected");
                env.put(ToolConstants.CFG_DEFAULT_EX, "");
            }
            
            //ant and verbose
            String miscOps = (String)specificParams.get(ToolConstants.CFG_ANT);
            if (miscOps != null) {
                LOG.debug("The ant option has been set");
                env.put(ToolConstants.CFG_ANT, "");
            }
            miscOps = (String)specificParams.get(ToolConstants.CFG_VERBOSE);
            //verbose
            if (miscOps != null) {
                LOG.debug("The verbose option has been set");
                env.put(ToolConstants.CFG_VERBOSE, "");
            }
            
            String wsdlName = (String)env.get(ToolConstants.CFG_WSDLURL);
            Definition wsdlDef = WsdlUtils.readWSDL(wsdlName);
            Iterator iPortTypes = wsdlDef.getPortTypes().keySet().iterator();

            while (iPortTypes.hasNext()) {
                QName portType = (QName)iPortTypes.next();
                String packageName = URIParserUtil.getPackageName(portType.getNamespaceURI());
                String seiCLsName = packageName + "." +  portType.getLocalPart();
                
                try {
                    IType type = JDTUtils.findTypeByName(project, seiCLsName);
                    if (type == null || type.isClass()) {
                        env.put(ToolConstants.CFG_GEN_SEI, ToolConstants.CFG_GEN_SEI);  
                    }
                } catch (Exception typeE){
                    env.put(ToolConstants.CFG_GEN_SEI, ToolConstants.CFG_GEN_SEI);
                }
                
                // generate any associated launchers
                if (env.get(ToolConstants.CFG_CLIENT) != null || env.get(ToolConstants.CFG_GEN_CLIENT) != null) {
                    env.put(ToolConstants.CFG_SERVICE, ToolConstants.CFG_SERVICE);
                    env.put(ToolConstants.CFG_GEN_OVERWRITE, ToolConstants.CFG_GEN_OVERWRITE);
                    
                    // generate a client launcher for each defined PortType 
                    createClientLaunchConfiguration(portType.getLocalPart() + "Client",
                            packageName, wsdlName);
                }

                if (env.get(ToolConstants.CFG_SERVER) != null || env.get(ToolConstants.CFG_GEN_SERVER) != null) {
                    // generate a server launcher for each defined PortType
                    env.put(ToolConstants.CFG_GEN_OVERWRITE, ToolConstants.CFG_GEN_OVERWRITE);
                    
                    // if generating a complete server stub, make sure implementation
                    // class is generated too.
                    if (env.get(ToolConstants.CFG_SERVER) != null) { 
                        env.put(ToolConstants.CFG_IMPL, new Boolean(true));
                    }
                    createServerLaunchConfiguration(portType.getLocalPart() + "Server",
                            packageName, null);
                }
            }

            //setup classpath 
            String classPath = JDTUtils.getProjectClasspathAsString(project);
            LOG.debug("classpaths passed to w2j:" + classPath);

            env.put(ToolConstants.CFG_CLASSPATH, classPath);
            processor.setContext(env);
            processor.execute();
            project.refreshLocal(IProject.DEPTH_INFINITE, null);
            
        } catch (Exception e) {
            LOG.error("wsdl to java generation error", e);
        }
    }
    
    /**
     * This method creates a client launch configuration to launch the produced client
     * code, if any, from within the eclipse environment  
     */
    private void createClientLaunchConfiguration(String clientName, 
        String packageName, String progArgs) {
    	if (ResourceUtils.getActiveProject() == null) {
            return;
    	}
    	String projectName = ResourceUtils.getActiveProject().getName();
        //create the java launch configuration
        JavaLaunchConfig launchConfig = new JavaLaunchConfig();
        launchConfig.setProgramArgs(progArgs);
        launchConfig.setConfigBaseName(clientName);
        launchConfig.setProjectName(projectName);
        launchConfig.setClientMainClassName(packageName + "." + clientName);
        launchConfig.createClientLaunchConfig();
        
        //if the server is deployed on container(such as tomcat). 
        //generate client against server app running inside container
        //comment out for now, since we are not using wtp deploy
//        try {
//            String url = WtpUtils.getServerUrl(wsdlFile);
//            if (url == null) {
//                return;
//            }
//            
//            JavaLaunchConfig containerClntConfig = new JavaLaunchConfig();
//            containerClntConfig.setProgramArgs(url);
//            containerClntConfig.setConfigBaseName(clientName + "_Tomcat");
//            containerClntConfig.setProjectName(projectName);
//            containerClntConfig.setClientMainClassName(packageName + "." + clientName);
//            containerClntConfig.createClientLaunchConfig();
//        } catch (Exception e) {
//            LOG.error(e);
//        }
    }

    /**
     * This method creates a server launch configuration to launch the produced client
     * code, if any, from within the eclipse environment  
     */
    private void createServerLaunchConfiguration(String serverName, 
        String packageName, String progArgs) {
    	if (ResourceUtils.getActiveProject() == null) {
    		return;
    	}
        String projectName = ResourceUtils.getActiveProject().getName();

        //create the java launch configuration
        JavaLaunchConfig launchConfig = new JavaLaunchConfig();
        launchConfig.setProgramArgs(progArgs);
        launchConfig.setConfigBaseName(serverName);
        launchConfig.setProjectName(projectName);
        launchConfig.setServerMainClassName(packageName + "." + serverName);
        launchConfig.createServerLaunchConfig();
    }        
}
