package org.eclipse.stp.sc.cxf.kitprocessor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.preferences.PreferencesAccessor;
import org.eclipse.stp.sc.jaxws.preferences.SCPreferenceConstants;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeKitProcessorTemplate;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;

public class CeltixKitProcessorTemplate implements IRuntimeKitProcessorTemplate,
    org.eclipse.stp.sc.common.runtimeintegrator.IRuntimeKitProcessorTemplate {
    
    public static final LoggingProxy LOG = LoggingProxy.getlogger(CeltixKitProcessorTemplate.class);

    private static final String CELTIX_KIT_HOME_VAR_NAME = "CXF_HOME";

    private static final String CELTIX_KIT_HOME_WIN = "c:/celtix1.0";
    private static final String CELTIX_KIT_HOME_UNIX = "???";

    private static final char SEP = IPath.SEPARATOR;

    private static final IPath LIBS_PATH = new Path(SEP + "lib" + SEP);

//    public static final String CXF_FACADE_LIB = "cxf-incubator.jar";
    public static final String CXF_FACADE_LIB = "cxf-manifest-incubator.jar";

    public List<IPath> getDefaultBuildPathEntries(IProject project) {
		List<IPath> libPaths = new ArrayList<IPath>();
		
		String kitLoc = getProjectKitLoc(project);
		LOG.debug("kit location: " + kitLoc);

		if (kitLoc != null) {
 		    String[] cxfLibs = getKitRtLibs(kitLoc);

            for (int i = 0; i < cxfLibs.length; ++i) {
            	IPath lib = LIBS_PATH.append(cxfLibs[i]);
            	File jarFile = new File(kitLoc + lib.toString());
            	if (!jarFile.exists()) {
            		continue;
            	}
                try {
                    libPaths.add(LIBS_PATH.append(cxfLibs[i]));
                } catch (Exception e) {
                    // lib name was probably incorrect, so ignore it and move to the next
                    LOG.debug("build path entry invalid: " + cxfLibs[i], e); 
                }
            }
		}
		
        return libPaths;
    }
    

    private String[] getKitRtLibs(String kitLoc) {
    	ArrayList<String> libs = new ArrayList<String>();
    	String jarPath = kitLoc + File.separator + "lib" + File.separator + CXF_FACADE_LIB;
    	File facadeFile = new File(jarPath);
    	try {
			JarFile facadeJar = new JarFile(facadeFile);
			Manifest mfst = facadeJar.getManifest();
			Attributes attrs = mfst.getMainAttributes();
			String path = attrs.getValue("Class-Path");
			LOG.debug("Path: " + path);
			StringTokenizer tkzr = new StringTokenizer(path);
			String libEntry = null;
			while(tkzr.hasMoreTokens()) {
				libEntry = tkzr.nextToken();
				libs.add(libEntry);
			}
		} catch (IOException e) {
			LOG.debug("Exception getting jar facade", e);
		}
		return (String[])libs.toArray(new String[0]);
	}

	private String getProjectKitLoc(IProject project) {
    	String kitLoc = null;
		try {
			kitLoc = project.getPersistentProperty(
					ScJaxWsPropertyConstants.PROPERTY_KEY_RUNTIME_ROOT);
		} catch (CoreException e1) {
			LOG.debug("Encounter exception getting project property", e1);
		}
		if (kitLoc == null) {
			IExtension[] exts = RuntimeProviderManager.getInstance().getAllRegistredProviders();
			if (exts.length > 0) {
				String fieldKey = 
	                PreferencesAccessor.resolvePrefKey(SCPreferenceConstants.KEY_RUNTIME_INSTALL_ROOT,
	                                                   exts[0].getUniqueIdentifier());
				IPreferenceStore store = ScJaxWsPlugin.getDefault().getPreferenceStore();
				kitLoc = store.getString(fieldKey);
			}
		}
		return kitLoc;
	}

	public IPath getDefaultInstallDirectory() {
        if (Platform.getOS().equals(Platform.OS_WIN32)) {
            return new Path(CELTIX_KIT_HOME_WIN);
        }
        return new Path(CELTIX_KIT_HOME_UNIX);
    }

    public String getDefaultSubstitutionVarName() {
        return CELTIX_KIT_HOME_VAR_NAME;
    }

    public List<IPath> validateBuildPathEntries(List<IPath> proposedBuildPath) {
        // TODO will be necessary whne the extented prefs page support will be added
        return new ArrayList<IPath>(0);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        // nothing to do here
    }

    public boolean isInstallDirectoryValid(IPath installationPath) {
        if (installationPath != null)  {
            File installationDir = installationPath.toFile();
            
            return installationDir.exists()
                    && installationDir.isDirectory()
                    && (new File(installationDir, "")).exists()
                    && (new File(installationDir, "etc" + File.separator + "web.xml")).exists();
        }
        return false;
    }
}
