/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWsdlToJavaWizard;
import org.eclipse.stp.sc.jaxws.workspace.ScNature;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;


public class WsdlToJavaAction implements IObjectActionDelegate, IWorkbenchWindowActionDelegate {

    private static final LoggingProxy LOG = LoggingProxy.getlogger(WsdlToJavaAction.class);

    private StructuredSelection currentSelection = null;
    
    /**
     * Constructor for Action1.
     */
    public WsdlToJavaAction() {
        super();
    }

    /**
     * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
     */
    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    /**
     * @see IActionDelegate#run(IAction)
     */
    public void run(IAction action) {
        try {
        	//Johnson changed to use IWsdlToJavaDialog
            IProject project = ResourceUtils.getActiveProject();
        	IWsdlToJavaWizard wizard = ScJaxWsPlugin
			    .getRuntimeProviderManager()
			    .getWsdlToJavaWizard(project);
        	wizard.setSelection(currentSelection);
        	
//          GenerateCodeWizard wizard = new GenerateCodeWizard(currentSelection);
            Shell shell = PlatformUI.getWorkbench()
                                    .getActiveWorkbenchWindow().getShell();
            WizardDialog dialog = new WizardDialog(shell, wizard);
//            ScWizardDialog dialog = new ScWizardDialog(shell, wizard);
            dialog.open();
            project.refreshLocal(IResource.DEPTH_INFINITE, null);
        } catch (Exception e) {
            LOG.error("error during wsdl to java generation", e);
        }
    }

    /**
     * @see IActionDelegate#selectionChanged(IAction, ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    	LOG.debug("the selection changed: " + selection);
    	if (selection instanceof StructuredSelection) {
    		currentSelection = (StructuredSelection)selection;
    	}
        
        // TODO Auto-generated method stub
        IResource selectedResource = ResourceUtils.getSelectedResource();
        
        try {
            action.setEnabled(selectedResource != null
                              && selectedResource instanceof IFile
                              && ((IFile)selectedResource).getFileExtension().toLowerCase().equals("wsdl")
                              && ScNature.hasNature(selectedResource.getProject()));
        } catch (CoreException e) {
            // TODO Auto-generated catch block
            LOG.debug("error while trying to figure out if the action should be enabled", e);
        }

    }

    public void dispose() {
        // TODO Auto-generated method stub
        
    }

    public void init(IWorkbenchWindow window) {
        // TODO Auto-generated method stub
        
    }
}
