package org.eclipse.stp.sc.jaxws.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class ProjectWizardBase extends Wizard implements INewWizard, IExecutableExtension{

	public static final String GENERAL_PAGE = "generalPage";
	protected IConfigurationElement fConfigElement;
	WizardNewProjectCreationPage genPage;
	
	protected String projectMode;
    protected IProject project;

	public ProjectWizardBase() {
		super();
        String title = ScJaxWsResources.getString("CreateWebServiceProjectWizard.Title");
        setWindowTitle(title);
	}

	public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
	    fConfigElement = cfig;
	}

	public void addPages() {
	    genPage = new WizardNewProjectCreationPage(GENERAL_PAGE);
	    genPage.setTitle(ScJaxWsResources.getString("WebServiceGeneralPage.Title"));
	    genPage.setDescription(ScJaxWsResources.getString("WebServiceGeneralPage.Description"));
	
	    ImageDescriptor banner = ScJaxWsResources.getImageDescriptor("wizban/Celtix_project_folder_wiz.jpg");
	    genPage.setImageDescriptor(banner);
	    addPage(genPage);
	}

	@Override
	public boolean performFinish() {
	    try {
	        createProject(null);
	        BasicNewProjectResourceWizard.updatePerspective(fConfigElement);
	    } catch (InvocationTargetException e) {
	        return false;
	    }
	
	    return true;
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
        setNeedsProgressMonitor(true);
	}

	/**
	 * actually create the project
	 * @param newMonitor
	 * @throws InvocationTargetException
	 */
    protected boolean createProject(IProgressMonitor newMonitor) throws InvocationTargetException {
	
	    IProgressMonitor checkedMonitor = (newMonitor != null) ? newMonitor
	                                                           : new NullProgressMonitor();
	    checkedMonitor.beginTask("", 100);
	
	    IProgressMonitor createProjectMonitor = new SubProgressMonitor(checkedMonitor, 20);
	    project = JaxWsWorkspaceManager.createProject(createProjectMonitor,
	                                   genPage.getProjectName(),
	                                   genPage.getLocationPath(),
	                                   projectMode);
	
	    try {
	        project.refreshLocal(IProject.DEPTH_INFINITE, checkedMonitor);
	    } catch (Exception ce) {
	    	ce.printStackTrace();
	    }
	    return true;
	}

	public String getProjectMode() {
		return projectMode;
	}
	
	protected void setProjectMode(String value) {
		projectMode = value;
	}
}