/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards;


import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWsdlToJavaGenerator;
import org.eclipse.stp.sc.jaxws.wizards.wsdltojava.WsdlToJavaGenerateAction;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.ui.INewWizard;


public class WsdlFirstProjectWizard extends ProjectWizardBase implements INewWizard, IExecutableExtension {
	
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WsdlFirstProjectWizard.class);
    private static final String VALIDATOR_BUILDER_ID = "org.eclipse.stp.sc.annvalidator";
    
	private static final String WSDL_PAGE = "wsdlPage";
    private static final String GENATOR_PAGE = "genPage";
    
	WsdlSettingPage wsdlPage;
    WsdlGenPage wsdlGenPage;
    public WsdlFirstProjectWizard() {
        super();
        projectMode = ScJaxWsPropertyConstants.PROJECT_MODE_WSDLFIRST;
    }
    
    public void addPages() {
	    super.addPages();
	    wsdlPage = new WsdlSettingPage(WSDL_PAGE);
        addPage(wsdlPage);
        wsdlGenPage = new WsdlGenPage(GENATOR_PAGE);
        addPage(wsdlGenPage);
	}
    
    public boolean performFinish() {
        try {
            super.performFinish();
            //generate wsdl files
            generateWSDLFiles();
            //generate code
            generateCode();
        	JaxWsWorkspaceManager.setupProjectNature(
        			project, ScJaxWsPropertyConstants.PROJECT_MODE_WSDLFIRST);
            WorkspaceManager.addBuilder(project, VALIDATOR_BUILDER_ID, 
                WorkspaceManager.BuilderOrder.FIRST);
        } catch (Exception e) {
            LOG.error("Error during add builder", e);
        }
        return true;
    }
    
    
     
    private void generateCode() {
        if (!wsdlPage.IsGenCode()) {
            return;
        }
        LOG.debug("try to generate code");
        WsdlToJavaGenerateAction action = new WsdlToJavaGenerateAction();
        action.setNeedMerge(false);
        Hashtable<String, Object> genParams = new Hashtable<String, Object>();
        
        genParams.put(IWsdlToJavaGenerator.TOOL_SPECIFIC_OPS, wsdlGenPage.paramPage.getParameters());
        String srcDir = JaxWsWorkspaceManager.getSrcFolder(project).getLocation().toOSString();
        LOG.debug("generate code to src dir:" + srcDir);
        genParams.put(IWsdlToJavaGenerator.GEN_OUTPUTDIR, srcDir);
        
        try {
            String wsdlUrl;
            if (wsdlPage.composite.rbtLocalFile.getSelection()) {
                wsdlUrl = wsdlPage.composite.txtFilePath.getText();
            } else {
                wsdlUrl = wsdlPage.composite.txtUrl.getText();
            }
            action.generate(wsdlUrl,
                    project, genParams);
            project.refreshLocal(IProject.DEPTH_INFINITE, null);
        } catch (CoreException e) {
            LOG.error("error during generate code.", e);
        }
    }
    
    
    private void generateWSDLFiles(){
    	createWSDLFolder();
    	if (wsdlPage.composite.rbtLocalFile.getSelection()) {
            createLinkFile(wsdlPage.composite.txtFilePath.getText());
        } else {
        	importRemoteFile(wsdlPage.composite.txtUrl.getText());
        }  
    	refreshWSDLFolder();
    }
    
    private void createLinkFile(String filePath)
    {
    	if(filePath == null) 
    		return;
    	try{
        	IPath location = new Path(filePath);
        	String fileName = location.toFile().getName();
        	IContainer wsdlFolder = JaxWsWorkspaceManager.getWSDLFolder(project);
        	String fName = "";
        	if(wsdlFolder  != null){
        		fName = wsdlFolder.getProjectRelativePath().toString() + "/";
        	}
        	
        	IFile linkFile = project.getFile(fName + fileName);
        	if (project.getWorkspace().validateLinkLocation(linkFile,location).isOK()) 
        		linkFile.createLink(location, IResource.NONE, null);
        	else
        		LOG.error("error while creating linked file: " + filePath);
    	} catch (CoreException e)
    	{
    		LOG.error("error while creating linked file to wsdl", e);
    	}
    }
    
    private void importRemoteFile(String urlStr)
    {
    	InputStream is = null;
    	FileOutputStream fos = null;
    	IContainer linkFolder = JaxWsWorkspaceManager.getWSDLFolder(project);
    	try {
        	URL url = new URL(urlStr);
			String fileName = url.getFile();
			if(!fileName.toLowerCase().endsWith(".wsdl"))
				fileName = new String(fileName + ".wsdl");
			IPath filePath = linkFolder.getLocation().append(fileName);
			File file = filePath.toFile();
			if(file.exists())
				file.delete();
			file.createNewFile();
			fos=new FileOutputStream(file);
			URLConnection yc = url.openConnection();
			is = yc.getInputStream();
			byte[] b=new byte[1024 * 5];
			int len = 0;
			while ((len=is.read(b))!=-1) {
				fos.write(b, 0, len);
			}
		} catch (Exception e) {
			LOG.error("error while reading from the url: " + urlStr, e);
		} finally{
			try{
				if(is != null)
					is.close();
				if(fos != null)
					fos.close();
			}catch (Exception e){
				LOG.error("error while closing input/output stream", e);
			}
		}
    }
    
    private void createWSDLFolder(){
    	try{
    		IContainer linkFolder = JaxWsWorkspaceManager.getWSDLFolder(project);
        	if(!linkFolder.exists() && linkFolder instanceof IFolder){
        		((IFolder)linkFolder).create(true, true, null);
        	}   		
    	}catch (Exception e){
    		LOG.error("error while creating wsdl folder", e);
    	}
    }
    
    private void refreshWSDLFolder(){
    	try{
    		IContainer linkFolder = JaxWsWorkspaceManager.getWSDLFolder(project);
        	if(linkFolder.exists()){
        		linkFolder.refreshLocal(IResource.DEPTH_INFINITE, null);
        	}   		
    	}catch (CoreException e){
    		LOG.error("error while refreshing wsdl folder", e);
    	}    	
    }
    
    /**
     * get the wsdl url from wsdl selection page
     * @return
     */
    public String getWsdlURL() {
    	if (wsdlPage.composite.rbtLocalFile.getSelection()) {
            return wsdlPage.composite.txtFilePath.getText();
        } else {
            return wsdlPage.composite.txtUrl.getText();
        }
    }
    
}
