/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wsdl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;

import org.eclipse.core.resources.IFile;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


public class WsdlUtils {
    
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WsdlUtils.class);    
    
    protected WsdlUtils() {
    }
    
    public static boolean importWsdlToWorkspace(String path, IFile targetFile) {
        return false;
    }
    
    public static boolean importWsdlToWorkspace(URL url, IFile targetFile) {
        return false;
    }

    @SuppressWarnings("deprecation")
    public static Definition readWSDL(IFile wsdlFile)
        throws WSDLException, IOException, URISyntaxException {
        String url = wsdlFile.getRawLocation().toFile().toURL().toString();

        return readWSDL(url);
    }

    public static Definition readWSDL(String wsdlURL)
        throws WSDLException {
        LOG.debug("try to read wsdl file:" + wsdlURL);

        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        wsdlReader.setFeature("javax.wsdl.importDocuments", true);

        Definition wsdlDef = wsdlReader.readWSDL(wsdlURL);

        //process the imports in wsdl.
        LOG.debug("wsdl file loaded");
        return wsdlDef;
    }
    
    public static void saveWSDL(Definition wsdlDef, String wsdlURL) throws WSDLException, IOException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
        FileOutputStream fos = new FileOutputStream(wsdlURL);
        wsdlWriter.writeWSDL(wsdlDef, fos);
        fos.close();
    }

    
    @SuppressWarnings("unchecked")
    /**
     * load the import scheam, save to a new wsdl file without schema import
     * @param wsdlDef
     * @return boolean true if processed import schema
     */
    public static void expendImportSchemas(String wsdlURL, String targetURL) 
        throws WSDLException, URISyntaxException, IOException {
        
        boolean overWrite = false;
        Definition wsdlDef = readWSDL(wsdlURL);
        Vector<Schema> importedSchemaList = new Vector<Schema>();
        Iterator<ExtensibilityElement> itor = wsdlDef.getTypes().getExtensibilityElements().iterator();
        while (itor.hasNext()) {
            ExtensibilityElement elem = itor.next();
            if (elem instanceof Schema) {
                if (processOneSchema((Schema)elem, importedSchemaList, wsdlURL)) {
                    itor.remove();
                    overWrite = true;
                }
            }
        }
        
        
        for (Schema schema : importedSchemaList) {
            removeImports(schema);
            printSchema(schema);
            wsdlDef.getTypes().getExtensibilityElements().add(schema);
        }
        
        if (overWrite) {
            if (targetURL == null) {
                saveWSDL(wsdlDef, wsdlURL);
            } else {
                saveWSDL(wsdlDef, targetURL);
            }
        }
    }
    
    @SuppressWarnings("unchecked")
    private static boolean processOneSchema(Schema schema, Vector<Schema> importedSchemaList, String wsdlURL)
        throws URISyntaxException {
         
        Map imports = schema.getImports();
        int removedImportCount = 0;
        //key are namespace
        Iterator itor = imports.keySet().iterator();
        while (itor.hasNext()) {
            String namespaceURI = (String)itor.next();
        
            List<SchemaImport> namespaceImports = (List<SchemaImport>)imports.get(namespaceURI);
            Iterator importItor = namespaceImports.iterator();
            while (importItor.hasNext()) {               
                SchemaImport sImport = (SchemaImport)importItor.next();
                URI uri = new URI(sImport.getSchemaLocationURI());
                LOG.debug("import schema uri:" + uri.toString());
                if (uri.getScheme() == null
                    || uri.getScheme().equals("")
                    || uri.getScheme().startsWith("file")) {
                                        
                    deleteImportSchemaFile(uri, wsdlURL);
                    
                    //the schema import location is local file. need to expend that schema into wsdl
                    LOG.debug("expend import schema:" + sImport.getSchemaLocationURI());
                    Schema refSchema = sImport.getReferencedSchema();
                    refSchema.getElement().setPrefix(schema.getElement().getPrefix());
                    importedSchemaList.add(refSchema);
                    LOG.debug("remove import:" + sImport.getSchemaLocationURI());
                    importItor.remove();
                    removedImportCount++;
                }
            }
            if (namespaceImports.size() == 0) {
                itor.remove();
            }
            
        }
        if (imports.keySet().size() == 0) {
            imports.clear();
            //remove this scheam if it only has import statments
            if (schema.getElement().getChildNodes().getLength() == removedImportCount) {
                //it is empty schema node now, need to be removed
                return true;
            }   
        }
        
        return false;
    }

    @SuppressWarnings("unchecked")
    private static void removeImports(Schema schema) {
        
        Map imports = schema.getImports();
        imports.clear();
        Element elem = schema.getElement();
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            Node childNode = nodes.item(i);
            if (childNode.getLocalName() != null
                && childNode.getLocalName().equals("import")) {
                elem.removeChild(nodes.item(i));        
            }
        }        
    }
    
    
    private static void deleteImportSchemaFile(URI uri, String wsdlURL) {
        String path = wsdlURL.substring(0, wsdlURL.lastIndexOf(File.separator) + 1) + uri.getPath(); 
        File schemaFile = new File(path);
        
        LOG.debug("delete import schema file:" + schemaFile.getAbsolutePath());
        schemaFile.delete();
    }
    
    
    
    private static void printSchema(Schema schema) {
        LOG.debug("************** schema start ******************");
        LOG.debug(" base url:" + schema.getDocumentBaseURI());
        LOG.debug(" imports size:" + schema.getImports().size());
        LOG.debug(" include size:" + schema.getIncludes().size());
        LOG.debug(" redefines size:" + schema.getRedefines().size());
        LOG.debug(" element:" + schema.getElement());
        
        LOG.debug(" element type:" + schema.getElementType());
        LOG.debug(" node prefix:" + schema.getElement().getPrefix());
        Element elem = schema.getElement();
        NodeList nodeList = elem.getChildNodes();
        LOG.debug("  child nodes list:" + nodeList.getLength());
        
            
        
        if (schema instanceof SchemaImport) {
            SchemaImport sImport = (SchemaImport)schema;
            LOG.debug("   import ns uri:" + sImport.getNamespaceURI());
            LOG.debug("   import schema location:" + sImport.getSchemaLocationURI());
            LOG.debug("   import referenedSchema:" + sImport.getReferencedSchema());
            LOG.debug("    ***********************referenced schema start***********************");
            printSchema(sImport.getReferencedSchema());
            LOG.debug("    ***********************referenced schema end***********************");
        }
        LOG.debug("************** schema end ******************");
    }
    
}
