/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/

package org.eclipse.stp.sc.sca.java.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.sca.java.workspace.ScaWorkspaceManager;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

import org.osoa.sca.annotations.Remotable;
import org.osoa.sca.annotations.Service;

public class JavaClassGenerator {

	public static final String LINE_SEPARATOR = System.getProperty("line.separator");
	
	/**
	 * create server mainline
	 * @param packageName
	 * @param className
	 * @param project
	 * @throws JavaModelException 
	 */
	public void createScaServerMain(String packageName, String className,
			IProject project){
		ICompilationUnit mainCls = createJavaClass(packageName, className + "Server",
				false, null, project);
		IType mainClsType = mainCls.findPrimaryType();
		StringBuffer sb = new StringBuffer();
		sb.append("public static void main(String[] args) {");
		sb.append(LINE_SEPARATOR);
		sb.append("    try {");
		sb.append(LINE_SEPARATOR);
		sb.append("        System.out.println(\"***********************\");");
		sb.append(LINE_SEPARATOR);
		sb.append("        System.out.println(\"" + className
				+ "Service Started and Running...\");");
		sb.append(LINE_SEPARATOR);
		sb.append("        System.out.println(\"***********************\");");
		sb.append(LINE_SEPARATOR);
		sb.append("        System.out.println(\"Hit ENTER to exit\");");
		sb.append(LINE_SEPARATOR);
		sb.append("        System.in.read();");
		sb.append(LINE_SEPARATOR);
		sb.append("        System.out.println(\"***********************\");");
		sb.append(LINE_SEPARATOR);
		sb.append("        System.out.println(\"Server Stopped\");");
		sb.append(LINE_SEPARATOR);
		sb.append("        System.out.println(\"***********************\");");
		sb.append(LINE_SEPARATOR);
		sb.append("        System.exit(0);");
		sb.append(LINE_SEPARATOR);
		sb.append("    } catch ( Exception e ) {");
		sb.append(LINE_SEPARATOR);
		sb.append("        e.printStackTrace();");
		sb.append(LINE_SEPARATOR);
		sb.append("    }");
		sb.append(LINE_SEPARATOR);
		sb.append("}");
		try {
			mainClsType.createMethod(sb.toString(), null, true, null);
			mainCls.save(null, true);
		} catch (JavaModelException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		

	}
	
    public ICompilationUnit createJavaClass(String packageName, String className,
			boolean isInterface, String interfaceName, IProject project) {
    	try {
			IJavaProject javaProject = JDTUtils.findJavaProject(project
					.getName());
			IPath srcPath = project.getFolder(ScaWorkspaceManager.SRC_FOLDER).getFullPath();
			IPackageFragmentRoot root = javaProject
					.findPackageFragmentRoot(srcPath);
			if (packageName == null) {
				packageName = "";
			}
			IPackageFragment pkg = root.createPackageFragment(packageName, false, null);
			ICompilationUnit wrapperCls = pkg.createCompilationUnit(className + ".java", "", true, null);
	        wrapperCls.createPackageDeclaration(packageName, null);

			String clsContent = "";
			if (isInterface) {
				clsContent = "public interface " + className + " {" + LINE_SEPARATOR;
				clsContent += "}" + LINE_SEPARATOR;
			} else {
				clsContent = "public class " + className;
				if (interfaceName != null) {
					clsContent += " implements " + interfaceName;
				}
				clsContent += " {" + LINE_SEPARATOR;
				clsContent += "}" + LINE_SEPARATOR;
			}
			 wrapperCls.createType(clsContent, null, true, null);
			 
			 wrapperCls.save(null, true);
			 return wrapperCls;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
    }		
 
    public void addInterfaceDefaultAnnoation(ICompilationUnit unit) {
    	try {
			CompilationUnit astRoot = JDTUtils.getDomRootCompilationUnit(unit);

			NormalAnnotation ann = JDTUtils.newNormalAnnotation(astRoot,
					Remotable.class.getSimpleName(), null);

			addAnnotation(unit, astRoot, ann, unit.findPrimaryType());
			unit.save(null, true);
			CompilationUnit astSRoot = JDTUtils.getDomRootCompilationUnit(unit);
			NormalAnnotation sann = JDTUtils.newNormalAnnotation(astSRoot,
					Service.class.getSimpleName(), null);

			addAnnotation(unit, astSRoot, sann, unit.findPrimaryType());
			unit.save(null, true);
		} catch (Throwable th) {
			th.printStackTrace();
		}
    }
    

    
    
    
    public void addClsDefaultAnnoation(ICompilationUnit unit, String infName) {
    	try {
			CompilationUnit astRoot = JDTUtils.getDomRootCompilationUnit(unit);

            TypeLiteral typeLiteral = JDTUtils.createTypeLiteralFromClass(astRoot.getAST(), infName);
			Annotation sann = JDTUtils.newSingleMemberAnnotation(astRoot, 
					Service.class.getSimpleName(), 
					typeLiteral);
			addAnnotation(unit, astRoot, sann, unit.findPrimaryType());
			unit.save(null, true);
		} catch (Throwable th) {
			th.printStackTrace();
		}
    }
    
    
    private void addAnnotation(ICompilationUnit unit, CompilationUnit astRoot,
			Annotation annotation, IMember member) throws JavaModelException,
			MalformedTreeException, BadLocationException {
		// creation of a Document
		String source = unit.getBuffer().getContents();
		Document document = new Document(source);

		// creation of ASTRewrite
		ASTRewrite rewrite = ASTRewrite.create(astRoot.getAST());

		if (member instanceof IField) {
			ScaJDTUtils.addAnnotationOnField(astRoot, annotation,
					(IField) member, rewrite);
		} else if (member instanceof IMethod) {
			ScaJDTUtils.addAnnotationOnMethod(astRoot, annotation,
					(IMethod) member, rewrite, true);
		} else if (member instanceof IType) {
			ScaJDTUtils.addAnnotationOnType(astRoot, annotation, (IType) member,
					rewrite, true);
		}

		// computation of the text edits
		TextEdit edits = rewrite.rewriteAST(document, unit.getJavaProject()
				.getOptions(true));

		// computation of the new source code
		edits.apply(document);

		String newSource = document.get();

		// update of the compilation unit
		unit.getBuffer().setContents(newSource);
	}
    
    
    public void addServiceAnnotation(CompilationUnit astRoot) {
//    	JDTUtils.newSingleMemberAnnotation(compilationUnitAstNode, name, exp)(astRoot, Service.class.getSimpleName(), null);
    }
    
}
