/*******************************************************************************

 * Copyright (c) 2007 IONA Technologies PLC

 * All rights reserved. This program and the accompanying materials

 * are made available under the terms of the Eclipse Public License v1.0

 * which accompanies this distribution, and is available at

 * http://www.eclipse.org/legal/epl-v10.html

 * 

 * Contributors:

 *     IONA Technologies PLC - initial API and implementation

 *******************************************************************************/
package org.eclipse.stp.sc.sca.java.wizards;

import org.eclipse.stp.sc.sca.java.ScaJavaResources;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Combo;

/**
 * @author jma
 *
 */
public class ScaComponentPageComposite extends Composite {

	private Group grpClass = null;
	private Label lblPackage = null;
	public Text txtPackage = null;
	private Label lblInterface = null;
	public Text txtInterface = null;
	private Label lblImpl = null;
	public Text txtImpl = null;
	private Group grpComp = null;
	private Label lblCompName = null;
	public Text txtCompName = null;
	private Group grpService = null;
	private Group grpServiceName = null;
	private Label lblService = null;
	Text txtServiceName = null;
	private Group grpBinding = null;
	private Label lblBind = null;
	Combo cmbBinding = null;

	public ScaComponentPageComposite(Composite parent, int style) {
		super(parent, style);
		initialize();
	}

	private void initialize() {
		createGrpClass();
		createGrpComp();
		createGrpService();
		setSize(new Point(300, 292));
		setLayout(new GridLayout());
	}

	/**
	 * This method initializes grpClass	
	 *
	 */
	private void createGrpClass() {
		GridData gridData3 = new GridData();
		gridData3.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData3.grabExcessHorizontalSpace = true;
		GridData gridData2 = new GridData();
		gridData2.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData2.grabExcessHorizontalSpace = true;
		GridData gridData1 = new GridData();
		gridData1.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData1.grabExcessHorizontalSpace = true;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		GridData gridData = new GridData();
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		grpClass = new Group(this, SWT.NONE);
		grpClass.setLayoutData(gridData);
		grpClass.setLayout(gridLayout);
		grpClass.setText(ScaJavaResources.getString("ScaComponentPage_0")); //$NON-NLS-1$
		lblPackage = new Label(grpClass, SWT.NONE);
		lblPackage.setText(ScaJavaResources.getString("ScaComponentPage_1")); //$NON-NLS-1$
		txtPackage = new Text(grpClass, SWT.BORDER);
		txtPackage.setLayoutData(gridData1);
		lblInterface = new Label(grpClass, SWT.NONE);
		lblInterface.setText(ScaJavaResources.getString("ScaComponentPage_2")); //$NON-NLS-1$
		txtInterface = new Text(grpClass, SWT.BORDER);
		txtInterface.setLayoutData(gridData2);
		lblImpl = new Label(grpClass, SWT.NONE);
		lblImpl.setText(ScaJavaResources.getString("ScaComponentPage_3")); //$NON-NLS-1$
		txtImpl = new Text(grpClass, SWT.BORDER);
		txtImpl.setLayoutData(gridData3);
	}

	/**
	 * This method initializes grpComp	
	 *
	 */
	private void createGrpComp() {
		GridData gridData5 = new GridData();
		gridData5.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData5.grabExcessHorizontalSpace = true;
		GridData gridData4 = new GridData();
		gridData4.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData4.grabExcessHorizontalSpace = true;
		GridLayout gridLayout1 = new GridLayout();
		gridLayout1.numColumns = 2;
		grpComp = new Group(this, SWT.NONE);
		grpComp.setText(ScaJavaResources.getString("ScaComponentPage_4")); //$NON-NLS-1$
		grpComp.setLayoutData(gridData4);
		grpComp.setLayout(gridLayout1);
		lblCompName = new Label(grpComp, SWT.NONE);
		lblCompName.setText(ScaJavaResources.getString("ScaComponentPage_5")); //$NON-NLS-1$
		txtCompName = new Text(grpComp, SWT.BORDER);
		txtCompName.setLayoutData(gridData5);
	}

	/**
	 * This method initializes grpService	
	 *
	 */
	private void createGrpService() {
		GridData gridData7 = new GridData();
		gridData7.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData7.grabExcessHorizontalSpace = true;
		grpService = new Group(this, SWT.NONE);
		grpService.setLayout(new GridLayout());
		grpService.setText(ScaJavaResources.getString("ScaComponentPage_6")); //$NON-NLS-1$
		createGrpServiceName();
		grpService.setLayoutData(gridData7);
		createGrpBinding();
	}

	/**
	 * This method initializes grpServiceName	
	 *
	 */
	private void createGrpServiceName() {
		GridData gridData6 = new GridData();
		gridData6.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData6.grabExcessHorizontalSpace = true;
		GridData gridData8 = new GridData();
		gridData8.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData8.grabExcessHorizontalSpace = true;
		GridLayout gridLayout2 = new GridLayout();
		gridLayout2.numColumns = 2;
		grpServiceName = new Group(grpService, SWT.NONE);
		grpServiceName.setLayout(gridLayout2);
		grpServiceName.setLayoutData(gridData8);
		lblService = new Label(grpServiceName, SWT.NONE);
		lblService.setText(ScaJavaResources.getString("ScaComponentPage_7")); //$NON-NLS-1$
		txtServiceName = new Text(grpServiceName, SWT.BORDER);
		txtServiceName.setLayoutData(gridData6);
	}

	/**
	 * This method initializes grpBinding	
	 *
	 */
	private void createGrpBinding() {
		GridData gridData9 = new GridData();
		gridData9.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData9.grabExcessHorizontalSpace = true;
		GridLayout gridLayout3 = new GridLayout();
		gridLayout3.numColumns = 2;
		grpBinding = new Group(grpService, SWT.NONE);
		grpBinding.setText(ScaJavaResources.getString("ScaComponentPage_8")); //$NON-NLS-1$
		grpBinding.setLayoutData(gridData9);
		grpBinding.setLayout(gridLayout3);
		lblBind = new Label(grpBinding, SWT.NONE);
		lblBind.setText(ScaJavaResources.getString("ScaComponentPage_9")); //$NON-NLS-1$
		createCmbBinding();
	}

	/**
	 * This method initializes cmbBinding	
	 *
	 */
	private void createCmbBinding() {
		GridData gridData10 = new GridData();
		gridData10.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData10.grabExcessHorizontalSpace = true;
		cmbBinding = new Combo(grpBinding, SWT.READ_ONLY);
		cmbBinding.setLayoutData(gridData10);
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
