/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.classbuilder;

import java.lang.reflect.Modifier;

/**
 * @author jma
 *
 */
public class JField extends JMember {
	Object initValue;
	Class<?> type;
	
	public JField(String fieldName, Class<?> typeValue) {
		this(fieldName, typeValue, Modifier.PUBLIC);
	}
	
	public JField(String fieldName, Class<?> typeValue, int modifiersValue) {
		this(fieldName, typeValue, modifiersValue, null);
	}
	
	public JField(String fieldName, Class<?> typeValue, int modifiersValue, Object init) {
		super(fieldName, modifiersValue);
		type = typeValue;
		initValue = init;
	}
	
	public Object getInitValue() {
    	return initValue;
    }
    
    public void setInitValue(Object value) {
    	initValue = value;
    }
    
    public Class<?> getType() {
		return type;
	}
    
    public void setType(Class<?> value) {
		type = value;
	}

    public void accept(JVisitor v) throws Exception {
        v.visitField(this);
    }
    
    public String toString() {
    	StringBuffer sb = new StringBuffer();
    	sb.append("  field " + name + " type:" + type.getName());
    	sb.append( ";" + LINE_END);
    	return sb.toString();
    }

}
