/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.stp.soas.deploy.models.deployfile;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Deploy Configuration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration#getSourcePackage <em>Source Package</em>}</li>
 *   <li>{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration#getTargetServer <em>Target Server</em>}</li>
 *   <li>{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration#getConfigOverride <em>Config Override</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage#getDeployConfiguration()
 * @model
 * @generated
 */
public interface DeployConfiguration extends EObject {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "(c) 2004 Sybase, Inc.";

	/**
	 * Returns the value of the '<em><b>Source Package</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage#getTargetConfiguration <em>Target Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Source Package</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Source Package</em>' container reference.
	 * @see #setSourcePackage(DeployPackage)
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage#getDeployConfiguration_SourcePackage()
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage#getTargetConfiguration
	 * @model opposite="targetConfiguration" required="true"
	 * @generated
	 */
	DeployPackage getSourcePackage();

	/**
	 * Sets the value of the '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration#getSourcePackage <em>Source Package</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Source Package</em>' container reference.
	 * @see #getSourcePackage()
	 * @generated
	 */
	void setSourcePackage(DeployPackage value);

	/**
	 * Returns the value of the '<em><b>Target Server</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployServer#getTargetingConfiguration <em>Targeting Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Target Server</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Target Server</em>' reference.
	 * @see #setTargetServer(DeployServer)
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage#getDeployConfiguration_TargetServer()
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployServer#getTargetingConfiguration
	 * @model opposite="targetingConfiguration"
	 * @generated
	 */
	DeployServer getTargetServer();

	/**
	 * Sets the value of the '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration#getTargetServer <em>Target Server</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Target Server</em>' reference.
	 * @see #getTargetServer()
	 * @generated
	 */
	void setTargetServer(DeployServer value);

	/**
	 * Returns the value of the '<em><b>Config Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Config Override</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Config Override</em>' attribute.
	 * @see #setConfigOverride(byte[])
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage#getDeployConfiguration_ConfigOverride()
	 * @model
	 * @generated
	 */
	byte[] getConfigOverride();

	/**
	 * Sets the value of the '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration#getConfigOverride <em>Config Override</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Config Override</em>' attribute.
	 * @see #getConfigOverride()
	 * @generated
	 */
	void setConfigOverride(byte[] value);

} // DeployConfiguration
