/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.stp.soas.deploy.models.deployfile.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EcoreUtil;

import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Deploy Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployConfigurationImpl#getSourcePackage <em>Source Package</em>}</li>
 *   <li>{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployConfigurationImpl#getTargetServer <em>Target Server</em>}</li>
 *   <li>{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployConfigurationImpl#getConfigOverride <em>Config Override</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DeployConfigurationImpl extends EObjectImpl implements
		DeployConfiguration {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "(c) 2004 Sybase, Inc.";

	/**
	 * The cached value of the '{@link #getTargetServer() <em>Target Server</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTargetServer()
	 * @generated
	 * @ordered
	 */
	protected DeployServer targetServer = null;

	/**
	 * The default value of the '{@link #getConfigOverride() <em>Config Override</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConfigOverride()
	 * @generated
	 * @ordered
	 */
	protected static final byte[] CONFIG_OVERRIDE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getConfigOverride() <em>Config Override</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConfigOverride()
	 * @generated
	 * @ordered
	 */
	protected byte[] configOverride = CONFIG_OVERRIDE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeployConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return DeployFilePackage.Literals.DEPLOY_CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeployPackage getSourcePackage() {
		if (eContainerFeatureID != DeployFilePackage.DEPLOY_CONFIGURATION__SOURCE_PACKAGE)
			return null;
		return (DeployPackage) eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSourcePackage(DeployPackage newSourcePackage) {
		if (newSourcePackage != eInternalContainer()
				|| (eContainerFeatureID != DeployFilePackage.DEPLOY_CONFIGURATION__SOURCE_PACKAGE && newSourcePackage != null)) {
			if (EcoreUtil.isAncestor(this, newSourcePackage))
				throw new IllegalArgumentException(
						"Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSourcePackage != null)
				msgs = ((InternalEObject) newSourcePackage).eInverseAdd(this,
						DeployFilePackage.DEPLOY_PACKAGE__TARGET_CONFIGURATION,
						DeployPackage.class, msgs);
			msgs = eBasicSetContainer((InternalEObject) newSourcePackage,
					DeployFilePackage.DEPLOY_CONFIGURATION__SOURCE_PACKAGE,
					msgs);
			if (msgs != null)
				msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DeployFilePackage.DEPLOY_CONFIGURATION__SOURCE_PACKAGE,
					newSourcePackage, newSourcePackage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeployServer getTargetServer() {
		if (targetServer != null && targetServer.eIsProxy()) {
			InternalEObject oldTargetServer = (InternalEObject) targetServer;
			targetServer = (DeployServer) eResolveProxy(oldTargetServer);
			if (targetServer != oldTargetServer) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(
							this,
							Notification.RESOLVE,
							DeployFilePackage.DEPLOY_CONFIGURATION__TARGET_SERVER,
							oldTargetServer, targetServer));
			}
		}
		return targetServer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeployServer basicGetTargetServer() {
		return targetServer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTargetServer(DeployServer newTargetServer,
			NotificationChain msgs) {
		DeployServer oldTargetServer = targetServer;
		targetServer = newTargetServer;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this,
					Notification.SET,
					DeployFilePackage.DEPLOY_CONFIGURATION__TARGET_SERVER,
					oldTargetServer, newTargetServer);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTargetServer(DeployServer newTargetServer) {
		if (newTargetServer != targetServer) {
			NotificationChain msgs = null;
			if (targetServer != null)
				msgs = ((InternalEObject) targetServer)
						.eInverseRemove(
								this,
								DeployFilePackage.DEPLOY_SERVER__TARGETING_CONFIGURATION,
								DeployServer.class, msgs);
			if (newTargetServer != null)
				msgs = ((InternalEObject) newTargetServer)
						.eInverseAdd(
								this,
								DeployFilePackage.DEPLOY_SERVER__TARGETING_CONFIGURATION,
								DeployServer.class, msgs);
			msgs = basicSetTargetServer(newTargetServer, msgs);
			if (msgs != null)
				msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DeployFilePackage.DEPLOY_CONFIGURATION__TARGET_SERVER,
					newTargetServer, newTargetServer));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public byte[] getConfigOverride() {
		return configOverride;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConfigOverride(byte[] newConfigOverride) {
		byte[] oldConfigOverride = configOverride;
		configOverride = newConfigOverride;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DeployFilePackage.DEPLOY_CONFIGURATION__CONFIG_OVERRIDE,
					oldConfigOverride, configOverride));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_CONFIGURATION__SOURCE_PACKAGE:
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			return eBasicSetContainer(otherEnd,
					DeployFilePackage.DEPLOY_CONFIGURATION__SOURCE_PACKAGE,
					msgs);
		case DeployFilePackage.DEPLOY_CONFIGURATION__TARGET_SERVER:
			if (targetServer != null)
				msgs = ((InternalEObject) targetServer)
						.eInverseRemove(
								this,
								DeployFilePackage.DEPLOY_SERVER__TARGETING_CONFIGURATION,
								DeployServer.class, msgs);
			return basicSetTargetServer((DeployServer) otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_CONFIGURATION__SOURCE_PACKAGE:
			return eBasicSetContainer(null,
					DeployFilePackage.DEPLOY_CONFIGURATION__SOURCE_PACKAGE,
					msgs);
		case DeployFilePackage.DEPLOY_CONFIGURATION__TARGET_SERVER:
			return basicSetTargetServer(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainerFeature(
			NotificationChain msgs) {
		switch (eContainerFeatureID) {
		case DeployFilePackage.DEPLOY_CONFIGURATION__SOURCE_PACKAGE:
			return eInternalContainer().eInverseRemove(this,
					DeployFilePackage.DEPLOY_PACKAGE__TARGET_CONFIGURATION,
					DeployPackage.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_CONFIGURATION__SOURCE_PACKAGE:
			return getSourcePackage();
		case DeployFilePackage.DEPLOY_CONFIGURATION__TARGET_SERVER:
			if (resolve)
				return getTargetServer();
			return basicGetTargetServer();
		case DeployFilePackage.DEPLOY_CONFIGURATION__CONFIG_OVERRIDE:
			return getConfigOverride();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_CONFIGURATION__SOURCE_PACKAGE:
			setSourcePackage((DeployPackage) newValue);
			return;
		case DeployFilePackage.DEPLOY_CONFIGURATION__TARGET_SERVER:
			setTargetServer((DeployServer) newValue);
			return;
		case DeployFilePackage.DEPLOY_CONFIGURATION__CONFIG_OVERRIDE:
			setConfigOverride((byte[]) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_CONFIGURATION__SOURCE_PACKAGE:
			setSourcePackage((DeployPackage) null);
			return;
		case DeployFilePackage.DEPLOY_CONFIGURATION__TARGET_SERVER:
			setTargetServer((DeployServer) null);
			return;
		case DeployFilePackage.DEPLOY_CONFIGURATION__CONFIG_OVERRIDE:
			setConfigOverride(CONFIG_OVERRIDE_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_CONFIGURATION__SOURCE_PACKAGE:
			return getSourcePackage() != null;
		case DeployFilePackage.DEPLOY_CONFIGURATION__TARGET_SERVER:
			return targetServer != null;
		case DeployFilePackage.DEPLOY_CONFIGURATION__CONFIG_OVERRIDE:
			return CONFIG_OVERRIDE_EDEFAULT == null ? configOverride != null
					: !CONFIG_OVERRIDE_EDEFAULT.equals(configOverride);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (configOverride: ");
		result.append(configOverride);
		result.append(')');
		return result.toString();
	}

} //DeployConfigurationImpl
