/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ConnectionProfileConstants;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;

/**
 * @author rcernich
 * 
 * Created on Jul 19, 2004
 */
public abstract class DeploySessionBase implements IDeploySession {

	private IConnectionProfile mProfile;

	public DeploySessionBase(IConnectionProfile profile) {
		super();
		mProfile = profile;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IDeploySession#getConnectionProfile()
	 */
	public IConnectionProfile getConnectionProfile() {
		return mProfile;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IDeploySession#preDeployCheck(org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor)
	 */
	public IStatus[] preDeployCheck(IPackageOutputDescriptor descriptor) {
		IConnection connection = getConnectionProfile().createConnection(
				ConnectionProfileConstants.PING_FACTORY_ID);
		try {
			if (connection == null || connection.getRawConnection() == null) {
				Status status = new Status(IStatus.ERROR, DeployCorePlugin
						.getDefault().getBundle().getSymbolicName(), -1,
						DeployCorePlugin.getDefault().getResourceString(
								"DeployCheck.ERROR.CannotConnectToServer", //$NON-NLS-1$
								new Object[] { descriptor.getLogicalName(),
										getConnectionProfile().getName()}),
						null);
				return new IStatus[] { status};
			}
			return new IStatus[0];

		}
		finally {
			if (connection != null) {
				connection.close();
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IDeploySession#deploy(org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor)
	 */
	public abstract void deploy(IPackageOutputDescriptor descriptor)
			throws Exception;
	
	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IDeploySession#deploy(org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor)
	 */
	public abstract void undeploy(IPackageOutputDescriptor descriptor)
			throws Exception;
	
	public abstract IStatus[] preUndeployCheck(IPackageOutputDescriptor descriptor); 
	
	
	
}