/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.datatools.connectivity.IConnectionProfile;

/**
 * This interface is used for creating deployment sessions to connection
 * profiles.  This interface must be implemented by deploy extensions.
 * 
 * @author rcernich
 *
 * Created on Jan 16, 2004
 */
public interface IDeploySessionFactory {

	/**
	 * This method creates a deployment session for the specified connection
	 * profile using the specified user id and password.
	 * 
	 * @param profile the profile to connect to.
	 * 
	 * @return a deployment session if successful; otherwise null
	 */
	IDeploySession createDeploySession(IConnectionProfile profile);

}
