/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;


/**
 * @author rcernich
 *
 * Created on Jul 19, 2004
 */
public interface ITransactionDeploySession extends IDeploySession {

	/**
	 * Indicates the beginning of a deployment.  The deployment driver should
	 * track any changes made between a beginDeploy() and commitDeploy() or
	 * abortDeploy() calls.
	 */
	void beginDeploy();
	
	/**
	 * Indicates the successful completion of a deployment.  Any changes made on
	 * the server since beginDeploy() was called should be commited.
	 */
	void commitDeploy();
	
	/**
	 * Indicates a failed deployment.  Any changes made on the server since
	 * beginDeploy() was called should be rolled back.
	 */
	void abortDeploy();

}
