/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.deploy.models.deployfile.util.Utilities;

/**
 * @author rcernich
 * 
 * Created on Feb 23, 2004
 */
public class CreateDeployFileOperation implements IRunnableWithProgress {

	private static final String DEFAULT_ENCODING = "UTF-8"; //$NON-NLS-1$
	private final IFile mFile;
	private final Root mRoot;

	/**
	 *  
	 */
	public CreateDeployFileOperation(final IFile file, final Root root) {
		super();
		mFile = file;
		mRoot = root;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.operation.IRunnableWithProgress#run(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void run(IProgressMonitor monitor) throws InvocationTargetException,
			InterruptedException {
		try {
			// Cleanup server references in the model.
			Utilities.fixServerReferences(mRoot);

			// Create a resource set
			//
			ResourceSet resourceSet = new ResourceSetImpl();

			// Get the URI of the model file.
			//
			URI fileURI = URI.createPlatformResourceURI(mFile.getFullPath()
					.toString());

			// Create a resource for this file.
			//
			Resource resource = resourceSet.createResource(fileURI);

			// Add the initial model object to the contents.
			//
			resource.getContents().add(mRoot);

			// Save the contents of the resource to the file system.
			//
			Map options = new HashMap();
			options.put(XMLResource.OPTION_ENCODING, DEFAULT_ENCODING);
			resource.save(options);
		}
		catch (Exception exception) {
			exception.printStackTrace();
		}
		finally {
			monitor.done();
		}
	}

}
