/*******************************************************************************
 * Copyright (c) 2005-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.dialogs;

import java.util.Map;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.DialogPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/**
 * @author rcernich
 * 
 * Created on May 11, 2005
 */
public abstract class BaseDeployStatusDialogPage extends DialogPage {

	public static final String PROP_PACKAGE = "package"; //$NON-NLS-1$
	public static final String PROP_SERVER_PROBLEM = "server/problem"; //$NON-NLS-1$

	protected static final int NUM_ROWS = 6;
	protected static final String COLUMN_PROPERTIES[] = { PROP_PACKAGE,
			PROP_SERVER_PROBLEM};

	protected Map mProblemsMap;
	protected boolean mAllowOk;

	/**
	 *  
	 */
	protected BaseDeployStatusDialogPage(String title, Map problemsMap,
											boolean allowOk) {
		super(title);
		setNeedsApplyButton(false);
		mProblemsMap = problemsMap;
		mAllowOk = allowOk;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public final void createControl(Composite parent) {
		final Composite content = new Composite(parent, SWT.NONE);
		content.setLayout(new GridLayout());
		content.setLayoutData(new GridData(GridData.FILL_BOTH));

		final TableTreeViewer viewer = new TableTreeViewer(content, SWT.BORDER
				| SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION);
		viewer.getTableTree().getTable().setHeaderVisible(true);
		viewer.getTableTree().getTable().setLinesVisible(true);
		viewer.setColumnProperties(COLUMN_PROPERTIES);

		GridData data = new GridData(GridData.FILL_BOTH);
		data.heightHint = viewer.getTableTree().getItemHeight() * NUM_ROWS
				+ viewer.getTableTree().getTable().getHeaderHeight();
		viewer.getTableTree().setLayoutData(data);

		final TableLayout layout = new TableLayout();

		TableColumn column = new TableColumn(viewer.getTableTree().getTable(),
				SWT.LEFT);
		column.setText(DeployCorePlugin.getDefault().getResourceString(
				"DeployCheckProblemsTable.column.package")); //$NON-NLS-1$
		column.pack();
		layout.addColumnData(new ColumnWeightData(30, column.getWidth(), true));
		column = new TableColumn(viewer.getTableTree().getTable(), SWT.LEFT);
		column.setText(DeployCorePlugin.getDefault().getResourceString(
				"DeployCheckProblemsTable.column.server_problem")); //$NON-NLS-1$
		column.pack();
		layout.addColumnData(new ColumnWeightData(70, column.getWidth(), true));

		viewer.setContentProvider(new ProblemsContentProvider());
		viewer.setLabelProvider(new ProblemsLabelProvider());
		viewer.setSorter(new ProblemsViewerSorter());
		viewer.setInput(mProblemsMap);

		viewer.expandAll();

		setIsValid(mAllowOk);
		
		setStatusMessage();

		content.addControlListener(new ControlAdapter() {

			public void controlResized(ControlEvent event) {
				// Make sure the columns get sized properly. This prevents the
				// dialog from being huge, plus it sizes the columns to the size
				// of the dialog (TableLayout.layout() only does something the
				// first time it is called).
				if (viewer.getTableTree().getTable().getLayout() == null) {
					viewer.getTableTree().getTable().setLayout(layout);
					content.layout();
				}
			}
		});

		setControl(content);
	}
	
	protected abstract void setStatusMessage(); 

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.ui.dialogs.DialogPage#performOk()
	 */
	public boolean performOk() {
		return true;
	}

	private static class ProblemsContentProvider implements
			ITreeContentProvider {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
		 */
		public Object[] getChildren(Object parentElement) {
			Object[] kids;
			if (parentElement instanceof Map) {
				Map map = (Map) parentElement;
				kids = map.entrySet().toArray(new Map.Entry[map.size()]);
			}
			else if (parentElement instanceof Map.Entry) {
				kids = (IStatus[]) ((Map.Entry) parentElement).getValue();
			}
			else {
				kids = new Object[0];
			}
			return kids;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
		 */
		public Object getParent(Object element) {
			return null;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
		 */
		public boolean hasChildren(Object element) {
			return getChildren(element).length > 0;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
		 */
		public Object[] getElements(Object inputElement) {
			return getChildren(inputElement);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
		 */
		public void dispose() {
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
		 *      java.lang.Object, java.lang.Object)
		 */
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}
	}

	private static class ProblemsLabelProvider extends LabelProvider implements
			ITableLabelProvider {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object,
		 *      int)
		 */
		public Image getColumnImage(Object element, int columnIndex) {
			Image image;
			if (columnIndex < COLUMN_PROPERTIES.length) {
				if (COLUMN_PROPERTIES[columnIndex].equals(PROP_PACKAGE)) {
					if (element instanceof Map.Entry) {
						IStatus[] statuses = (IStatus[]) ((Map.Entry) element)
								.getValue();
						int severity = 0;
						for (int index = 0, count = statuses.length; (severity & IStatus.ERROR) == 0
								&& index < count; ++index) {
							severity |= statuses[index].getSeverity();
						}
						if ((severity & IStatus.ERROR) == IStatus.ERROR) {
							image = PlatformUI.getWorkbench().getSharedImages()
									.getImage(ISharedImages.IMG_OBJS_ERROR_TSK);
						}
						else if ((severity & IStatus.WARNING) == IStatus.WARNING) {
							image = PlatformUI.getWorkbench().getSharedImages()
									.getImage(ISharedImages.IMG_OBJS_WARN_TSK);
						}
						else if ((severity & IStatus.INFO) == IStatus.INFO) {
							image = PlatformUI.getWorkbench().getSharedImages()
									.getImage(ISharedImages.IMG_OBJS_INFO_TSK);
						}
						else {
							image = null;
						}
					}
					else {
						image = null;
					}
				}
				else {
					if (element instanceof Map.Entry) {
						image = null;
					}
					else {
						switch (((IStatus) element).getSeverity()) {
						case IStatus.ERROR:
							image = PlatformUI.getWorkbench().getSharedImages()
									.getImage(ISharedImages.IMG_OBJS_ERROR_TSK);
							break;
						case IStatus.WARNING:
							image = PlatformUI.getWorkbench().getSharedImages()
									.getImage(ISharedImages.IMG_OBJS_WARN_TSK);
							break;
						case IStatus.INFO:
							image = PlatformUI.getWorkbench().getSharedImages()
									.getImage(ISharedImages.IMG_OBJS_INFO_TSK);
							break;
						default:
							image = null;
							break;
						}
					}
				}
			}
			else {
				image = getImage(element);
			}
			return image;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object,
		 *      int)
		 */
		public String getColumnText(Object element, int columnIndex) {
			String text;
			if (columnIndex < COLUMN_PROPERTIES.length) {
				if (COLUMN_PROPERTIES[columnIndex].equals(PROP_PACKAGE)) {
					if (element instanceof Map.Entry) {
						text = ((DeployConfiguration) ((Map.Entry) element)
								.getKey()).getSourcePackage().getPackageFile();
					}
					else {
						text = new String();
					}
				}
				else {
					if (element instanceof Map.Entry) {
						text = ((DeployConfiguration) ((Map.Entry) element)
								.getKey()).getTargetServer().getProfileName();
					}
					else {
						text = ((IStatus) element).getMessage();
					}
				}
			}
			else {
				text = new String();
			}
			return text;
		}
	}

	private static class ProblemsViewerSorter extends ViewerSorter {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.ViewerSorter#compare(org.eclipse.jface.viewers.Viewer,
		 *      java.lang.Object, java.lang.Object)
		 */
		public int compare(Viewer viewer, Object e1, Object e2) {
			int retVal;
			if (e1 instanceof Map.Entry && e2 instanceof Map.Entry) {
				DeployConfiguration dc1 = (DeployConfiguration) ((Map.Entry) e1)
						.getKey();
				DeployConfiguration dc2 = (DeployConfiguration) ((Map.Entry) e2)
						.getKey();
				retVal = dc1.getSourcePackage().getPackageFile().compareTo(
						dc2.getSourcePackage().getPackageFile());
				if (retVal == 0) {
					retVal = dc1.getTargetServer().getProfileName().compareTo(
							dc2.getTargetServer().getProfileName());
				}
			}
			else {
				retVal = 0;
			}
			return retVal;
		}
	}

}