/*******************************************************************************
 * Copyright (c) 2006 IONA Technologies PLC
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies PLC - initial API and implementation
 *******************************************************************************/

package org.eclipse.stp.sc.annvalidator.builder;

import org.eclipse.core.resources.IFile;
import org.eclipse.stp.sc.annvalidator.anntree.AnnXMLTreeBuilder;
import org.eclipse.stp.sc.xmlvalidator.builder.XmlValidator;
import org.w3c.dom.Document;

/**
 * @author jma This class is a builder, extends from XmlValidator. It will look
 *         up all annotations in java source code, generate a dom tree from
 *         those, and pass to XmlValidator to do the rule validation
 */
public class AnnValidator extends XmlValidator {

	public static String BUILDER_ID = "org.eclipse.stp.sc.annvalidator";

	public static String MARKER_ID = "marker";

	AnnXMLTreeBuilder treeBuilder = null;

	public AnnValidator() {
		super();
		treeBuilder = new AnnXMLTreeBuilder();
	}

	/*
	 * protected String importDefaultRules() { //String rulePath =
	 * XmlValidatorPlugin.getDefault().getStateLocation().makeAbsolute().toOSString(); }
	 */

	protected boolean needToValidate(IFile xmlFile) {
		String ext = xmlFile.getFileExtension();
		if (ext.equals("java")) { // todo. put this extension as extension
			// parameter
			return true;
		}
		return false;
	}

	protected Document loadXMLFile(IFile xmlFile) {
		return treeBuilder.loadXMLFile(xmlFile);
	}
}
