package org.eclipse.stp.sc.common.runtimeintegrator;

import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;

/**
 * handles the kit related resources for a given type of runtime provider.
 * See the "org.eclipse.stp.sc.jaxws.runtimeProvider" extension point
 * 
 *  intended to be implemented by users
 */
public interface IRuntimeKitProcessorTemplate extends IExecutableExtension {
    /**
     * returns the default list of library path to add to the build path of a project.
     * the paths have to be relative to the kit root directory: e.g. if the kist is isntalled under 
     * "c:/kit" and the lib we want to add is under "c:/kit/libs/stuff.jar" then the path will have to be
     * "/libs/stuff.jar" 
     * @param project the project for which the paths are supplied.
     * @return the list of libraries to add to the build path.
     */
    List<IPath> getDefaultBuildPathEntries(IProject project);
    
    /**
     * returns the default kit installation directory for the related runtime provider (to use preferences 
     * pages for exemple)
     * @return
     */
    IPath getDefaultInstallDirectory();
    
    /**
     * validate the path provided to make sure it actually points to an installation of the provider's runtime
     * @return true if the path is correct, false otherwise
     */
    boolean isInstallDirectoryValid(IPath installationPath);

    /**
     * returns the default name of the variable that will be used to substitute the installation kit path 
     * in the project build path entries
     * @return
     */
    String getDefaultSubstitutionVarName();
    
    /**
     * validates the list of proposed build path entries and return the list of invalid ones
     * @param proposedBuildPath the build path entries to validate
     * @return the list of invalid build path entries
     */
    List<IPath> validateBuildPathEntries(List<IPath> proposedBuildPath);
}
