package org.eclipse.stp.sc.common.runtimeintegrator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.stp.sc.common.utils.ExtensionRegUtils;

public class RtIntegratorFactory {
    
    protected static final String EXT_CFG_GENERATORTOOL = "generatorTool";
    protected static final String EXT_ATTR_TOOLCLASS = "toolClass";
    protected static final String EXT_ATTR_PARAMETERPAGE = "parameterPage";
    protected static final String EXT_ATTR_ID = "id";
    protected static final String EXT_ATTR_TOOLTYPE = "toolType";
    
    protected static final String EXT_CFG_CONFIGPARAM = "configParam";
    protected static final String EXT_ATTR_PARAMNAME = "paramName";
    protected static final String EXT_ATTR_PARAMVALUE = "paramValue";
    
    protected static final String EXT_CFG_KITPROCESSOR = "KitProcessor";
    protected static final String EXT_ATTR_KITCLASS = "tempClass";
    
    protected static final String EXT_CFG_TARGETSERVER = "targetServer";
    protected static final String EXT_ATTR_SERVERTYPE = "serverType";
    protected static final String EXT_ATTR_SERVERNAME = "serverName";
    protected static final String EXT_ATTR_SERVERVERSION = "serverVersion";
    

    public static ExtRtIntegrator createRuntimeIntegrator(IExtension ext) throws CoreException {
        ExtRtIntegrator integrator = new ExtRtIntegrator();
        integrator.setId(ext.getUniqueIdentifier());
        //process all tools
        for (IConfigurationElement cfg : ext.getConfigurationElements()) {
            if (cfg.getName().equals(EXT_CFG_GENERATORTOOL)) {
                ExtGeneratorTool tool = new ExtGeneratorTool();
                tool.setId(cfg.getAttribute(EXT_ATTR_ID));
                tool.setToolType(cfg.getAttribute(EXT_ATTR_TOOLTYPE));
                tool.setToolClass((IGeneratorTool)
                        cfg.createExecutableExtension(EXT_ATTR_TOOLCLASS));
                if (cfg.getAttribute(EXT_ATTR_PARAMETERPAGE) != null) {
                    tool.setParameterPage((IParameterPage)
                        cfg.createExecutableExtension(EXT_ATTR_PARAMETERPAGE));
                }
                //process tool parameters
                for (IConfigurationElement paramCfg : cfg.getChildren(EXT_CFG_CONFIGPARAM)) {
                    tool.addConfigParam(paramCfg.getAttribute(EXT_ATTR_PARAMNAME),
                            paramCfg.getAttribute(EXT_ATTR_PARAMVALUE));
                }
            }
        }
        
        //process kit template
        IConfigurationElement cfg = ExtensionRegUtils.getConfigElem(ext, EXT_CFG_KITPROCESSOR, null, null);
        if (cfg != null && cfg.getAttribute(EXT_ATTR_KITCLASS) != null) {
            integrator.setKitTemplate((IRuntimeKitProcessorTemplate)
                cfg.createExecutableExtension(EXT_ATTR_KITCLASS));
        }
        
        
        //process the server section
        cfg = 
            ExtensionRegUtils.getConfigElem(ext, EXT_CFG_TARGETSERVER, null, null);
        integrator.setTargetServerName(cfg.getAttribute(EXT_ATTR_SERVERNAME));
        integrator.setTargetServerType(cfg.getAttribute(EXT_ATTR_SERVERTYPE));
        integrator.setTargetServerVersion(cfg.getAttribute(EXT_ATTR_SERVERVERSION));
        return integrator;
    }
}
