/*******************************************************************************

 * Copyright (c) 2006 IONA Technologies PLC

 * All rights reserved. This program and the accompanying materials

 * are made available under the terms of the Eclipse Public License v1.0

 * which accompanies this distribution, and is available at

 * http://www.eclipse.org/legal/epl-v10.html

 * 

 * Contributors:

 *     IONA Technologies PLC - initial API and implementation

 *******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.classbuilder.inst;

/**
 * @author jma
 * enum, planned to list all jvm instructions
 * for now, we just list instructions used in rule class generation 
 */

public enum JInstruction {
	//Stack instructions
	POP { 
		public short value(){ return JStackInst.POP;} 
    },
    POP2 { 
    	public short value(){ return JStackInst.POP2;}
    },
    DUP { 
    	public short value() { return JStackInst.DUP;}
    },
    DUP_X1 { 
    	public short value() {return JStackInst.DUP_X1;}
    },
    
    DUP2_X1 { 
    	public short value(){ return JStackInst.DUP2_X1;} 
    },
    DUP_X2 { 
    	public short value(){ return JStackInst.DUP_X2;}
    },
    DUP2_X2 { 
    	public short value() { return JStackInst.DUP2_X2;}
    },
    SWAP { 
    	public short value() {return JStackInst.SWAP;}
    },
    
    //field instructions
    GETFIELD {
    	public short value() {return JFieldInst.GETFIELD;}
    },
    PUTFIELD {
    	public short value() {return JFieldInst.PUTFIELD;}
    },
    GETSTATIC {
    	public short value() {return JFieldInst.GETSTATIC;}
    },
    PUTSTATIC {
    	public short value() {return JFieldInst.PUTSTATIC;}
    },    
    //load/store insturctions
    LDC {
    	public short value() {return JLSInst.LDC;}
    },
    ALOAD_ {
    	public short value() {return JLSInst.ALOAD_;}
    },
    
    ASTORE_ {
    	public short value() {return JLSInst.ASTORE_;}
    },
    
    
    //Method instructions
    INVOKEVIRTUAL {
    	public short value() {return JMethodInst.INVOKEVIRTUAL;}
    },
    INVOKEINTERFACE {
    	public short value() {return JMethodInst.INVOKEINTERFACE;}
    },
    INVOKESPECIAL {
    	public short value() {return JMethodInst.INVOKESPECIAL;}
    },
    INVOKESTATIC {
    	public short value() {return JMethodInst.INVOKESTATIC;}
    },
    IRETURN {
    	public short value() {return JMethodInst.IRETURN;}
    },
    LRETURN {
    	public short value() {return JMethodInst.LRETURN;}
    },
    FRETURN {
    	public short value() {return JMethodInst.FRETURN;}
    },
    DRETURN {
    	public short value() {return JMethodInst.DRETURN;}
    },
    ARETURN {
    	public short value() {return JMethodInst.ARETURN;}
    },
    RETURN {
    	public short value() {return JMethodInst.RETURN;}
    },
    
    //Object instruction
    NEW {
    	public short value() {return JObjectInst.NEW;}
    },
    INSTANCEOF {
    	public short value() {return JObjectInst.INSTANCEOF;}
    },
    NEWARRAY {
    	public short value() {return JObjectInst.NEWARRAY;}
    },
    
    ;
    public abstract short value();

}
