/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class AbstractUIPluginBase
extends AbstractUIPlugin {
    public static final int INTERNAL_ERROR = 10001;
    public static final String RESOURCES_FILE = "resources";
    private ResourceBundle resourceBundle = null;

    public ResourceBundle loadResourceBundle() throws MissingResourceException {
        String resources = String.valueOf(((Object)((Object)this)).getClass().getPackage().getName()) + '.' + RESOURCES_FILE;
        return ResourceBundle.getBundle(resources, Locale.getDefault(), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private ResourceBundle getResourceBundle() throws MissingResourceException {
        if (this.resourceBundle == null) {
            this.resourceBundle = this.loadResourceBundle();
        }
        return this.resourceBundle;
    }

    private void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/";
        try {
            return ImageDescriptor.createFromURL((URL)this.getBundle().getEntry(String.valueOf(iconPath) + relativePath));
        }
        catch (RuntimeException runtimeException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public Image getImage(String relativePath) {
        return this.getImageDescriptor(relativePath).createImage();
    }

    public String getResourceString(String key) {
        try {
            ResourceBundle resBundle = this.getResourceBundle();
            if (resBundle == null) {
                resBundle = this.loadResourceBundle();
                this.setResourceBundle(resBundle);
            }
            String bundleString = resBundle.getString(key);
            return bundleString;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public String getResourceString(String key, Object[] arguments) {
        MessageFormat f = new MessageFormat(this.getResourceString(key));
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i] == null) {
                arguments[i] = "null";
            } else if (!(arguments[i] instanceof String || arguments[i] instanceof Number || arguments[i] instanceof Date)) {
                arguments[i] = arguments[i].toString();
            }
            ++i;
        }
        return f.format(arguments);
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(String message) {
        this.log(this.createErrorStatus(message));
    }

    public void log(Throwable e) {
        this.log(this.createErrorStatus(e));
    }

    public IPath getInstalledLocation() throws IOException {
        IPath installedDir = null;
        URL installedURL = this.getBundle().getEntry("/");
        URL resolvedURL = FileLocator.resolve((URL)installedURL);
        installedDir = new Path(resolvedURL.getFile()).removeTrailingSeparator();
        return installedDir;
    }

    public IStatus createErrorStatus(String message) {
        return new Status(4, this.getBundle().getSymbolicName(), 10001, message, null);
    }

    public IStatus createErrorStatus(Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 10001, this.getResourceString("plugin.internal_error"), e);
    }
}

