/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.transport.session;

public class CircularShortBuffer {
    int ptr_start = 0;
    int ptr_end = 0;
    int size = 0;
    short[] buf;

    public CircularShortBuffer(int size) {
        this.buf = new short[size];
    }

    public int indexOf(short s) {
        int i = 0;
        while (i < this.size) {
            if (this.get(i) == s) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public short get(int index) {
        if (index > this.size) {
            throw new ArrayIndexOutOfBoundsException("index too high (" + index + " > " + this.size + ")");
        }
        if (this.ptr_start == this.ptr_end && this.size == 0) {
            throw new ArrayIndexOutOfBoundsException("No elements in buffer");
        }
        if ((index = this.ptr_start + index) >= this.buf.length) {
            index -= this.buf.length;
        }
        return this.buf[index];
    }

    public void add(short s) {
        if (this.ptr_start == this.ptr_end && this.size == this.buf.length) {
            throw new ArrayIndexOutOfBoundsException("No room left in circular buffer");
        }
        this.buf[this.ptr_end++] = s;
        if (this.ptr_end == this.buf.length) {
            this.ptr_end = 0;
        }
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    public void discard(int count) {
        if (count > this.size) {
            throw new ArrayIndexOutOfBoundsException("Cannot discard more than entirity of buffer (" + this.size + ") elements");
        }
        this.ptr_start += count;
        if (this.ptr_start >= this.buf.length) {
            this.ptr_start -= this.buf.length;
        }
        this.size -= count;
    }

    public static void main(String[] args) {
        int s;
        CircularShortBuffer cb = new CircularShortBuffer(100);
        int i = 0;
        while (i < 100) {
            cb.add((short)i);
            ++i;
        }
        System.out.println("Added 100 elements OK");
        if (cb.size() != 100) {
            new Exception("Incorrect size reported").printStackTrace();
            System.exit(0);
        }
        System.out.println("Size OK");
        i = 0;
        while (i < 100) {
            s = cb.get(i);
            if (i != s) {
                new Exception("MISMATCH").printStackTrace();
                System.exit(0);
            }
            ++i;
        }
        System.out.println("Checked 100 elements OK");
        if (cb.size() != 100) {
            new Exception("Incorrect size reported").printStackTrace();
            System.exit(0);
        }
        System.out.println("Size OK");
        try {
            cb.add((short)101);
            new Exception("Upper limit failed").printStackTrace();
            System.exit(0);
        }
        catch (Exception exception) {}
        System.out.println("Upper limit OK");
        cb.discard(50);
        System.out.println("Discarded 50 elements");
        if (cb.size() != 50) {
            new Exception("Incorrect size reported").printStackTrace();
            System.exit(0);
        }
        System.out.println("Size OK");
        i = 0;
        while (i < 50) {
            s = cb.get(i);
            if (50 + i != s) {
                new Exception("MISMATCH").printStackTrace();
                System.exit(0);
            }
            ++i;
        }
        System.out.println("Checked 50 elements OK");
        cb.discard(50);
        System.out.println("Discarded 50 elements");
        if (cb.size() != 0) {
            new Exception("Incorrect size reported").printStackTrace();
            System.exit(0);
        }
        System.out.println("Size OK");
        try {
            cb.get(0);
            new Exception("Should be empty but returned value").printStackTrace();
            System.exit(0);
        }
        catch (Exception exception) {}
        System.out.println("Emptiness OK");
        i = 0;
        while (i < 40) {
            cb.add((short)i);
            ++i;
        }
        System.out.println("Added 40 elements OK");
        if (cb.size() != 40) {
            new Exception("Incorrect size reported").printStackTrace();
            System.exit(0);
        }
        System.out.println("Size OK");
        i = 0;
        while (i < 40) {
            s = cb.get(i);
            if (s != i) {
                new Exception("MISMATCH").printStackTrace();
                System.exit(0);
            }
            ++i;
        }
        System.out.println("Checked 40 elements OK");
        cb.discard(40);
        System.out.println("Discarded 40 elements");
        if (cb.size() != 0) {
            new Exception("Incorrect size reported").printStackTrace();
            System.exit(0);
        }
        System.out.println("Size OK");
    }
}

