/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.AbstractFlowBorder;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.NamedBpmnObject;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityCanonicalEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityGraphicalNodeEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.figures.WrapLabelWithToolTip;
import org.eclipse.stp.bpmn.figures.activities.ActivityDiamondFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityNodeFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityOvalFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityPainter;
import org.eclipse.stp.bpmn.figures.connectionanchors.IConnectionAnchorFactory;
import org.eclipse.stp.bpmn.figures.connectionanchors.IModelAwareAnchor;
import org.eclipse.stp.bpmn.figures.connectionanchors.WrapperNodeFigureEx;
import org.eclipse.stp.bpmn.figures.connectionanchors.impl.ConnectionAnchorFactory;
import org.eclipse.stp.bpmn.layouts.ActivityLayout;
import org.eclipse.stp.bpmn.policies.BpmnDragDropEditPolicy;
import org.eclipse.stp.bpmn.policies.ConnectionHandleEditPolicyEx;
import org.eclipse.stp.bpmn.policies.OpenFileEditPolicy;
import org.eclipse.stp.bpmn.policies.ResizableActivityEditPolicy;
import org.eclipse.stp.bpmn.tools.TaskDragEditPartsTrackerEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityEditPart
extends ShapeNodeEditPart {
    private static final int SHAPE_RECTANGLE = 0;
    private static final int SHAPE_DIAMOND = 1;
    private static final int SHAPE_CIRCLE = 2;
    public static final int EVENT_FIGURE_SIZE = 30;
    public static final int GATEWAY_FIGURE_SIZE = 50;
    public static final Dimension ACTIVITY_FIGURE_SIZE = new Dimension(111, 61);
    public static final int VISUAL_ID = 2001;
    private int handlePosition;
    protected boolean isChildAdded = false;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private IModelAwareAnchor.INodeFigureAnchorTerminalUpdatable wrappedFigure;

    public ActivityEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ActivityItemSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ActivityGraphicalNodeEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new ActivityCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        super.getViewer().getEditDomain();
        this.removeEditPolicy("ConnectionHandlesPolicy");
        this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)this.createConnectionHandlerEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new BpmnDragDropEditPolicy((IGraphicalEditPart)this));
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenFileEditPolicy());
    }

    protected DiagramAssistantEditPolicy createConnectionHandlerEditPolicy() {
        return new ConnectionHandleEditPolicyEx();
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = ActivityEditPart.this.getPrimaryDragEditPolicy();
                    if (result != null) {
                        return result;
                    }
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        super.installEditPolicy(key, editPolicy);
    }

    protected IFigure createNodeShapeGen() {
        ActivityFigure figure = new ActivityFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    protected IFigure createNodeShape() {
        ActivityFigure figure = (ActivityFigure)this.createNodeShapeGen();
        Activity activity = (Activity)this.getPrimaryView().getElement();
        this.setActivityTypeAndLabelAndLayout(figure, activity);
        figure.setLooping(activity.isLooping());
        return figure;
    }

    private boolean setActivityTypeAndLabelAndLayout(ActivityFigure activityFigure, Activity activity) {
        activityFigure.setActivityType(activity.getActivityType().getName());
        boolean res = false;
        WrapLabel wl = activityFigure.getFigureActivityNameFigure();
        if (activity.getName() == null) {
            if (activity.getActivityType().equals((Object)ActivityType.TASK_LITERAL) && !"Task".equals(wl.getText())) {
                wl.setText("Task");
            }
            res = true;
        }
        if (activity.getActivityType().equals((Object)ActivityType.TASK_LITERAL)) {
            if (!(activityFigure.getLayoutManager() instanceof StackLayout)) {
                StackLayout layout = new StackLayout();
                activityFigure.setLayoutManager((LayoutManager)layout);
                res = true;
            }
            wl.setTextAlignment(16);
        } else {
            if (wl != null) {
                wl.setTextAlignment(8);
                wl.setPreferredSize(ActivityEditPart.ACTIVITY_FIGURE_SIZE.width, 0);
            }
            if (!(activityFigure.getLayoutManager() instanceof ConstrainedToolbarLayout)) {
                ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
                layout.setSpacing(this.getMapMode().DPtoLP(5));
                activityFigure.setLayoutManager((LayoutManager)layout);
                res = true;
            }
        }
        activityFigure.invalidate();
        return res;
    }

    public ActivityFigure getPrimaryShape() {
        return (ActivityFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ActivityNameEditPart) {
            ((ActivityNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureActivityNameFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    protected IConnectionAnchorFactory getConnectionAnchorFactory() {
        return ConnectionAnchorFactory.INSTANCE;
    }

    protected NodeFigure createNodePlate() {
        return new WrapperNodeFigureEx(this.getConnectionAnchorFactory(), this.createWrappedFigure()){

            public Rectangle getHandleBounds() {
                Rectangle rectangle = super.getHandleBounds();
                Activity activity = (Activity)ActivityEditPart.this.resolveSemanticElement();
                if (activity == null || activity.getActivityType() == null || activity.getActivityType().equals((Object)ActivityType.TASK_LITERAL)) {
                    return rectangle;
                }
                return ((IFigure)ActivityEditPart.this.wrappedFigure.getChildren().get(0)).getBounds();
            }
        };
    }

    private IModelAwareAnchor.INodeFigureAnchorTerminalUpdatable createWrappedFigure() {
        Activity activity = (Activity)this.getPrimaryView().getElement();
        int activityType = activity.getActivityType().getValue();
        int shapeType = ActivityEditPart.getShapeType(activityType);
        if (shapeType == 0) {
            int width = this.getMapMode().DPtoLP(ActivityEditPart.ACTIVITY_FIGURE_SIZE.width);
            int height = this.getMapMode().DPtoLP(ActivityEditPart.ACTIVITY_FIGURE_SIZE.height);
            this.wrappedFigure = new ActivityNodeFigure(this.getConnectionAnchorFactory(), width, height);
        } else if (shapeType == 1) {
            int width = this.getMapMode().DPtoLP(50);
            int height = this.getMapMode().DPtoLP(50);
            this.wrappedFigure = new ActivityNodeFigure(this.getConnectionAnchorFactory(), width, height);
        } else {
            int width = this.getMapMode().DPtoLP(30);
            int height = this.getMapMode().DPtoLP(30);
            this.wrappedFigure = new ActivityNodeFigure(this.getConnectionAnchorFactory(), width, height);
        }
        this.wrappedFigure.setLayoutManager((LayoutManager)new StackLayout());
        return this.wrappedFigure;
    }

    private void buildFigure(IFigure container, IFigure shape, WrapLabel wrapLabel, int size) {
        int resultSize = this.getMapMode().DPtoLP(size);
        container.setSize(resultSize, resultSize + 30);
        ActivityLayout layout = new ActivityLayout();
        this.wrappedFigure.setLayoutManager(layout);
        container.setLayoutManager((LayoutManager)new BorderLayout());
        container.add(shape, (Object)BorderLayout.CENTER);
        this.wrappedFigure.add(container, BorderLayout.CENTER);
        this.wrappedFigure.add((IFigure)wrapLabel, BorderLayout.BOTTOM);
        wrapLabel.setLabelAlignment(2);
        ((ActivityFigure)shape).setFigureActivityNameFigure(wrapLabel);
        this.contentPane = this.setupContentPane(this.wrappedFigure);
    }

    protected NodeFigure createNodeFigure() {
        boolean event;
        NodeFigure figure = this.createNodePlate();
        IFigure shape = this.createNodeShape();
        ActivityType activityType = ((Activity)this.getPrimaryView().getElement()).getActivityType();
        boolean gateway = ActivityType.VALUES_GATEWAYS.contains(activityType);
        boolean bl = event = ActivityType.VALUES_EVENTS.contains(activityType) || ActivityType.VALUES_EVENTS_INTERMEDIATE.contains(activityType);
        if (gateway) {
            int size = this.getMapMode().DPtoLP(50);
            ActivityDiamondFigure diamondFigure = new ActivityDiamondFigure(this.getConnectionAnchorFactory(), new Dimension(size, size));
            WrapLabelWithToolTip label = new WrapLabelWithToolTip(this.getToolTipProvider(), null, null, true, 8);
            this.buildFigure(diamondFigure, shape, label, 50);
        } else if (event) {
            int size = this.getMapMode().DPtoLP(30);
            ActivityOvalFigure ovalFigure = new ActivityOvalFigure(this.getConnectionAnchorFactory(), new Dimension(size, size));
            WrapLabelWithToolTip label = new WrapLabelWithToolTip(this.getToolTipProvider(), null, null, true, 8);
            this.buildFigure(ovalFigure, shape, label, 30);
        } else {
            this.wrappedFigure.add(shape);
            this.contentPane = this.setupContentPane(shape);
        }
        return figure;
    }

    protected IFigure setupContentPaneGen(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            EObject element = ((Node)this.getModel()).getElement();
            int activityType = ((Activity)element).getActivityType().getValue();
            if (activityType == 0) {
                StackLayout layout = new StackLayout();
                nodeShape.setLayoutManager((LayoutManager)layout);
            } else {
                return this.setupContentPaneGen(nodeShape);
            }
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(BpmnVisualIDRegistry.getType(4001));
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    private boolean isEventOrGateway() {
        boolean event;
        ActivityType activityType = ((Activity)this.getPrimaryView().getElement()).getActivityType();
        boolean gateway = ActivityType.VALUES_GATEWAYS.contains(activityType);
        boolean bl = event = ActivityType.VALUES_EVENTS.contains(activityType) || ActivityType.VALUES_EVENTS_INTERMEDIATE.contains(activityType);
        return gateway || event;
    }

    protected void handleNotificationEvent(Notification notification) {
        if (notification.getEventType() == 1 || notification.getEventType() == 2) {
            if (BpmnPackage.eINSTANCE.getActivity_ActivityType().equals(notification.getFeature())) {
                this.handleMajorSemanticChange();
                return;
            }
            if (BpmnPackage.eINSTANCE.getActivity_Looping().equals(notification.getFeature())) {
                this.getPrimaryShape().setLooping(notification.getNewBooleanValue());
            }
            Activity activity = (Activity)this.getPrimaryView().getElement();
            if (this.getPrimaryShape() != null && this.setActivityTypeAndLabelAndLayout(this.getPrimaryShape(), activity)) {
                this.refreshVisuals();
            }
        }
        super.handleNotificationEvent(notification);
    }

    public void refreshSourceConnections() {
        try {
            super.refreshSourceConnections();
            this.updateAnchors(true);
        }
        catch (Exception exception) {
            EObject eo = this.resolveSemanticElement();
            System.err.println("looks like a corrupted thing " + eo);
        }
    }

    public void refreshTargetConnections() {
        try {
            super.refreshTargetConnections();
            this.updateAnchors(false);
        }
        catch (Exception exception) {
            EObject eo = this.resolveSemanticElement();
            System.err.println("looks like a corrupted thing " + eo);
        }
    }

    private void updateAnchors(boolean sourceOnly) {
        int ind;
        View model;
        ConnectionEditPart connEditPart;
        HashMap<EObject, ConnectionEditPart> connIndex = new HashMap<EObject, ConnectionEditPart>();
        for (Object object : this.getSourceConnections()) {
            connEditPart = (ConnectionEditPart)object;
            model = (View)connEditPart.getModel();
            connIndex.put(model.getElement(), connEditPart);
        }
        for (Object object : this.getTargetConnections()) {
            connEditPart = (ConnectionEditPart)object;
            model = (View)connEditPart.getModel();
            connIndex.put(model.getElement(), connEditPart);
        }
        Activity act = (Activity)((Node)this.getModel()).getElement();
        FeatureMap messages = act.getOrderedMessages();
        int totalLength = messages.size();
        int i = 0;
        for (FeatureMap.Entry msg : messages) {
            switch (msg.getEStructuralFeature().getFeatureID()) {
                case 11: {
                    this.setAnchorIndex(connIndex, (EModelElement)msg.getValue(), i, totalLength, true);
                    ++i;
                    break;
                }
                case 10: {
                    this.setAnchorIndex(connIndex, (EModelElement)msg.getValue(), i, totalLength, false);
                    ++i;
                    break;
                }
                default: {
                    throw new IllegalStateException("Corrupted model?");
                }
            }
        }
        if (sourceOnly) {
            EList outEdges = act.getOutgoingEdges();
            ind = 0;
            totalLength = outEdges.size();
            for (SequenceEdge edge : outEdges) {
                this.setAnchorIndex(connIndex, (EModelElement)edge, i, totalLength, true);
                ++ind;
            }
        } else {
            EList inEdges = act.getIncomingEdges();
            ind = 0;
            totalLength = inEdges.size();
            for (SequenceEdge edge : inEdges) {
                this.setAnchorIndex(connIndex, (EModelElement)edge, i, totalLength, false);
                ++ind;
            }
        }
        if (!sourceOnly) {
            int ii = 0;
            int l = act.getAssociations().size();
            for (Association assoc : act.getAssociations()) {
                this.setAnchorIndex(connIndex, (EModelElement)assoc, ii, l, false);
                ++i;
            }
        }
    }

    protected String getEdgeType(EModelElement obj) {
        if (obj instanceof SequenceEdge) {
            return String.valueOf(3001);
        }
        if (obj instanceof MessagingEdge) {
            return String.valueOf(3002);
        }
        if (obj instanceof Association) {
            return String.valueOf(3003);
        }
        return null;
    }

    protected void setAnchorIndex(Map<EObject, ConnectionEditPart> connIndex, EModelElement semanticModelOfConn, int index, int totalLength, boolean isSource) {
        ConnectionEditPart conn = connIndex.get(semanticModelOfConn);
        if (conn != null) {
            ConnectionAnchor anchor;
            String edgeType = this.getEdgeType(semanticModelOfConn);
            PolylineConnectionEx connFigure = (PolylineConnectionEx)conn.getFigure();
            ConnectionAnchor connectionAnchor = anchor = isSource ? connFigure.getSourceAnchor() : connFigure.getTargetAnchor();
            if (anchor instanceof IModelAwareAnchor) {
                ((IModelAwareAnchor)anchor).setConnectionType(isSource, edgeType, index, totalLength);
                conn.refresh();
            }
        }
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new ResizableActivityEditPolicy();
    }

    private static int getShapeType(int activityType) {
        int shapeType;
        switch (activityType) {
            case 0: {
                shapeType = 0;
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                shapeType = 1;
                break;
            }
            default: {
                shapeType = 2;
            }
        }
        return shapeType;
    }

    public DragTracker getDragTracker(Request request) {
        return new TaskDragEditPartsTrackerEx((EditPart)this);
    }

    protected WrapLabelWithToolTip.IToolTipProvider getToolTipProvider() {
        return ActivityPainter.createToolTipProvider((NamedBpmnObject)this.resolveSemanticElement(), true);
    }

    public class ActivityFigure
    extends org.eclipse.stp.bpmn.figures.activities.ActivityFigure {
        private WrapLabel fActivityNameFigure;
        private boolean myUseLocalCoordinates = false;

        public ActivityFigure() {
            Activity a = (Activity)ActivityEditPart.this.resolveSemanticElement();
            if (a != null) {
                this.setActivityType(a.getActivityType().getName());
            } else {
                this.setActivityType(ActivityType.TASK_LITERAL.getName());
            }
            this.setForegroundColor(ColorConstants.black);
            this.createContents();
        }

        private void createContents() {
            ActivityType activityType = ((Activity)ActivityEditPart.this.getPrimaryView().getElement()).getActivityType();
            if (activityType.equals((Object)ActivityType.TASK_LITERAL)) {
                this.createContentsGen();
            }
        }

        private void createContentsGen() {
            WrapLabelWithToolTip fig_0 = new WrapLabelWithToolTip(ActivityEditPart.this.getToolTipProvider(), null, null, true, 2);
            fig_0.setText("Task");
            this.setBorder((Border)new AbstractFlowBorder(){

                public int getLeftMargin() {
                    return 2;
                }

                public int getRightMargin() {
                    return 2;
                }

                public Insets getInsets(IFigure figure) {
                    return new Insets(0, 2, 0, 2);
                }
            });
            this.setFigureActivityNameFigure(fig_0);
            Object layData0 = null;
            this.add((IFigure)fig_0, layData0);
        }

        public WrapLabel getFigureActivityNameFigure() {
            return this.fActivityNameFigure;
        }

        private void setFigureActivityNameFigure(WrapLabel fig) {
            this.fActivityNameFigure = fig;
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }
    }
}

