/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DeselectAllTracker;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.policies.PoolPoolCompartmentCanonicalEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.PoolPoolCompartmentItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.figures.FixedOneLineBorder;
import org.eclipse.stp.bpmn.figures.PoolPoolCompartmentFigure;
import org.eclipse.stp.bpmn.policies.BpmnDragDropEditPolicy;
import org.eclipse.stp.bpmn.policies.ContainerNodeEditPolicyEx;
import org.eclipse.stp.bpmn.policies.NonResizableCollapsibleCompartmentEditPolicy;
import org.eclipse.stp.bpmn.policies.OpenFileEditPolicy;
import org.eclipse.stp.bpmn.policies.PoolPoolCompartmentXYLayoutEditPolicy;
import org.eclipse.stp.bpmn.policies.PopupBarEditPolicyEx;
import org.eclipse.stp.bpmn.policies.SubProcessCreationEditPolicy;
import org.eclipse.stp.bpmn.tools.RubberbandDragTrackerForBPMN;
import org.eclipse.stp.bpmn.tools.TaskDragHelper;
import org.eclipse.swt.graphics.Color;

public class PoolPoolCompartmentEditPart
extends ShapeCompartmentEditPart {
    public static final Insets INSETS = new Insets(5, 6, 5, 5);
    public static final Color POOLCOMPARTMENTFIGURE_BORDER = new Color(null, 169, 169, 169);
    public static final int VISUAL_ID = 5001;
    private final String POOL_ANNOTATION_SOURCE = "Pool_Annotation";
    private final String WIDTH = "width";
    private final String HEIGHT = "height";

    public PoolPoolCompartmentEditPart(View view) {
        super(view);
    }

    public String getCompartmentNameGen() {
        return "PoolCompartment";
    }

    public String getCompartmentName() {
        Pool a;
        EObject bpmnObj = this.getPrimaryView().getElement();
        if (bpmnObj instanceof Pool && (a = (Pool)bpmnObj).getName() != null) {
            if (a.getName().toLowerCase().indexOf("pool") == -1) {
                return "Pool " + a.getName();
            }
            return a.getName();
        }
        return "Pool";
    }

    public IFigure createFigureGen() {
        ResizableCompartmentFigure result = (ResizableCompartmentFigure)super.createFigure();
        result.setTitleVisibility(false);
        return result;
    }

    public IFigure createFigure() {
        PoolPoolCompartmentFigure result = new PoolPoolCompartmentFigure(this.getCompartmentName(), this.getMapMode());
        result.getContentPane().setLayoutManager(this.getLayoutManager());
        result.getContentPane().addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        result.setTitleVisibility(false);
        result.setOpaque(false);
        FixedOneLineBorder border = new FixedOneLineBorder(POOLCOMPARTMENTFIGURE_BORDER, 1, 1);
        result.setBorder((Border)border);
        return result;
    }

    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new PoolPoolCompartmentItemSemanticEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new PoolPoolCompartmentCanonicalEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.installEditPolicy("PopupBarEditPolicy", (EditPolicy)new PopupBarEditPolicyEx());
        this.removeEditPolicy("CreationPolicy");
        this.installEditPolicy("CreationPolicy", (EditPolicy)new SubProcessCreationEditPolicy());
        NonResizableCollapsibleCompartmentEditPolicy dragPolicy = new NonResizableCollapsibleCompartmentEditPolicy();
        dragPolicy.setDragAllowed(false);
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)dragPolicy);
        this.removeEditPolicy("GraphicalNodeEditPolicy");
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ContainerNodeEditPolicyEx());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new PoolPoolCompartmentXYLayoutEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new BpmnDragDropEditPolicy((IGraphicalEditPart)this));
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenFileEditPolicy());
    }

    protected void setRatio(Double ratio) {
        if (this.getFigure().getParent().getLayoutManager() instanceof ConstrainedToolbarLayout) {
            super.setRatio(ratio);
        }
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        super.handlePropertyChangeEvent(event);
        TaskDragHelper.handlePropertyChangeEvent(event, this);
    }

    protected List getModelChildren() {
        Object model = this.getModel();
        if (model != null && model instanceof View) {
            EList list = ((View)model).getVisibleChildren();
            ArrayList res = new ArrayList();
            for (Object object : list) {
                Node node = (Node)object;
                if (node.getType().equals(Integer.toString(2007))) {
                    res.add(0, object);
                    continue;
                }
                res.add(object);
            }
            return res;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isSelectable() {
        return true;
    }

    public void setSelected(int value) {
        if (value == 2) {
            this.getViewer().select(this.getParent());
            return;
        }
        super.setSelected(value);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(adapter);
    }

    protected void setCollapsed(boolean collapsed, boolean animate) {
        super.setCollapsed(collapsed, animate);
        PoolEditPart poolEditPart = (PoolEditPart)this.getParent();
        PoolNameEditPart nameEditPart = (PoolNameEditPart)poolEditPart.getPrimaryChildEditPart();
        nameEditPart.setCollapsed(collapsed, animate);
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getDrawerStyle_Collapsed().equals(feature)) {
            this.handleCollapseExpand();
        }
        super.handleNotificationEvent(event);
    }

    private void handleCollapseExpand() {
        int newHeight;
        int newWidth;
        View view;
        EAnnotation annotation;
        boolean isCollapsed = (Boolean)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed());
        PoolEditPart poolEditPart = (PoolEditPart)this.getParent();
        int oldX = (Integer)poolEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int oldY = (Integer)poolEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        int oldHeight = (Integer)poolEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        int oldWidth = (Integer)poolEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        if (oldHeight == -1) {
            oldHeight = 200;
        }
        if ((annotation = (view = poolEditPart.getPrimaryView()).getEAnnotation("Pool_Annotation")) == null) {
            annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource("Pool_Annotation");
            view.getEAnnotations().add((Object)annotation);
        }
        EMap details = annotation.getDetails();
        String height = (String)details.get((Object)"height");
        Dimension minimalDim = new Dimension(32, 32);
        if (height == null) {
            if (isCollapsed) {
                newWidth = Math.max(oldWidth, minimalDim.width);
                newHeight = Math.max(32, minimalDim.height);
            } else {
                newWidth = Math.max(oldWidth, minimalDim.width);
                newHeight = Math.max(SubProcessEditPart.EXPANDED_SIZE.height, minimalDim.height);
            }
        } else {
            newWidth = Math.max(minimalDim.width, oldWidth);
            newHeight = Math.max(minimalDim.height, Integer.parseInt(height));
        }
        details.put((Object)"height", (Object)Integer.toString(oldHeight));
        if (newHeight != oldHeight) {
            Rectangle subprocessBounds = new Rectangle(oldX, oldY, newWidth, newHeight);
            this.setNewBounds(subprocessBounds, new Dimension(newHeight, oldHeight), isCollapsed);
            if (!isCollapsed) {
                poolEditPart.refresh();
            }
        }
    }

    private void setNewBounds(Rectangle newBounds, Dimension oldSize, boolean isCollapsed) {
        SetBoundsCommand setBoundsCommandLabel;
        Rectangle labelBounds;
        CompositeCommand compoudCommand = new CompositeCommand("Set new bounds on pool collapse/expand");
        Rectangle newTotalBounds = new Rectangle(newBounds);
        SetBoundsCommand changeThisBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "Set new bounds for pool collapse/expand", (IAdaptable)this.getParent(), newTotalBounds);
        compoudCommand.add((IUndoableOperation)changeThisBoundsCommand);
        PoolEditPart poolEditPart = (PoolEditPart)this.getParent();
        List siblings = poolEditPart.getParent().getChildren();
        int dy = newBounds.height - oldSize.height;
        if (isCollapsed) {
            labelBounds = newBounds.getCopy();
            labelBounds.crop(INSETS);
            --labelBounds.width;
            setBoundsCommandLabel = new SetBoundsCommand(this.getEditingDomain(), "Set bounds pool label", (IAdaptable)poolEditPart.getPrimaryChildEditPart(), labelBounds);
            compoudCommand.add((IUndoableOperation)setBoundsCommandLabel);
            ((GraphicalEditPart)poolEditPart.getPrimaryChildEditPart()).getFigure().setSize(new Dimension(labelBounds.width, labelBounds.height));
        } else {
            labelBounds = newBounds.getCopy();
            labelBounds.crop(INSETS);
            labelBounds.width = 32;
            setBoundsCommandLabel = new SetBoundsCommand(this.getEditingDomain(), "Set bounds pool label", (IAdaptable)poolEditPart.getPrimaryChildEditPart(), labelBounds);
            compoudCommand.add((IUndoableOperation)setBoundsCommandLabel);
        }
        for (Object sibling : siblings) {
            org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart siblingEditPart = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)sibling;
            if (siblingEditPart == poolEditPart) continue;
            Rectangle currSiblingBounds = siblingEditPart.getFigure().getBounds().getCopy();
            Rectangle bounds = currSiblingBounds.getCopy();
            if (bounds.y <= newBounds.y) continue;
            bounds.y += dy;
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "Set bounds", (IAdaptable)siblingEditPart, bounds);
            compoudCommand.add((IUndoableOperation)setBoundsCommand);
            newTotalBounds.union(bounds);
        }
        try {
            compoudCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public DragTracker getDragTracker(Request req) {
        if (!this.supportsDragSelection()) {
            return super.getDragTracker(req);
        }
        if (req instanceof SelectionRequest && ((SelectionRequest)req).getLastButtonPressed() == 3) {
            return new DeselectAllTracker((EditPart)this){

                protected boolean handleButtonDown(int button) {
                    this.getCurrentViewer().select((EditPart)PoolPoolCompartmentEditPart.this);
                    return true;
                }
            };
        }
        return new RubberbandDragTrackerForBPMN(){

            protected void handleFinished() {
                if (PoolPoolCompartmentEditPart.this.getViewer().getSelectedEditParts().isEmpty()) {
                    PoolPoolCompartmentEditPart.this.getViewer().select((EditPart)PoolPoolCompartmentEditPart.this);
                }
            }
        };
    }
}

