/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.policies;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.AssociationEditPart;
import org.eclipse.stp.bpmn.diagram.edit.policies.BpmnGraphicalNodeEditPolicy;

public class ActivityGraphicalNodeEditPolicy
extends BpmnGraphicalNodeEditPolicy {
    protected Command getReconnectTargetCommand(final ReconnectRequest request) {
        final ConnectionEditPart moving = request.getConnectionEditPart();
        if (request.getTarget() != moving.getTarget()) {
            return super.getReconnectTargetCommand(request);
        }
        if (moving instanceof AssociationEditPart) {
            return super.getReconnectTargetCommand(request);
        }
        final boolean isMessagingEdge = ((IGraphicalEditPart)moving).resolveSemanticElement() instanceof MessagingEdge;
        int interesting = ((GraphicalEditPart)moving.getTarget()).getFigure().getBounds().y;
        boolean below = ((PolylineConnection)moving.getFigure()).getTargetAnchor().getLocation(null).y > interesting;
        HashMap<Point, ConnectionEditPart> srcEps = new HashMap<Point, ConnectionEditPart>();
        for (Object src : ((IGraphicalEditPart)this.getHost()).getSourceConnections()) {
            Point loc = ((PolylineConnection)((ConnectionEditPart)src).getFigure()).getSourceAnchor().getLocation(null);
            if (!this.isInteresting(interesting, below, src, true) || !(((IGraphicalEditPart)src).resolveSemanticElement() instanceof MessagingEdge)) continue;
            srcEps.put(loc, (ConnectionEditPart)src);
        }
        HashMap<Point, ConnectionEditPart> tgtEps = new HashMap<Point, ConnectionEditPart>();
        for (Object target : ((IGraphicalEditPart)this.getHost()).getTargetConnections()) {
            Point loc = ((PolylineConnection)((ConnectionEditPart)target).getFigure()).getTargetAnchor().getLocation(null);
            if (moving.equals(target)) continue;
            if (this.isInteresting(interesting, below, target, false) && ((IGraphicalEditPart)target).resolveSemanticElement() instanceof MessagingEdge) {
                tgtEps.put(loc, (ConnectionEditPart)target);
                continue;
            }
            if (isMessagingEdge || !(((IGraphicalEditPart)target).resolveSemanticElement() instanceof SequenceEdge)) continue;
            tgtEps.put(loc, (ConnectionEditPart)target);
        }
        if (tgtEps.isEmpty() && srcEps.isEmpty()) {
            return super.getReconnectTargetCommand(request);
        }
        tgtEps.put(request.getLocation(), moving);
        final LinkedList points = new LinkedList(tgtEps.keySet());
        points.addAll(srcEps.keySet());
        Comparator<Point> comparator = new Comparator<Point>(){

            @Override
            public int compare(Point o1, Point o2) {
                if (isMessagingEdge) {
                    if (o1.x < o2.x) {
                        return -1;
                    }
                    return 1;
                }
                if (o1.y < o2.y) {
                    return -1;
                }
                return 1;
            }
        };
        Collections.sort(points, comparator);
        final Activity target = (Activity)((IGraphicalEditPart)moving.getTarget()).resolveSemanticElement();
        CompoundCommand compound = new CompoundCommand();
        AbstractTransactionalCommand command = new AbstractTransactionalCommand((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)target), "Changing the order of the edges", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                for (Point p : points) {
                    if (!p.equals((Object)request.getLocation())) continue;
                    int index = points.indexOf(p);
                    EObject edge = ((IGraphicalEditPart)moving).resolveSemanticElement();
                    int newentry = index;
                    int oldentry = -1;
                    if (isMessagingEdge) {
                        int i = 0;
                        while (i < target.getOrderedMessages().size()) {
                            EObject msg = (EObject)target.getOrderedMessages().getValue(i);
                            if (msg.equals(edge)) {
                                oldentry = i;
                                break;
                            }
                            ++i;
                        }
                        target.getOrderedMessages().move(newentry, oldentry);
                        break;
                    }
                    int i = 0;
                    while (i < target.getIncomingEdges().size()) {
                        EObject msg = (EObject)target.getIncomingEdges().get(i);
                        if (msg.equals(edge)) {
                            oldentry = i;
                            break;
                        }
                        ++i;
                    }
                    target.getIncomingEdges().move(newentry, oldentry);
                    break;
                }
                ((ActivityEditPart)ActivityGraphicalNodeEditPolicy.this.getHost()).refreshSourceConnections();
                ((ActivityEditPart)ActivityGraphicalNodeEditPolicy.this.getHost()).refreshTargetConnections();
                return CommandResult.newOKCommandResult();
            }
        };
        compound.add((Command)new ICommandProxy((ICommand)command));
        compound.add(super.getReconnectTargetCommand(request));
        return compound;
    }

    protected Command getReconnectSourceCommand(final ReconnectRequest request) {
        final ConnectionEditPart moving = request.getConnectionEditPart();
        if (request.getTarget() != moving.getSource()) {
            return super.getReconnectSourceCommand(request);
        }
        if (moving instanceof AssociationEditPart) {
            return super.getReconnectSourceCommand(request);
        }
        final boolean isMessagingEdge = ((IGraphicalEditPart)moving).resolveSemanticElement() instanceof MessagingEdge;
        int interesting = ((GraphicalEditPart)moving.getSource()).getFigure().getBounds().y;
        boolean below = ((PolylineConnection)moving.getFigure()).getSourceAnchor().getLocation(null).y > interesting;
        HashMap<Point, ConnectionEditPart> srcEps = new HashMap<Point, ConnectionEditPart>();
        for (Object src : ((IGraphicalEditPart)this.getHost()).getSourceConnections()) {
            Point loc = ((PolylineConnection)((ConnectionEditPart)src).getFigure()).getSourceAnchor().getLocation(null);
            if (moving.equals(src)) continue;
            if (isMessagingEdge && this.isInteresting(interesting, below, src, true) && ((IGraphicalEditPart)src).resolveSemanticElement() instanceof MessagingEdge) {
                srcEps.put(loc, (ConnectionEditPart)src);
                continue;
            }
            if (isMessagingEdge || !(((IGraphicalEditPart)src).resolveSemanticElement() instanceof SequenceEdge)) continue;
            srcEps.put(loc, (ConnectionEditPart)src);
        }
        HashMap<Point, ConnectionEditPart> tgtEps = new HashMap<Point, ConnectionEditPart>();
        for (Object target : ((IGraphicalEditPart)this.getHost()).getTargetConnections()) {
            Point loc = ((PolylineConnection)((ConnectionEditPart)target).getFigure()).getTargetAnchor().getLocation(null);
            if (!isMessagingEdge || !this.isInteresting(interesting, below, target, false) || !(((IGraphicalEditPart)target).resolveSemanticElement() instanceof MessagingEdge)) continue;
            tgtEps.put(loc, (ConnectionEditPart)target);
        }
        if (tgtEps.isEmpty() && srcEps.isEmpty()) {
            return super.getReconnectSourceCommand(request);
        }
        srcEps.put(request.getLocation(), moving);
        final LinkedList points = new LinkedList(tgtEps.keySet());
        points.addAll(srcEps.keySet());
        Comparator<Point> comparator = new Comparator<Point>(){

            @Override
            public int compare(Point o1, Point o2) {
                if (isMessagingEdge) {
                    if (o1.x < o2.x) {
                        return -1;
                    }
                    return 1;
                }
                if (o1.y < o2.y) {
                    return -1;
                }
                return 1;
            }
        };
        Collections.sort(points, comparator);
        final Activity target = (Activity)((IGraphicalEditPart)moving.getSource()).resolveSemanticElement();
        CompoundCommand compound = new CompoundCommand();
        AbstractTransactionalCommand command = new AbstractTransactionalCommand((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)target), "Changing the order of the edges", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                for (Point p : points) {
                    if (!p.equals((Object)request.getLocation())) continue;
                    int index = points.indexOf(p);
                    EObject edge = ((IGraphicalEditPart)moving).resolveSemanticElement();
                    int newentry = index;
                    int oldentry = -1;
                    if (isMessagingEdge) {
                        int i = 0;
                        while (i < target.getOrderedMessages().size()) {
                            EObject msg = (EObject)target.getOrderedMessages().getValue(i);
                            if (msg.equals(edge)) {
                                oldentry = i;
                                break;
                            }
                            ++i;
                        }
                        target.getOrderedMessages().move(newentry, oldentry);
                        break;
                    }
                    int i = 0;
                    while (i < target.getOutgoingEdges().size()) {
                        EObject msg = (EObject)target.getOutgoingEdges().get(i);
                        if (msg.equals(edge)) {
                            oldentry = i;
                            break;
                        }
                        ++i;
                    }
                    target.getOutgoingEdges().move(newentry, oldentry);
                    break;
                }
                ((ActivityEditPart)ActivityGraphicalNodeEditPolicy.this.getHost()).refreshSourceConnections();
                ((ActivityEditPart)ActivityGraphicalNodeEditPolicy.this.getHost()).refreshTargetConnections();
                return CommandResult.newOKCommandResult();
            }
        };
        compound.add((Command)new ICommandProxy((ICommand)command));
        compound.add(super.getReconnectSourceCommand(request));
        return compound;
    }

    private boolean isInteresting(int interesting, boolean below, Object ep, boolean lookSource) {
        ConnectionAnchor anchor = lookSource ? ((PolylineConnection)((GraphicalEditPart)ep).getFigure()).getSourceAnchor() : ((PolylineConnection)((GraphicalEditPart)ep).getFigure()).getTargetAnchor();
        int y = anchor.getLocation(null).y;
        if (below) {
            return y > interesting;
        }
        return y <= interesting;
    }
}

