/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.IdentifiableNode;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.tools.EdgeConnectionValidator;
import org.eclipse.stp.bpmn.tools.MessageConnectionValidator;

public class BpmnReorientRelationshipCommand
extends Command {
    protected final ReorientRelationshipRequest _req;

    public BpmnReorientRelationshipCommand(ReorientRelationshipRequest req) {
        super("reorient relationship");
        this._req = req;
    }

    public boolean canExecute() {
        return this.canExecute(this._req.getNewRelationshipEnd(), this._req.getOldRelationshipEnd());
    }

    private boolean canExecute(EObject newEnd, EObject oldEnd) {
        if (newEnd != null && oldEnd != null && newEnd != oldEnd) {
            if (this._req.getRelationship() instanceof Association) {
                if (this._req.getDirection() == 1) {
                    if (newEnd instanceof Artifact) {
                        return !this.alreadyConnected((Artifact)newEnd, ((Association)this._req.getRelationship()).getTarget());
                    }
                    return false;
                }
                if (newEnd instanceof IdentifiableNode) {
                    return !this.alreadyConnected(((Association)this._req.getRelationship()).getSource(), (IdentifiableNode)newEnd);
                }
                return false;
            }
            if (this._req.getRelationship() instanceof SequenceEdge) {
                if (newEnd instanceof Activity) {
                    Activity act = (Activity)newEnd;
                    if (this._req.getDirection() == 2) {
                        return EdgeConnectionValidator.INSTANCE.canConnect((EObject)((SequenceEdge)this._req.getRelationship()).getSource(), (EObject)act);
                    }
                    return EdgeConnectionValidator.INSTANCE.canConnect((EObject)act, (EObject)((SequenceEdge)this._req.getRelationship()).getTarget());
                }
            } else if (this._req.getRelationship() instanceof MessagingEdge && newEnd instanceof Activity) {
                Activity act = (Activity)newEnd;
                if (this._req.getDirection() == 2) {
                    return MessageConnectionValidator.INSTANCE.canConnect((EObject)((MessagingEdge)this._req.getRelationship()).getSource(), (EObject)act);
                }
                return MessageConnectionValidator.INSTANCE.canConnect((EObject)act, (EObject)((MessagingEdge)this._req.getRelationship()).getTarget());
            }
        }
        return false;
    }

    private boolean alreadyConnected(Artifact src, IdentifiableNode target) {
        for (Association assoc : src.getAssociations()) {
            if (!target.equals(assoc.getTarget())) continue;
            return true;
        }
        return false;
    }

    public boolean canUndo() {
        return this.canExecute(this._req.getOldRelationshipEnd(), this._req.getNewRelationshipEnd());
    }

    public void execute() {
        this.connect(this._req.getNewRelationshipEnd(), this._req.getOldRelationshipEnd());
    }

    public void undo() {
        this.connect(this._req.getOldRelationshipEnd(), this._req.getNewRelationshipEnd());
    }

    protected void connect(EObject newEnd, EObject oldEnd) {
        if (this._req.getRelationship() instanceof Association) {
            if (this._req.getDirection() == 1) {
                ((Association)this._req.getRelationship()).setSource((Artifact)newEnd);
            } else {
                ((Association)this._req.getRelationship()).setTarget((IdentifiableNode)newEnd);
            }
        } else if (this._req.getRelationship() instanceof SequenceEdge) {
            if (this._req.getDirection() == 1) {
                ((SequenceEdge)this._req.getRelationship()).setSource((Vertex)newEnd);
            } else {
                ((SequenceEdge)this._req.getRelationship()).setTarget((Vertex)newEnd);
            }
        } else if (this._req.getRelationship() instanceof MessagingEdge) {
            if (this._req.getDirection() == 1) {
                ((MessagingEdge)this._req.getRelationship()).setSource((Activity)newEnd);
            } else {
                ((MessagingEdge)this._req.getRelationship()).setTarget((Activity)newEnd);
            }
        }
    }
}

