/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.IEditableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class ArrangeSelectionAction
extends DiagramAction {
    private static final String ACTION_TEXT = "Arrange Selection NEW";
    private static final String TOOLTIP_TEXT = "Arrange Selection NEW";
    private static final String ICON_PATH = "icons/arrangeselected.gif";
    public static final String ACTION_ARRANGE_SELECTION = "arrangeSelectionAction2";
    public static final String ACTION_TOOLBAR_ARRANGE_SELECTION = "toolbarArrangeSelectionAction2";

    protected ArrangeSelectionAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
        this.setId(ACTION_ARRANGE_SELECTION);
    }

    protected ArrangeSelectionAction(IWorkbenchPart workbenchPart) {
        super(workbenchPart);
        this.setId(ACTION_ARRANGE_SELECTION);
    }

    private static ArrangeSelectionAction createActionWithoutId(IWorkbenchPage workbenchPage) {
        ArrangeSelectionAction action = new ArrangeSelectionAction(workbenchPage);
        action.setId(ACTION_TOOLBAR_ARRANGE_SELECTION);
        action.setText("Arrange Selection NEW");
        action.setToolTipText("Arrange Selection NEW");
        action.setImageDescriptor(BpmnDiagramEditorPlugin.getBundledImageDescriptor(ICON_PATH));
        return action;
    }

    public static ArrangeSelectionAction createArrangeSelectionAction(IWorkbenchPage workbenchPage) {
        ArrangeSelectionAction action = ArrangeSelectionAction.createActionWithoutId(workbenchPage);
        action.setId(ACTION_ARRANGE_SELECTION);
        return action;
    }

    public static ArrangeSelectionAction createToolbarArrangeSelectionAction(IWorkbenchPage workbenchPage) {
        ArrangeSelectionAction action = ArrangeSelectionAction.createActionWithoutId(workbenchPage);
        action.setId(ACTION_TOOLBAR_ARRANGE_SELECTION);
        return action;
    }

    protected Request createTargetRequest() {
        return new ArrangeRequest(this.getId());
    }

    protected void updateTargetRequest() {
        ArrangeRequest request = (ArrangeRequest)this.getTargetRequest();
        request.setPartsToArrange(this.getOperationSet());
    }

    protected Command getCommand() {
        EditPart parent;
        if (this.getOperationSet().size() >= 2 && (parent = this.getSelectionParent(this.getOperationSet())) != null) {
            return parent.getCommand(this.getTargetRequest());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean calculateEnabled() {
        GraphicalEditPart parent;
        List operationSet = this.getOperationSet();
        EditPart parentEP = this.getSelectionParent(operationSet);
        if (parentEP instanceof IEditableEditPart && !((IEditableEditPart)parentEP).isEditModeEnabled()) {
            return false;
        }
        for (Object next : operationSet) {
            if (!(next instanceof IEditableEditPart) || ((IEditableEditPart)next).isEditModeEnabled()) continue;
            return false;
        }
        return operationSet.size() >= 2 && parentEP instanceof GraphicalEditPart && (parent = (GraphicalEditPart)parentEP) != null && parent.getContentPane().getLayoutManager() instanceof XYLayout;
    }

    protected List createOperationSet() {
        List selection = this.getSelectedObjects();
        if (selection.isEmpty() || !(selection.get(0) instanceof IGraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        selection = ToolUtilities.getSelectionWithoutDependants((List)selection);
        return this.createOperationSet(selection);
    }

    private EditPart getSelectionParent(List editparts) {
        ListIterator li = editparts.listIterator();
        while (li.hasNext()) {
            Object obj = li.next();
            if (obj instanceof ConnectionEditPart || !(obj instanceof EditPart)) continue;
            return ((EditPart)obj).getParent();
        }
        return null;
    }

    private List createOperationSet(List editparts) {
        if (editparts == null || editparts.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (editparts.size() == 1 && editparts.get(0) instanceof SubProcessEditPart && (editparts = ((SubProcessEditPart)((Object)editparts.get(0))).getChildBySemanticHint(Integer.toString(5002)).getChildren()).isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        EditPart parent = this.getSelectionParent(editparts);
        if (parent == null) {
            return Collections.EMPTY_LIST;
        }
        int i = 1;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            if (!(part instanceof ConnectionEditPart) && part.getParent() != parent) {
                return Collections.EMPTY_LIST;
            }
            ++i;
        }
        return editparts;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramEditPart().getDiagramPreferencesHint().getPreferenceStore();
        boolean animatedLayout = preferenceStore.getBoolean("Global.enableAnimatedLayout");
        if (animatedLayout) {
            Animation.markBegin();
        }
        super.doRun(progressMonitor);
        if (animatedLayout) {
            int durationInc = 800;
            int factor = 10;
            int size = 0;
            List operationSet = this.getOperationSet();
            if (operationSet != null && !operationSet.isEmpty()) {
                IGraphicalEditPart container = (IGraphicalEditPart)this.getSelectionParent(operationSet);
                size += container.getFigure().getChildren().size();
            }
            int totalDuration = Math.min(durationInc * factor / 2, Math.max(durationInc, size / factor * durationInc));
            Animation.run((int)totalDuration);
        }
    }
}

