/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.part;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.bpmn.dnd.IEAnnotationDecorator;
import org.eclipse.stp.bpmn.dnd.ISecondarySemanticHintProcessor;
import org.eclipse.stp.bpmn.provider.BpmnItemProviderAdapterFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpmnDiagramEditorPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.stp.bpmn.diagram";
    public static final PreferencesHint DIAGRAM_PREFERENCES_HINT = new PreferencesHint("org.eclipse.stp.bpmn.diagram");
    private static BpmnDiagramEditorPlugin instance;
    private ComposedAdapterFactory adapterFactory;
    public static IPreferenceStore PREF_STORE;
    private Map<String, IEAnnotationDecorator> _annotationDecoratorCache;
    private List<ISecondarySemanticHintProcessor> _secondarySemanticHintProcessorCache;
    public static final String BPMN_DND_HANDLER_EXTENSION_POINT = "org.eclipse.stp.bpmn.diagram.BpmnDnD";
    public static final String EANNOTATION_DECORATOR_EXTENSION_POINT = "org.eclipse.stp.bpmn.diagram.EAnnotationDecorator";
    public static final String SECONDARY_SEMANTIC_HINT_PROCESSOR_EXTENSION_POINT = "org.eclipse.stp.bpmn.diagram.SecondarySemanticHintProcessor";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        PreferencesHint.registerPreferenceStore((PreferencesHint)DIAGRAM_PREFERENCES_HINT, (Object)this.getPreferenceStore());
        this.adapterFactory = this.createAdapterFactory();
        this.initEAnnotationDecoratorRegistry();
        this.initSecondarySemanticHintProcessorRegistry();
    }

    public IPreferenceStore getPreferenceStore() {
        if (PREF_STORE == null) {
            PREF_STORE = super.getPreferenceStore();
        }
        return PREF_STORE;
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        this.adapterFactory.dispose();
        this.adapterFactory = null;
        super.stop(context);
    }

    public static BpmnDiagramEditorPlugin getInstance() {
        return instance;
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ArrayList factories = new ArrayList();
        this.fillItemProviderFactories(factories);
        return new ComposedAdapterFactory(factories);
    }

    protected void fillItemProviderFactories(List factories) {
        factories.add(new BpmnItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
    }

    public AdapterFactory getItemProvidersAdapterFactory() {
        return this.adapterFactory;
    }

    public ImageDescriptor getItemImageDescriptor(Object item) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class);
        if (labelProvider != null) {
            return ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage(item));
        }
        return null;
    }

    public static ImageDescriptor getBundledImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public Image getBundledImage(String path) {
        ImageDescriptor descriptor = this.getImageRegistry().getDescriptor(path);
        if (descriptor == null) {
            this.getImageRegistry().put(path, BpmnDiagramEditorPlugin.getBundledImageDescriptor(path));
        }
        return this.getImageRegistry().get(path);
    }

    public void logError(String error) {
        this.logError(error, null);
    }

    public void logError(String error, Throwable throwable) {
        if (error == null && throwable != null) {
            error = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(4, ID, 0, error, throwable));
        this.debug(error, throwable);
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Throwable throwable) {
        if (message == null && message != null) {
            message = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(1, ID, 0, message, throwable));
        this.debug(message, throwable);
    }

    private void debug(String message, Throwable throwable) {
        if (!this.isDebugging()) {
            return;
        }
        if (message != null) {
            System.err.println(message);
        }
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public IEAnnotationDecorator getEAnnotationDecorator(String annotationSource) {
        return this._annotationDecoratorCache.get(annotationSource);
    }

    public List<ISecondarySemanticHintProcessor> getSecondarySemanticHintParsers() {
        return this._secondarySemanticHintProcessorCache;
    }

    private void initEAnnotationDecoratorRegistry() {
        this._annotationDecoratorCache = new HashMap<String, IEAnnotationDecorator>();
        IConfigurationElement[] configElems = Platform.getExtensionRegistry().getConfigurationElementsFor(EANNOTATION_DECORATOR_EXTENSION_POINT);
        int j = configElems.length - 1;
        while (j >= 0) {
            try {
                String sourceAtt = configElems[j].getAttribute("source");
                if (sourceAtt != null) {
                    IEAnnotationDecorator res = (IEAnnotationDecorator)configElems[j].createExecutableExtension("class");
                    this._annotationDecoratorCache.put(sourceAtt, res);
                }
            }
            catch (Exception e) {
                this.logError(e.getMessage(), e);
            }
            --j;
        }
    }

    private void initSecondarySemanticHintProcessorRegistry() {
        this._secondarySemanticHintProcessorCache = new ArrayList<ISecondarySemanticHintProcessor>();
        IConfigurationElement[] configElems = Platform.getExtensionRegistry().getConfigurationElementsFor(SECONDARY_SEMANTIC_HINT_PROCESSOR_EXTENSION_POINT);
        int j = configElems.length - 1;
        while (j >= 0) {
            try {
                ISecondarySemanticHintProcessor res = (ISecondarySemanticHintProcessor)configElems[j].createExecutableExtension("class");
                this._secondarySemanticHintProcessorCache.add(res);
            }
            catch (Exception e) {
                this.logError(e.getMessage(), e);
            }
            --j;
        }
    }
}

